/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { AppStatus } from './app-status.model';

export class PartitionInfo {
  name: string;
  value: string;

  constructor(name: string, value: string) {
    this.name = name;
    this.value = value;
  }
}

export interface Partition {
  name: string;
  state: string;
  clusterId: string;
  capacity: Capacity;
  nodeSortingPolicy: NodeSortingPolicy;
  applications: Applications;
  lastStateTransitionTime: string;
  totalNodes: number;
  totalContainers: number;
}

export interface Capacity {
  capacity: string;
  usedCapacity: string;
}

export interface Applications extends Record<AppStatus, number> {
  total: number;
}

export interface NodeSortingPolicy {
  type: string;
  resourceWeights: {
    memory: number;
    vcore: number;
  };
}
