/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.commands;

import java.io.PrintStream;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.rules.Rule;
import org.apache.unomi.api.services.RuleListenerService;
import org.apache.unomi.shell.commands.TailCommandSupport;

@Command(scope="unomi", name="rule-watch", description="This will watch the specified rules evaluating and executing in the Apache Unomi Context Server")
@Service
public class RuleWatch
extends TailCommandSupport {
    @Argument(index=0, name="ruleIds", description="Identifier(s) of rule(s) to watch", required=true, multiValued=true)
    String[] ruleIds;
    int[] columnSizes = new int[]{10, 36, 36, 14, 36, 29, 15, 5};
    String[] columnHeaders = new String[]{"Status", "Rule ID", "Rule Name", "Event Type", "Session", "Profile", "Timestamp", "Scope"};

    @Override
    public int[] getColumnSizes() {
        return this.columnSizes;
    }

    @Override
    public String[] getColumnHeaders() {
        return this.columnHeaders;
    }

    @Override
    public Object getListener() {
        return new RuleWatchListener(this.session.getConsole());
    }

    class RuleWatchListener
    implements RuleListenerService {
        PrintStream out;

        public RuleWatchListener(PrintStream out) {
            this.out = out;
        }

        public void onEvaluate(Rule rule, Event event) {
            this.populateRuleInfo(rule, event, "EVALUATE");
        }

        public void onAlreadyRaised(RuleListenerService.AlreadyRaisedFor alreadyRaisedFor, Rule rule, Event event) {
            this.populateRuleInfo(rule, event, "AR " + alreadyRaisedFor.toString());
        }

        public void onExecuteActions(Rule rule, Event event) {
            this.populateRuleInfo(rule, event, "EXECUTE");
        }

        public void populateRuleInfo(Rule rule, Event event, String status) {
            if (!ArrayUtils.contains((Object[])RuleWatch.this.ruleIds, (Object)rule.getItemId())) {
                return;
            }
            ArrayList<String> ruleExecutionInfo = new ArrayList<String>();
            ruleExecutionInfo.add(status);
            ruleExecutionInfo.add(rule.getItemId());
            ruleExecutionInfo.add(rule.getMetadata().getName());
            ruleExecutionInfo.add(event.getEventType());
            ruleExecutionInfo.add(event.getSessionId());
            ruleExecutionInfo.add(event.getProfileId());
            ruleExecutionInfo.add(event.getTimeStamp().toString());
            ruleExecutionInfo.add(event.getScope());
            RuleWatch.this.outputLine(this.out, ruleExecutionInfo);
        }
    }
}

