/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cpm;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import org.apache.uima.tools.cpm.CloseTabIcon;
import org.apache.uima.tools.cpm.TabClosedListener;

public class JTabbedPaneWithCloseIcons
extends JTabbedPane
implements MouseListener {
    private static final long serialVersionUID = 7680554379341154297L;
    private TabClosedListener tabClosedListener;

    public JTabbedPaneWithCloseIcons() {
        this.addMouseListener(this);
    }

    public void addTabClosedListener(TabClosedListener aTabClosedListener) {
        this.tabClosedListener = aTabClosedListener;
    }

    @Override
    public void addTab(String title, Component component) {
        this.addTab(title, component, null);
    }

    public void addTab(String title, Component component, Icon extraIcon) {
        super.addTab(title, new CloseTabIcon(extraIcon), component);
    }

    public void moveTab(int fromIndex, int toIndex) {
        Component componentToMove = this.getComponentAt(fromIndex);
        String title = this.getTitleAt(fromIndex);
        Icon icon = this.getIconAt(fromIndex);
        this.remove(fromIndex);
        this.add(componentToMove, icon, toIndex);
        this.setTitleAt(toIndex, title);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int tabIndex = this.getUI().tabForCoordinate(this, e.getX(), e.getY());
        if (tabIndex < 0) {
            return;
        }
        Rectangle rect = ((CloseTabIcon)this.getIconAt(tabIndex)).getBounds();
        if (rect.contains(e.getX(), e.getY())) {
            this.removeTabAt(tabIndex);
            if (this.tabClosedListener != null) {
                this.tabClosedListener.tabClosed(this, tabIndex);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

