/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.thread;

import java.util.AbstractQueue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.resource.thread.ThreadFactories;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.threads.impl.ContextServiceImpl;
import org.apache.openejb.threads.impl.ContextServiceImplFactory;
import org.apache.openejb.threads.impl.ManagedExecutorServiceImpl;
import org.apache.openejb.threads.impl.ManagedThreadFactoryImpl;
import org.apache.openejb.threads.reject.CURejectHandler;
import org.apache.openejb.util.Duration;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class ManagedExecutorServiceImplFactory {
    private int core = 5;
    private int max = 25;
    private Duration keepAlive = new Duration("5 second");
    private int queue = 15;
    private String threadFactory;
    private String context;

    public static ManagedExecutorServiceImpl lookup(String name) throws NamingException {
        Object obj;
        try {
            obj = InitialContext.doLookup(name);
        }
        catch (NamingException e) {
            Context ctx = SystemInstance.get().getComponent(ContainerSystem.class).getJNDIContext();
            if (name.equals("java:comp/DefaultManagedExecutorService")) {
                name = "Default Managed Executor Service";
            }
            obj = ctx.lookup("openejb/Resource/" + name);
        }
        if (!(obj instanceof ManagedExecutorServiceImpl)) {
            throw new IllegalArgumentException("Resource with id " + name + " is not a ManagedExecutorService, but is " + obj.getClass().getName());
        }
        ManagedExecutorServiceImpl mes = (ManagedExecutorServiceImpl)obj;
        return mes;
    }

    public ManagedExecutorServiceImpl create() {
        return new ManagedExecutorServiceImpl(this.createExecutorService(), ContextServiceImplFactory.lookupOrDefault(this.context));
    }

    public ManagedExecutorServiceImpl create(ContextServiceImpl contextService) {
        return new ManagedExecutorServiceImpl(this.createExecutorService(), contextService);
    }

    private ExecutorService createExecutorService() {
        ManagedThreadFactoryImpl managedThreadFactory;
        AbstractQueue blockingQueue = this.queue < 0 ? new LinkedBlockingQueue() : (this.queue == 0 ? new SynchronousQueue() : new ArrayBlockingQueue(this.queue));
        try {
            managedThreadFactory = "org.apache.openejb.threads.impl.ManagedThreadFactoryImpl".equals(this.threadFactory) ? new ManagedThreadFactoryImpl("managed-thread-", null, ContextServiceImplFactory.lookupOrDefault(this.context)) : ThreadFactories.findThreadFactory(this.threadFactory);
        }
        catch (Exception e) {
            Logger.getInstance(LogCategory.OPENEJB, ManagedExecutorServiceImplFactory.class).warning("Can't create configured thread factory: " + this.threadFactory, e);
            managedThreadFactory = new ManagedThreadFactoryImpl("managed-thread-", null, ContextServiceImplFactory.lookupOrDefault(this.context));
        }
        if (this.core > this.max) {
            Logger.getInstance(LogCategory.OPENEJB, ManagedExecutorServiceImplFactory.class).warning("Core size (=" + this.core + ") is bigger than Max size (=" + this.max + "), lowering Core to Max");
            this.core = this.max;
        }
        return new ThreadPoolExecutor(this.core, this.max, this.keepAlive.getTime(), this.keepAlive.getUnit(), (BlockingQueue<Runnable>)((Object)blockingQueue), (ThreadFactory)((Object)managedThreadFactory), CURejectHandler.INSTANCE);
    }

    public void setCore(int core) {
        this.core = core;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public void setKeepAlive(Duration keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void setQueue(int queue) {
        this.queue = queue;
    }

    public void setThreadFactory(String threadFactory) {
        this.threadFactory = threadFactory;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }
}

