/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.bval.util.StringUtils;
import org.apache.bval.util.reflection.Reflection;
import org.apache.commons.weaver.privilizer.Privilizing;

@Privilizing(value={@Privilizing.CallTo(value=Reflection.class)})
public class BValVersion {
    public static final String PROJECT_NAME = "Apache BVal";
    public static final String PROJECT_ID;
    public static final String VERSION_NUMBER;
    public static final int MAJOR_RELEASE;
    public static final int MINOR_RELEASE;
    public static final int PATCH_RELEASE;
    public static final String RELEASE_STATUS;
    public static final String REVISION_NUMBER;

    public static String getVersion() {
        return VERSION_NUMBER;
    }

    public static String getRevision() {
        return REVISION_NUMBER;
    }

    public static String getName() {
        return PROJECT_NAME;
    }

    public static String getID() {
        return PROJECT_ID;
    }

    public static void main(String[] args) {
        System.out.println(new BValVersion().toString());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(3200);
        this.appendBanner(buf);
        buf.append("\n");
        this.appendProperty("os.name", buf).append("\n");
        this.appendProperty("os.version", buf).append("\n");
        this.appendProperty("os.arch", buf).append("\n\n");
        this.appendProperty("java.version", buf).append("\n");
        this.appendProperty("java.vendor", buf).append("\n\n");
        buf.append("java.class.path:\n");
        StringTokenizer tok = new StringTokenizer(Reflection.getProperty("java.class.path"));
        while (tok.hasMoreTokens()) {
            buf.append("\t").append(tok.nextToken());
            buf.append("\n");
        }
        buf.append("\n");
        this.appendProperty("user.dir", buf).append("\n");
        return buf.toString();
    }

    private void appendBanner(StringBuilder buf) {
        buf.append("Project").append(": ").append(BValVersion.getName());
        buf.append("\n");
        buf.append("Version").append(": ").append(BValVersion.getVersion());
        buf.append("\n");
        buf.append("Revision").append(": ").append(BValVersion.getRevision());
        buf.append("\n");
    }

    private StringBuilder appendProperty(String prop, StringBuilder buf) {
        return buf.append(prop).append(": ").append(Reflection.getProperty(prop));
    }

    static {
        int patch;
        int minor;
        int major;
        Properties revisionProps = new Properties();
        try (InputStream in2 = BValVersion.class.getResourceAsStream("/META-INF/org.apache.bval.revision.properties");){
            if (in2 != null) {
                revisionProps.load(in2);
            }
        }
        catch (IOException in2) {
            // empty catch block
        }
        String vers = revisionProps.getProperty("project.version");
        if (StringUtils.isBlank(vers)) {
            vers = "0.0.0";
        }
        VERSION_NUMBER = vers;
        StringTokenizer tok = new StringTokenizer(VERSION_NUMBER, ".-");
        try {
            major = tok.hasMoreTokens() ? Integer.parseInt(tok.nextToken()) : 0;
        }
        catch (Exception e) {
            major = 0;
        }
        try {
            minor = tok.hasMoreTokens() ? Integer.parseInt(tok.nextToken()) : 0;
        }
        catch (Exception e) {
            minor = 0;
        }
        try {
            patch = tok.hasMoreTokens() ? Integer.parseInt(tok.nextToken()) : 0;
        }
        catch (Exception e) {
            patch = 0;
        }
        String revision = revisionProps.getProperty("svn.revision");
        if (StringUtils.isBlank(revision)) {
            revision = "unknown";
        } else {
            tok = new StringTokenizer(revision, ":");
            String strTok = null;
            while (tok.hasMoreTokens()) {
                try {
                    strTok = tok.nextToken();
                }
                catch (Exception exception) {}
            }
            if (strTok != null) {
                revision = strTok;
            }
        }
        MAJOR_RELEASE = major;
        MINOR_RELEASE = minor;
        PATCH_RELEASE = patch;
        RELEASE_STATUS = tok.hasMoreTokens() ? tok.nextToken("!") : "";
        REVISION_NUMBER = revision;
        PROJECT_ID = "Apache BVal " + VERSION_NUMBER + "-r" + REVISION_NUMBER;
    }
}

