/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image.processing;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.util.internal.CollectionsExt;

final class CompoundFuture<R>
implements Future<R> {
    private final Future<R>[] components;

    private CompoundFuture(Future<R>[] components) {
        this.components = components;
    }

    public static <R> Future<R> create(Future<R>[] components) {
        switch (components.length) {
            case 0: {
                return null;
            }
            case 1: {
                return components[0];
            }
        }
        return new CompoundFuture<R>(components);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean canceled = false;
        for (Future<R> c : this.components) {
            canceled |= c.cancel(mayInterruptIfRunning);
        }
        return canceled;
    }

    @Override
    public boolean isCancelled() {
        for (Future<R> c : this.components) {
            if (!c.isCancelled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDone() {
        for (Future<R> c : this.components) {
            if (c.isDone()) continue;
            return false;
        }
        return true;
    }

    @Override
    public R get() throws InterruptedException, ExecutionException {
        try {
            return this.get(0L, true);
        }
        catch (TimeoutException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.get(System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeout, unit), false);
    }

    private R get(long timeout, boolean noTimeOut) throws InterruptedException, ExecutionException, TimeoutException {
        Object singleton = null;
        HashSet<Object> results = null;
        for (Future<R> c : this.components) {
            R r;
            R r2 = r = noTimeOut ? c.get() : c.get(Math.max(0L, timeout - System.nanoTime()), TimeUnit.NANOSECONDS);
            if (r == null) continue;
            if (singleton == null) {
                singleton = r;
                continue;
            }
            if (r == singleton) continue;
            if (results == null) {
                results = new HashSet<Object>();
                results.add(singleton);
            }
            results.add(r);
        }
        if (results != null) {
            singleton = this.merge(results);
        }
        return (R)singleton;
    }

    protected R merge(Set<R> results) {
        R singleton = CollectionsExt.singletonOrNull(results);
        if (singleton != null) {
            return singleton;
        }
        throw new IllegalStateException(Resources.format((short)53, "get()"));
    }
}

