/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.core.textstats;

import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.math3.util.FastMath;
import org.apache.tika.eval.core.textstats.TokenCountStatsCalculator;
import org.apache.tika.eval.core.tokens.TokenCounts;

public class TokenEntropy
implements TokenCountStatsCalculator<Double> {
    @Override
    public Double calculate(TokenCounts tokenCounts) {
        double ent = 0.0;
        double p = 0.0;
        double base = 2.0;
        double totalTokens = tokenCounts.getTotalTokens();
        for (MutableInt i : tokenCounts.getTokens().values()) {
            int termFreq = i.intValue();
            p = (double)termFreq / totalTokens;
            ent += p * FastMath.log(base, p);
        }
        return -1.0 * ent;
    }
}

