/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common.security;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class Master {
    public static String getMasterUserName(Configuration conf) {
        return conf.get("yarn.resourcemanager.principal");
    }

    public static InetSocketAddress getMasterAddress(Configuration conf) {
        return conf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032);
    }

    public static String getMasterPrincipal(Configuration conf) throws IOException {
        String masterHostname = Master.getMasterAddress(conf).getHostName();
        return SecurityUtil.getServerPrincipal((String)Master.getMasterUserName(conf), (String)masterHostname);
    }

    public static enum State {
        INITIALIZING,
        RUNNING;

    }
}

