/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common.logging;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.IOUtil;
import org.identityconnectors.common.ReflectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.LogSpi;
import org.identityconnectors.common.logging.StdOutLogger;

public final class Log {
    private static final Class<?> DEFAULT_SPI = StdOutLogger.class;
    private static final String PACKAGE = ReflectionUtil.getPackage(Log.class);
    private static final String LOGGER_NAME = Log.class.getName();
    private static final Set<String> EXCLUDE_LIST = CollectionUtil.newReadOnlySet("groovy.", "org.codehaus.groovy.", "gjdk.groovy.", "java.", "javax.", "sun.", "com.google.apphosting.");
    public static final String LOGSPI_PROP = PACKAGE + ".class";
    public static final String LOGSPI_PROPS_FILE = "connectors.properties";
    private static Class<?> cacheSPI;
    private final Class<?> clazz;
    private final LogSpi logImpl;

    private Log(Class<?> clazz, LogSpi logImpl) {
        this.clazz = clazz;
        this.logImpl = logImpl;
    }

    static Log getLog(Class<?> clazz, LogSpi logImpl) {
        return new Log(clazz, logImpl);
    }

    public static Log getLog(Class<?> clazz) {
        try {
            if (LogSpi.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException();
            }
            LogSpi logImpl = (LogSpi)Log.getSpiClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return new Log(clazz, logImpl);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isLoggable(Level level) {
        return this.logImpl.isLoggable(this.clazz, level);
    }

    public void log(Class<?> clazz, String method, Level level, String message, Throwable ex) {
        if (this.isLoggable(level)) {
            this.logImpl.log(clazz, method, level, message, ex);
        }
    }

    public void log(Level level, Throwable ex, String format, Object ... args) {
        if (this.isLoggable(level)) {
            String message = format;
            if (format != null && args != null) {
                message = MessageFormat.format(format, args);
            } else if (format == null && ex != null) {
                message = ex.getLocalizedMessage();
            }
            this.log(level, ex, message, this.logImpl.needToInferCaller(this.clazz, level) ? Thread.currentThread().getStackTrace() : null);
        }
    }

    protected void log(Level level, Throwable ex, String message, StackTraceElement[] locations) {
        Optional.ofNullable(Log.extract(locations, EXCLUDE_LIST)).ifPresentOrElse(caller -> this.logImpl.log(this.clazz, (StackTraceElement)caller, level, message, ex), () -> this.logImpl.log(this.clazz, (String)null, level, message, ex));
    }

    protected static StackTraceElement extract(StackTraceElement[] steArray, Collection<String> frameworkPackageList) {
        if (steArray == null) {
            return null;
        }
        for (StackTraceElement current : steArray) {
            if (Log.isInFrameworkPackageList(current.getClassName(), frameworkPackageList)) continue;
            return current;
        }
        return null;
    }

    protected static boolean isInFrameworkPackageList(String currentClass, Collection<String> frameworkPackageList) {
        if (frameworkPackageList == null) {
            return false;
        }
        if (LOGGER_NAME.equals(currentClass)) {
            return true;
        }
        for (String s : frameworkPackageList) {
            if (!currentClass.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    public void ok(Throwable ex, String format, Object ... args) {
        this.log(Level.OK, ex, format, args);
    }

    public void info(Throwable ex, String format, Object ... args) {
        this.log(Level.INFO, ex, format, args);
    }

    public void warn(Throwable ex, String format, Object ... args) {
        this.log(Level.WARN, ex, format, args);
    }

    public void error(Throwable ex, String format, Object ... args) {
        this.log(Level.ERROR, ex, format, args);
    }

    public void ok(String format, Object ... args) {
        this.log(Level.OK, null, format, args);
    }

    public void info(String format, Object ... args) {
        this.log(Level.INFO, null, format, args);
    }

    public void warn(String format, Object ... args) {
        this.log(Level.WARN, null, format, args);
    }

    public void error(String format, Object ... args) {
        this.log(Level.ERROR, null, format, args);
    }

    public boolean isOk() {
        return this.isLoggable(Level.OK);
    }

    public boolean isInfo() {
        return this.isLoggable(Level.INFO);
    }

    public boolean isWarning() {
        return this.isLoggable(Level.WARN);
    }

    public boolean isError() {
        return this.isLoggable(Level.ERROR);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Class<?> findSpiClass() {
        String serviceId;
        String clazz;
        String impl = System.getProperty(LOGSPI_PROP);
        if (StringUtil.isNotBlank(impl)) {
            return Log.forName(impl);
        }
        File propsFile = Path.of(System.getProperty("java.home"), new String[0]).resolve("lib").resolve(LOGSPI_PROPS_FILE).toFile();
        if (propsFile.isFile() && propsFile.canRead()) {
            try (InputStream fis = Files.newInputStream(propsFile.toPath(), new OpenOption[0]);){
                Properties props = new Properties();
                props.load(fis);
                String prop = props.getProperty(LOGSPI_PROP);
                if (StringUtil.isNotBlank(prop)) {
                    Class<?> clazz2 = Log.forName(prop);
                    return clazz2;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!StringUtil.isNotBlank(clazz = IOUtil.getResourceAsString(Log.class, serviceId = "META-INF/services/" + PACKAGE))) return DEFAULT_SPI;
        return Log.forName(clazz.trim());
    }

    private static Class<?> forName(String clazz) {
        try {
            return Class.forName(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Class<?> getSpiClass() {
        Class<Log> clazz = Log.class;
        synchronized (Log.class) {
            if (cacheSPI == null) {
                cacheSPI = Log.findSpiClass();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return cacheSPI;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setSpiClass(Class<?> clazz) {
        Class<Log> clazz2 = Log.class;
        synchronized (Log.class) {
            cacheSPI = clazz;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static enum Level {
        OK,
        INFO,
        WARN,
        ERROR;

    }
}

