/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.authenticator;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.network.CertStores;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ChannelState;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkTestUtils;
import org.apache.kafka.common.network.NioEchoServer;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.TestSecurityConfig;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.authenticator.LoginManager;
import org.apache.kafka.common.security.authenticator.SaslAuthenticatorTest;
import org.apache.kafka.common.security.authenticator.TestDigestLoginModule;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class SaslAuthenticatorFailureDelayTest {
    private static final int BUFFER_SIZE = 4096;
    private final MockTime time = new MockTime(1L);
    private NioEchoServer server;
    private Selector selector;
    private Map<String, Object> saslClientConfigs;
    private Map<String, Object> saslServerConfigs;
    private CredentialCache credentialCache;
    private long startTimeMs;
    private final int failedAuthenticationDelayMs;

    public SaslAuthenticatorFailureDelayTest(int failedAuthenticationDelayMs) {
        this.failedAuthenticationDelayMs = failedAuthenticationDelayMs;
    }

    @BeforeEach
    public void setup() throws Exception {
        LoginManager.closeAll();
        CertStores serverCertStores = new CertStores(true, "localhost");
        CertStores clientCertStores = new CertStores(false, "localhost");
        this.saslServerConfigs = serverCertStores.getTrustingConfig(clientCertStores);
        this.saslClientConfigs = clientCertStores.getTrustingConfig(serverCertStores);
        this.credentialCache = new CredentialCache();
        SaslAuthenticatorTest.TestLogin.loginCount.set(0);
        this.startTimeMs = this.time.milliseconds();
    }

    @AfterEach
    public void teardown() throws Exception {
        long now = this.time.milliseconds();
        if (this.server != null) {
            this.server.close();
        }
        if (this.selector != null) {
            this.selector.close();
        }
        Assertions.assertTrue((now - this.startTimeMs >= (long)this.failedAuthenticationDelayMs ? 1 : 0) != 0, (String)("timeSpent: " + (now - this.startTimeMs)));
    }

    @Test
    public void testInvalidPasswordSaslPlain() throws Exception {
        String node = "0";
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        TestJaasConfig jaasConfig = this.configureMechanisms("PLAIN", Arrays.asList("PLAIN"));
        jaasConfig.setClientOptions("PLAIN", "myuser", "invalidpassword");
        this.server = this.createEchoServer(securityProtocol);
        this.createAndCheckClientAuthenticationFailure(securityProtocol, node, "PLAIN", "Authentication failed: Invalid username or password");
        this.server.verifyAuthenticationMetrics(0, 1);
    }

    @Test
    public void testInvalidPasswordSaslScram() throws Exception {
        String node = "0";
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        TestJaasConfig jaasConfig = this.configureMechanisms("SCRAM-SHA-256", Collections.singletonList("SCRAM-SHA-256"));
        jaasConfig.setClientOptions("SCRAM-SHA-256", "myuser", "invalidpassword");
        this.server = this.createEchoServer(securityProtocol);
        this.createAndCheckClientAuthenticationFailure(securityProtocol, node, "SCRAM-SHA-256", null);
        this.server.verifyAuthenticationMetrics(0, 1);
    }

    @Test
    public void testDisabledSaslMechanism() throws Exception {
        String node = "0";
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        TestJaasConfig jaasConfig = this.configureMechanisms("SCRAM-SHA-256", Collections.singletonList("SCRAM-SHA-256"));
        jaasConfig.setClientOptions("PLAIN", "myuser", "invalidpassword");
        this.server = this.createEchoServer(securityProtocol);
        this.createAndCheckClientAuthenticationFailure(securityProtocol, node, "SCRAM-SHA-256", null);
        this.server.verifyAuthenticationMetrics(0, 1);
    }

    @Test
    public void testClientConnectionClose() throws Exception {
        String node = "0";
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        TestJaasConfig jaasConfig = this.configureMechanisms("PLAIN", Arrays.asList("PLAIN"));
        jaasConfig.setClientOptions("PLAIN", "myuser", "invalidpassword");
        this.server = this.createEchoServer(securityProtocol);
        this.createClientConnection(securityProtocol, node);
        Map<?, ?> delayedClosingChannels = NetworkTestUtils.delayedClosingChannels(this.server.selector());
        TestUtils.waitForCondition(() -> {
            this.poll(this.selector);
            return !this.server.selector().channels().isEmpty();
        }, "Timeout waiting for connection");
        TestUtils.waitForCondition(() -> {
            this.poll(this.selector);
            return this.failedAuthenticationDelayMs == 0 || !delayedClosingChannels.isEmpty();
        }, "Timeout waiting for auth failure");
        this.selector.close();
        this.selector = null;
        TestUtils.waitForCondition(() -> this.failedAuthenticationDelayMs == 0 || delayedClosingChannels.isEmpty(), "Timeout waiting for delayed response remove");
        TestUtils.waitForCondition(() -> this.server.selector().channels().isEmpty(), "Timeout waiting for connection close");
        TestUtils.waitForCondition(() -> this.time.milliseconds() > this.startTimeMs + (long)this.failedAuthenticationDelayMs + 1L, "Timeout when waiting for auth failure response timeout to elapse");
        NetworkTestUtils.completeDelayedChannelClose(this.server.selector(), this.time.nanoseconds());
    }

    private void poll(Selector selector) {
        try {
            selector.poll(50L);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected failure during selector poll", e);
        }
    }

    private TestJaasConfig configureMechanisms(String clientMechanism, List<String> serverMechanisms) {
        this.saslClientConfigs.put("sasl.mechanism", clientMechanism);
        this.saslServerConfigs.put("sasl.enabled.mechanisms", serverMechanisms);
        if (serverMechanisms.contains("DIGEST-MD5")) {
            this.saslServerConfigs.put("digest-md5.sasl.server.callback.handler.class", TestDigestLoginModule.DigestServerCallbackHandler.class.getName());
        }
        return TestJaasConfig.createConfiguration(clientMechanism, serverMechanisms);
    }

    private void createSelector(SecurityProtocol securityProtocol, Map<String, Object> clientConfigs) {
        if (this.selector != null) {
            this.selector.close();
            this.selector = null;
        }
        String saslMechanism = (String)this.saslClientConfigs.get("sasl.mechanism");
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)securityProtocol, (JaasContext.Type)JaasContext.Type.CLIENT, (AbstractConfig)new TestSecurityConfig(clientConfigs), null, (String)saslMechanism, (Time)this.time, (boolean)true, (LogContext)new LogContext());
        this.selector = NetworkTestUtils.createSelector(channelBuilder, this.time);
    }

    private NioEchoServer createEchoServer(SecurityProtocol securityProtocol) throws Exception {
        return this.createEchoServer(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol);
    }

    private NioEchoServer createEchoServer(ListenerName listenerName, SecurityProtocol securityProtocol) throws Exception {
        return NetworkTestUtils.createEchoServer(listenerName, securityProtocol, new TestSecurityConfig(this.saslServerConfigs), this.credentialCache, this.time);
    }

    private void createClientConnection(SecurityProtocol securityProtocol, String node) throws Exception {
        this.createSelector(securityProtocol, this.saslClientConfigs);
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        this.selector.connect(node, addr, 4096, 4096);
    }

    private void createAndCheckClientAuthenticationFailure(SecurityProtocol securityProtocol, String node, String mechanism, String expectedErrorMessage) throws Exception {
        ChannelState finalState = this.createAndCheckClientConnectionFailure(securityProtocol, node);
        AuthenticationException exception = finalState.exception();
        Assertions.assertInstanceOf(SaslAuthenticationException.class, (Object)exception, (String)("Invalid exception class " + exception.getClass()));
        if (expectedErrorMessage == null) {
            expectedErrorMessage = "Authentication failed during authentication due to invalid credentials with SASL mechanism " + mechanism;
        }
        Assertions.assertEquals((Object)expectedErrorMessage, (Object)exception.getMessage());
    }

    private ChannelState createAndCheckClientConnectionFailure(SecurityProtocol securityProtocol, String node) throws Exception {
        this.createClientConnection(securityProtocol, node);
        ChannelState finalState = NetworkTestUtils.waitForChannelClose(this.selector, node, ChannelState.State.AUTHENTICATION_FAILED);
        this.selector.close();
        this.selector = null;
        return finalState;
    }
}

