/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.common.validation;

import jakarta.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.common.lib.types.ExecStatus;
import org.apache.syncope.core.persistence.api.entity.task.PropagationTask;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.common.validation.AbstractValidator;
import org.apache.syncope.core.persistence.common.validation.PropagationTaskCheck;

public class PropagationTaskValidator
extends AbstractValidator<PropagationTaskCheck, PropagationTask> {
    public boolean isValid(PropagationTask task, ConstraintValidatorContext context) {
        boolean isValid;
        boolean bl = isValid = task.getOperation() != null && task.getPropagationData() != null && task.getResource() != null;
        if (isValid) {
            for (TaskExec execution : task.getExecs()) {
                try {
                    ExecStatus.valueOf((String)execution.getStatus());
                }
                catch (IllegalArgumentException e) {
                    LOG.error("Invalid execution status '{}'", (Object)execution.getStatus(), (Object)e);
                    isValid = false;
                }
            }
        }
        if (!isValid) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(PropagationTaskValidator.getTemplate(EntityViolationType.InvalidPropagationTask, "Invalid task")).addPropertyNode(task.getClass().getSimpleName()).addConstraintViolation();
        }
        return isValid;
    }
}

