/*
 * Decompiled with CFR 0.152.
 */
package kafka;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Properties;
import kafka.Kafka$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\u0005a\u0001B\u0016-\u0001=BQA\u000e\u0001\u0005\u0002]BQA\u000f\u0001\u0005\u0002mBQ\u0001\u0014\u0001\u0005\u0002mBQ!\u0015\u0001\u0005\u0002mBQA\u0016\u0001\u0005\u0002mBQ\u0001\u0017\u0001\u0005\u0002mBQA\u0017\u0001\u0005\u0002mBQ\u0001\u0018\u0001\u0005\u0002mBQA\u0018\u0001\u0005\u0002mBQ\u0001\u0019\u0001\u0005\u0002mBQA\u0019\u0001\u0005\u0002mBQ\u0001\u001a\u0001\u0005\u0002mBQA\u001a\u0001\u0005\n\u001dDQA\u001d\u0001\u0005\u0002mBQ\u0001\u001e\u0001\u0005\u0002mBqA\u001e\u0001C\u0002\u0013%q\u000f\u0003\u0004|\u0001\u0001\u0006I\u0001\u001f\u0005\by\u0002\u0011\r\u0011\"\u0003~\u0011\u001d\tI\u0001\u0001Q\u0001\nyD\u0001\"a\u0003\u0001\u0005\u0004%I! \u0005\b\u0003\u001b\u0001\u0001\u0015!\u0003\u007f\u0011%\ty\u0001\u0001b\u0001\n\u0013\t\t\u0002\u0003\u0005\u0002$\u0001\u0001\u000b\u0011BA\n\u0011\u0019\t)\u0003\u0001C\u0001w!1\u0011\u0011\u0006\u0001\u0005\u0002mBa!!\f\u0001\t\u0003Y\u0004BBA\u0019\u0001\u0011\u00051\b\u0003\u0004\u00026\u0001!\ta\u000f\u0005\u0007\u0003s\u0001A\u0011A\u001e\t\r\u0005u\u0002\u0001\"\u0001<\u0011\u0019\t\t\u0005\u0001C\u0001w!1\u0011Q\t\u0001\u0005\u0002mBa!!\u0013\u0001\t\u0003Y\u0004BBA'\u0001\u0011\u00051\b\u0003\u0004\u0002R\u0001!\ta\u000f\u0005\u0007\u0003+\u0002A\u0011A\u001e\t\r\u0005e\u0003\u0001\"\u0001<\u0011\u0019\ti\u0006\u0001C\u0001w!9\u0011\u0011\r\u0001\u0005\n\u0005\r\u0004\"CAf\u0001E\u0005I\u0011BAg\u0011\u001d\ty\u000f\u0001C\u0001\u0003cDq!a=\u0001\t\u0003\t)PA\bLC\u001a\\\u0017mQ8oM&<G+Z:u\u0015\u0005i\u0013!B6bM.\f7\u0001A\n\u0003\u0001A\u0002\"!\r\u001b\u000e\u0003IR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00019!\tI\u0004!D\u0001-\u0003\u0015\u0019X\r^+q)\u0005a\u0004CA\u0019>\u0013\tq$G\u0001\u0003V]&$\bF\u0001\u0002A!\t\t%*D\u0001C\u0015\t\u0019E)A\u0002ba&T!!\u0012$\u0002\u000f),\b/\u001b;fe*\u0011q\tS\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u0013\u0006\u0019qN]4\n\u0005-\u0013%A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000e\u000b\u0002\u0004\u001dB\u0011\u0011iT\u0005\u0003!\n\u0013\u0011\"\u00114uKJ,\u0015m\u00195\u00025Q,7\u000f^$fi.\u000bgm[1D_:4\u0017n\u001a$s_6\f%oZ:)\u0005\u0011\u0019\u0006CA!U\u0013\t)&I\u0001\u0003UKN$\u0018!\u000b;fgR<U\r^&bM.\f7i\u001c8gS\u001e4%o\\7Be\u001e\u001chj\u001c8Be\u001e\u001c\u0018\t\u001e+iK\u0016sG\r\u000b\u0002\u0006'\u0006)C/Z:u\u000f\u0016$8*\u00194lC\u000e{gNZ5h\rJ|W.\u0011:hg:{g.\u0011:hg>sG.\u001f\u0015\u0003\rM\u000bQ\u0006^3ti\u001e+GoS1gW\u0006\u001cuN\u001c4jO\u001a\u0013x.\\!sONtuN\\!sON\fE\u000f\u00165f\u0005\u0016<w-\u001b8hQ\t91+\u0001\u0010uKN$(I]8lKJ\u0014v\u000e\\3O_\u0012,\u0017\n\u001a,bY&$\u0017\r^5p]\"\u0012\u0001bU\u0001#i\u0016\u001cHoQ8oiJ|G\u000e\\3s%>dWMT8eK&#g+\u00197jI\u0006$\u0018n\u001c8)\u0005%\u0019\u0016\u0001\t;fgR\u001cu.\u001c2j]\u0016$'k\u001c7f\u001d>$W-\u00133WC2LG-\u0019;j_:D#AC*\u0002/Q,7\u000f^%t\u0017J\u000bg\r^\"p[\nLg.\u001a3N_\u0012,\u0007FA\u0006T\u00039\"Xm\u001d;NkN$8i\u001c8uC&t\u0017+^8sk64v\u000e^3sg&3Wk]5oOB\u0013xnY3tgJ{G.Z:)\u00051\u0019\u0016\u0001E:fi2K7\u000f^3oKJ\u0004&o\u001c9t)\ta\u0004\u000eC\u0003j\u001b\u0001\u0007!.A\u0003qe>\u00048\u000f\u0005\u0002la6\tAN\u0003\u0002n]\u0006!Q\u000f^5m\u0015\u0005y\u0017\u0001\u00026bm\u0006L!!\u001d7\u0003\u0015A\u0013x\u000e]3si&,7/A\u000buKN$8*\u00194lCN\u001bH\u000eU1tg^|'\u000fZ:)\u00059\u0019\u0016\u0001\t;fgR\\\u0015MZ6b'Nd\u0007+Y:to>\u0014Hm],ji\"\u001c\u00160\u001c2pYND#aD*\u0002+\t|w\u000e\\3b]B\u0013x\u000e\u001d,bYV,Gk\\*fiV\t\u0001\u0010\u0005\u00022s&\u0011!P\r\u0002\b\u0005>|G.Z1o\u0003Y\u0011wn\u001c7fC:\u0004&o\u001c9WC2,X\rV8TKR\u0004\u0013\u0001F:ue&tw\r\u0015:paZ\u000bG.^3U_N+G/F\u0001\u007f!\ry\u0018QA\u0007\u0003\u0003\u0003Q1!a\u0001o\u0003\u0011a\u0017M\\4\n\t\u0005\u001d\u0011\u0011\u0001\u0002\u0007'R\u0014\u0018N\\4\u0002+M$(/\u001b8h!J|\u0007OV1mk\u0016$vnU3uA\u00051\u0002/Y:to>\u0014H\r\u0015:paZ\u000bG.^3U_N+G/A\fqCN\u001cxo\u001c:e!J|\u0007OV1mk\u0016$vnU3uA\u0005\u0011B.[:u!J|\u0007OV1mk\u0016$vnU3u+\t\t\u0019\u0002E\u0003\u0002\u0016\u0005}a0\u0004\u0002\u0002\u0018)!\u0011\u0011DA\u000e\u0003%IW.\\;uC\ndWMC\u0002\u0002\u001eI\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t#a\u0006\u0003\t1K7\u000f^\u0001\u0014Y&\u001cH\u000f\u0015:paZ\u000bG.^3U_N+G\u000fI\u0001\u0016i\u0016\u001cHOW6Tg2\u001cE.[3oi\u0016s\u0017M\u00197fQ\tA2+A\ruKN$(l[*tY.+\u0017p\u0015;pe\u0016dunY1uS>t\u0007FA\rT\u0003m!Xm\u001d;[WN\u001bH\u000e\u0016:vgR\u001cFo\u001c:f\u0019>\u001c\u0017\r^5p]\"\u0012!dU\u0001\u001ei\u0016\u001cHOW8pW\u0016,\u0007/\u001a:LKf\u001cFo\u001c:f!\u0006\u001c8o^8sI\"\u00121dU\u0001 i\u0016\u001cHOW8pW\u0016,\u0007/\u001a:UeV\u001cHo\u0015;pe\u0016\u0004\u0016m]:x_J$\u0007F\u0001\u000fT\u0003U!Xm\u001d;[WN\u001bHnS3z'R|'/\u001a+za\u0016D#!H*\u0002/Q,7\u000f\u001e.l'NdGK];tiN#xN]3UsB,\u0007F\u0001\u0010T\u0003E!Xm\u001d;[WN\u001bH\u000e\u0015:pi>\u001cw\u000e\u001c\u0015\u0003?M\u000b\u0011\u0004^3tij[7k\u001d7F]\u0006\u0014G.\u001a3Qe>$xnY8mg\"\u0012\u0001eU\u0001\u0016i\u0016\u001cHOW6Tg2\u001c\u0015\u000e\u001d5feN+\u0018\u000e^3tQ\t\t3+\u0001\u0015uKN$(l[*tY\u0016sG\r]8j]RLE-\u001a8uS\u001aL7-\u0019;j_:\fEnZ8sSRDW\u000e\u000b\u0002#'\u0006\u0011B/Z:u5.\u001c6\u000f\\\"sY\u0016s\u0017M\u00197fQ\t\u00193+A\nuKN$(l[*tY>\u001b7\u000f]#oC\ndW\r\u000b\u0002%'\u0006\tC/Z:u\u0007>tg.Z2uS>t7/T1y%\u0016\fW\u000f\u001e5Ng\u0012+g-Y;mi\"\u0012QeU\u0001#i\u0016\u001cHoQ8o]\u0016\u001cG/[8og6\u000b\u0007PU3bkRDWj]#ya2L7-\u001b;)\u0005\u0019\u001a\u0016\u0001\u0004;fgRT6nQ8oM&<WCBA3\u0003\u001f\u000b\u0019\rF\b=\u0003O\ny(a!\u0002\b\u0006\u0005\u0016QXAd\u0011\u001d\tIg\na\u0001\u0003W\nQb[1gW\u0006\u0004&o\u001c9OC6,\u0007\u0003BA7\u0003wrA!a\u001c\u0002xA\u0019\u0011\u0011\u000f\u001a\u000e\u0005\u0005M$bAA;]\u00051AH]8pizJ1!!\u001f3\u0003\u0019\u0001&/\u001a3fM&!\u0011qAA?\u0015\r\tIH\r\u0005\b\u0003\u0003;\u0003\u0019AA6\u0003U)\u0007\u0010]3di\u0016$7*\u00194lCB\u0013x\u000e\u001d(b[\u0016Dq!!\"(\u0001\u0004\tY'A\u0006tsN\u0004&o\u001c9OC6,\u0007bBAEO\u0001\u0007\u00111R\u0001\u000faJ|\u0007OV1mk\u0016$vnU3u!\u0011\ti)a$\r\u0001\u00119\u0011\u0011S\u0014C\u0002\u0005M%!\u0001+\u0012\t\u0005U\u00151\u0014\t\u0004c\u0005]\u0015bAAMe\t9aj\u001c;iS:<\u0007cA\u0019\u0002\u001e&\u0019\u0011q\u0014\u001a\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002$\u001e\u0002\r!!*\u0002!\u001d,G\u000f\u0015:paZ\u000bG.^3Ge>l\u0007cB\u0019\u0002(\u0006-\u0016qW\u0005\u0004\u0003S\u0013$!\u0003$v]\u000e$\u0018n\u001c82!\u0011\ti+a-\u000e\u0005\u0005=&bAAYY\u000511/\u001a:wKJLA!!.\u00020\nY1*\u00194lC\u000e{gNZ5h!\u0015\t\u0014\u0011XAF\u0013\r\tYL\r\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005}v\u00051\u0001\u0002B\u0006)R\r\u001f9fGR,G\r\u0015:pa\u0016\u0014H/\u001f,bYV,\u0007\u0003BAG\u0003\u0007$q!!2(\u0005\u0004\t\u0019JA\u0001V\u0011%\tIm\nI\u0001\u0002\u0004\t9,\u0001\u000bfqB,7\r^3e\t\u00164\u0017-\u001e7u-\u0006dW/Z\u0001\u0017i\u0016\u001cHOW6D_:4\u0017n\u001a\u0013eK\u001a\fW\u000f\u001c;%oU1\u0011qZAv\u0003[,\"!!5+\t\u0005M\u0017\u0011\u001c\b\u0004c\u0005U\u0017bAAle\u0005!aj\u001c8fW\t\tY\u000e\u0005\u0003\u0002^\u0006\u001dXBAAp\u0015\u0011\t\t/a9\u0002\u0013Ut7\r[3dW\u0016$'bAAse\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005%\u0018q\u001c\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,GaBAIQ\t\u0007\u00111\u0013\u0003\b\u0003\u000bD#\u0019AAJ\u0003Q\u0001(/\u001a9be\u0016$UMZ1vYR\u001cuN\u001c4jOR\u0011\u00111N\u0001\u000eaJ,\u0007/\u0019:f\u0007>tg-[4\u0015\t\u0005-\u0014q\u001f\u0005\b\u0003sT\u0003\u0019AA~\u0003\u0015a\u0017N\\3t!\u0015\t\u0014Q`A6\u0013\r\tyP\r\u0002\u0006\u0003J\u0014\u0018-\u001f")
public class KafkaConfigTest {
    private final boolean booleanPropValueToSet;
    private final String stringPropValueToSet;
    private final String passwordPropValueToSet;
    private final List<String> listPropValueToSet = new .colon.colon((Object)"A", (List)new .colon.colon((Object)"B", (List)Nil$.MODULE$));

    @BeforeEach
    public void setUp() {
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(status, x$1) -> KafkaConfigTest.$anonfun$setUp$1(BoxesRunTime.unboxToInt((Object)status), x$1);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
    }

    @AfterEach
    public void tearDown() {
        Exit.resetExitProcedure();
    }

    @Test
    public void testGetKafkaConfigFromArgs() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config1 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile}));
        Assertions.assertEquals((int)1, (int)config1.brokerId());
        KafkaConfig config2 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", "broker.id=2"}));
        Assertions.assertEquals((int)2, (int)config2.brokerId());
        KafkaConfig config3 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", "log.cleanup.policy=compact"}));
        Assertions.assertEquals((int)1, (int)config3.brokerId());
        Assertions.assertEquals(Arrays.asList("compact"), (Object)config3.logCleanupPolicy());
        KafkaConfig config4 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", "log.cleanup.policy=compact,delete", "--override", "broker.id=2"}));
        Assertions.assertEquals((int)2, (int)config4.brokerId());
        Assertions.assertEquals(Arrays.asList("compact", "delete"), (Object)config4.logCleanupPolicy());
    }

    @Test
    public void testGetKafkaConfigFromArgsNonArgsAtTheEnd() {
        String propertiesFile = this.prepareDefaultConfig();
        Assertions.assertThrows(FatalExitError.class, () -> KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", "broker.id=1", "broker.id=2"})));
    }

    @Test
    public void testGetKafkaConfigFromArgsNonArgsOnly() {
        String propertiesFile = this.prepareDefaultConfig();
        Assertions.assertThrows(FatalExitError.class, () -> KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "broker.id=1", "broker.id=2"})));
    }

    @Test
    public void testGetKafkaConfigFromArgsNonArgsAtTheBegging() {
        String propertiesFile = this.prepareDefaultConfig();
        Assertions.assertThrows(FatalExitError.class, () -> KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "broker.id=1", "--override", "broker.id=2"})));
    }

    @Test
    public void testBrokerRoleNodeIdValidation() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty("process.roles", "broker");
        propertiesFile.setProperty("node.id", "1");
        propertiesFile.setProperty("controller.quorum.voters", "1@localhost:9092");
        this.setListenerProps(propertiesFile);
        TestUtils$.MODULE$.assertBadConfigContainingMessage(propertiesFile, "If process.roles contains just the 'broker' role, the node id 1 must not be included in the set of voters");
        propertiesFile.setProperty("node.id", "2");
        KafkaConfig$.MODULE$.fromProps(propertiesFile);
    }

    @Test
    public void testControllerRoleNodeIdValidation() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty("process.roles", "controller");
        propertiesFile.setProperty("node.id", "1");
        propertiesFile.setProperty("controller.quorum.voters", "2@localhost:9092");
        this.setListenerProps(propertiesFile);
        TestUtils$.MODULE$.assertBadConfigContainingMessage(propertiesFile, "If process.roles contains the 'controller' role, the node id 1 must be included in the set of voters");
        propertiesFile.setProperty("node.id", "2");
        KafkaConfig$.MODULE$.fromProps(propertiesFile);
    }

    @Test
    public void testCombinedRoleNodeIdValidation() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty("process.roles", "controller,broker");
        propertiesFile.setProperty("node.id", "1");
        propertiesFile.setProperty("controller.quorum.voters", "2@localhost:9092");
        this.setListenerProps(propertiesFile);
        TestUtils$.MODULE$.assertBadConfigContainingMessage(propertiesFile, "If process.roles contains the 'controller' role, the node id 1 must be included in the set of voters");
        propertiesFile.setProperty("node.id", "2");
        KafkaConfig$.MODULE$.fromProps(propertiesFile);
    }

    @Test
    public void testIsKRaftCombinedMode() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty("process.roles", "controller,broker");
        propertiesFile.setProperty("node.id", "1");
        propertiesFile.setProperty("controller.quorum.voters", "1@localhost:9092");
        this.setListenerProps(propertiesFile);
        Assertions.assertTrue((boolean)KafkaConfig$.MODULE$.fromProps(propertiesFile).isKRaftCombinedMode());
    }

    @Test
    public void testMustContainQuorumVotersIfUsingProcessRoles() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty("process.roles", "controller,broker");
        propertiesFile.setProperty("node.id", "1");
        propertiesFile.setProperty("controller.quorum.voters", "");
        this.setListenerProps(propertiesFile);
        TestUtils$.MODULE$.assertBadConfigContainingMessage(propertiesFile, "If using process.roles, controller.quorum.voters must contain a parseable set of voters.");
        propertiesFile.setProperty("process.roles", "");
        TestUtils$.MODULE$.assertBadConfigContainingMessage(propertiesFile, "Missing required configuration `zookeeper.connect` which has no default value.");
        propertiesFile.setProperty("zookeeper.connect", "localhost:2181");
        propertiesFile.setProperty("controller.listener.names", "");
        KafkaConfig$.MODULE$.fromProps(propertiesFile);
    }

    private void setListenerProps(Properties props) {
        boolean hasBrokerRole = props.getProperty("process.roles").contains("broker");
        boolean hasControllerRole = props.getProperty("process.roles").contains("controller");
        String controllerListener = "SASL_PLAINTEXT://localhost:9092";
        String brokerListener = "PLAINTEXT://localhost:9093";
        if (hasBrokerRole || hasControllerRole) {
            props.setProperty("controller.listener.names", "SASL_PLAINTEXT");
            if (hasBrokerRole && hasControllerRole) {
                props.setProperty("listeners", new StringBuilder(1).append(brokerListener).append(",").append(controllerListener).toString());
            } else if (hasControllerRole) {
                props.setProperty("listeners", controllerListener);
            } else if (hasBrokerRole) {
                props.setProperty("listeners", brokerListener);
            }
        } else {
            props.setProperty("listeners", brokerListener);
        }
        if (!(hasControllerRole & !hasBrokerRole)) {
            props.setProperty("inter.broker.listener.name", "PLAINTEXT");
            props.setProperty("advertised.listeners", "PLAINTEXT://localhost:9092");
            return;
        }
    }

    @Test
    public void testKafkaSslPasswords() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", "ssl.keystore.password=keystore_password", "--override", "ssl.key.password=key_password", "--override", "ssl.truststore.password=truststore_password", "--override", "ssl.keystore.certificate.chain=certificate_chain", "--override", "ssl.keystore.key=private_key", "--override", "ssl.truststore.certificates=truststore_certificates"}));
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword("ssl.key.password").toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword("ssl.keystore.password").toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword("ssl.truststore.password").toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword("ssl.keystore.key").toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword("ssl.keystore.certificate.chain").toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword("ssl.truststore.certificates").toString());
        Assertions.assertEquals((Object)"key_password", (Object)config.getPassword("ssl.key.password").value());
        Assertions.assertEquals((Object)"keystore_password", (Object)config.getPassword("ssl.keystore.password").value());
        Assertions.assertEquals((Object)"truststore_password", (Object)config.getPassword("ssl.truststore.password").value());
        Assertions.assertEquals((Object)"private_key", (Object)config.getPassword("ssl.keystore.key").value());
        Assertions.assertEquals((Object)"certificate_chain", (Object)config.getPassword("ssl.keystore.certificate.chain").value());
        Assertions.assertEquals((Object)"truststore_certificates", (Object)config.getPassword("ssl.truststore.certificates").value());
    }

    @Test
    public void testKafkaSslPasswordsWithSymbols() {
        String password = "=!#-+!?*/\"'^%$=\\.,@:;=";
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", new StringBuilder(22).append("ssl.keystore.password=").append(password).toString(), "--override", new StringBuilder(17).append("ssl.key.password=").append(password).toString(), "--override", new StringBuilder(24).append("ssl.truststore.password=").append(password).toString()}));
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword("ssl.key.password").toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword("ssl.keystore.password").toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword("ssl.truststore.password").toString());
        Assertions.assertEquals((Object)password, (Object)config.getPassword("ssl.keystore.password").value());
        Assertions.assertEquals((Object)password, (Object)config.getPassword("ssl.key.password").value());
        Assertions.assertEquals((Object)password, (Object)config.getPassword("ssl.truststore.password").value());
    }

    private boolean booleanPropValueToSet() {
        return this.booleanPropValueToSet;
    }

    private String stringPropValueToSet() {
        return this.stringPropValueToSet;
    }

    private String passwordPropValueToSet() {
        return this.passwordPropValueToSet;
    }

    private List<String> listPropValueToSet() {
        return this.listPropValueToSet;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslClientEnable() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        Some some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        Boolean bl2 = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        String string = "zookeeper.client.secure";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.client.enable";
        String testZkConfig_kafkaPropName = "zookeeper.ssl.client.enable";
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)KafkaConfigTest.$anonfun$testZkSslClientEnable$1(testZkConfig_emptyConfig).get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)KafkaConfigTest.$anonfun$testZkSslClientEnable$1(testZkConfig_emptyConfig));
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaConfigTest.$anonfun$testZkSslClientEnable$1(testZkConfig_config));
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaConfigTest.$anonfun$testZkSslClientEnable$1(testZkConfig_config));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslKeyStoreLocation() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = None$.MODULE$;
        String string = this.stringPropValueToSet();
        String string2 = this.stringPropValueToSet();
        String string3 = "zookeeper.ssl.keyStore.location";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.keystore.location";
        String testZkConfig_kafkaPropName = "zookeeper.ssl.keystore.location";
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslKeyStoreLocation().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslKeyStoreLocation());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStoreLocation());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStoreLocation());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslTrustStoreLocation() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = None$.MODULE$;
        String string = this.stringPropValueToSet();
        String string2 = this.stringPropValueToSet();
        String string3 = "zookeeper.ssl.trustStore.location";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.truststore.location";
        String testZkConfig_kafkaPropName = "zookeeper.ssl.truststore.location";
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslTrustStoreLocation().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslTrustStoreLocation());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStoreLocation());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStoreLocation());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZookeeperKeyStorePassword() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = None$.MODULE$;
        Password password = new Password(this.passwordPropValueToSet());
        String string = this.passwordPropValueToSet();
        String string2 = "zookeeper.ssl.keyStore.password";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.keystore.password";
        String testZkConfig_kafkaPropName = "zookeeper.ssl.keystore.password";
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslKeyStorePassword().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslKeyStorePassword());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStorePassword());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStorePassword());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZookeeperTrustStorePassword() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = None$.MODULE$;
        Password password = new Password(this.passwordPropValueToSet());
        String string = this.passwordPropValueToSet();
        String string2 = "zookeeper.ssl.trustStore.password";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.truststore.password";
        String testZkConfig_kafkaPropName = "zookeeper.ssl.truststore.password";
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslTrustStorePassword().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslTrustStorePassword());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStorePassword());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStorePassword());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslKeyStoreType() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = None$.MODULE$;
        String string = this.stringPropValueToSet();
        String string2 = this.stringPropValueToSet();
        String string3 = "zookeeper.ssl.keyStore.type";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.keystore.type";
        String testZkConfig_kafkaPropName = "zookeeper.ssl.keystore.type";
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslKeyStoreType().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslKeyStoreType());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStoreType());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStoreType());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslTrustStoreType() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = None$.MODULE$;
        String string = this.stringPropValueToSet();
        String string2 = this.stringPropValueToSet();
        String string3 = "zookeeper.ssl.trustStore.type";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.truststore.type";
        String testZkConfig_kafkaPropName = "zookeeper.ssl.truststore.type";
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslTrustStoreType().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslTrustStoreType());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStoreType());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStoreType());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslProtocol() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        Some some = new Some((Object)"TLSv1.2");
        String string = this.stringPropValueToSet();
        String string2 = this.stringPropValueToSet();
        String string3 = "zookeeper.ssl.protocol";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.protocol";
        String testZkConfig_kafkaPropName = "zookeeper.ssl.protocol";
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)KafkaConfigTest.$anonfun$testZkSslProtocol$1(testZkConfig_emptyConfig).get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)KafkaConfigTest.$anonfun$testZkSslProtocol$1(testZkConfig_emptyConfig));
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaConfigTest.$anonfun$testZkSslProtocol$1(testZkConfig_config));
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaConfigTest.$anonfun$testZkSslProtocol$1(testZkConfig_config));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslEnabledProtocols() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = None$.MODULE$;
        java.util.List list = CollectionConverters$.MODULE$.SeqHasAsJava(this.listPropValueToSet()).asJava();
        String string = this.listPropValueToSet().mkString(",");
        String string2 = "zookeeper.ssl.enabledProtocols";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.enabled.protocols";
        String testZkConfig_kafkaPropName = "zookeeper.ssl.enabled.protocols";
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.ZkSslEnabledProtocols().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.ZkSslEnabledProtocols());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.ZkSslEnabledProtocols());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.ZkSslEnabledProtocols());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslCipherSuites() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = None$.MODULE$;
        java.util.List list = CollectionConverters$.MODULE$.SeqHasAsJava(this.listPropValueToSet()).asJava();
        String string = this.listPropValueToSet().mkString(",");
        String string2 = "zookeeper.ssl.ciphersuites";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.cipher.suites";
        String testZkConfig_kafkaPropName = "zookeeper.ssl.cipher.suites";
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.ZkSslCipherSuites().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.ZkSslCipherSuites());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.ZkSslCipherSuites());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.ZkSslCipherSuites());
    }

    @Test
    public void testZkSslEndpointIdentificationAlgorithm() {
        String kafkaPropName = "zookeeper.ssl.endpoint.identification.algorithm";
        Assertions.assertEquals((Object)"zookeeper.ssl.endpoint.identification.algorithm", (Object)kafkaPropName);
        String sysProp = "zookeeper.ssl.hostnameVerification";
        String expectedDefaultValue = "HTTPS";
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile}));
        Assertions.assertNull(emptyConfig.originals().get(kafkaPropName));
        Assertions.assertEquals((Object)expectedDefaultValue, emptyConfig.values().get(kafkaPropName));
        Assertions.assertEquals((Object)expectedDefaultValue, (Object)emptyConfig.ZkSslEndpointIdentificationAlgorithm());
        ((IterableOnceOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"true"), (Object)"HTTPS"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"false"), (Object)"")}))).foreach((Function1 & Serializable)x0$1 -> {
            KafkaConfigTest.$anonfun$testZkSslEndpointIdentificationAlgorithm$1(sysProp, propertiesFile, kafkaPropName, expectedDefaultValue, x0$1);
            return BoxedUnit.UNIT;
        });
        new .colon.colon((Object)"https", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)expected -> {
            KafkaConfigTest.$anonfun$testZkSslEndpointIdentificationAlgorithm$2(propertiesFile, kafkaPropName, expected);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslCrlEnable() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        Some some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        Boolean bl2 = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        String string = "zookeeper.ssl.crl";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.crl.enable";
        String testZkConfig_kafkaPropName = "zookeeper.ssl.crl.enable";
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)KafkaConfigTest.$anonfun$testZkSslCrlEnable$1(testZkConfig_emptyConfig).get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)KafkaConfigTest.$anonfun$testZkSslCrlEnable$1(testZkConfig_emptyConfig));
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaConfigTest.$anonfun$testZkSslCrlEnable$1(testZkConfig_config));
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaConfigTest.$anonfun$testZkSslCrlEnable$1(testZkConfig_config));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslOcspEnable() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        Some some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        Boolean bl2 = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        String string = "zookeeper.ssl.ocsp";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.ocsp.enable";
        String testZkConfig_kafkaPropName = "zookeeper.ssl.ocsp.enable";
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)KafkaConfigTest.$anonfun$testZkSslOcspEnable$1(testZkConfig_emptyConfig).get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)KafkaConfigTest.$anonfun$testZkSslOcspEnable$1(testZkConfig_emptyConfig));
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaConfigTest.$anonfun$testZkSslOcspEnable$1(testZkConfig_config));
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaConfigTest.$anonfun$testZkSslOcspEnable$1(testZkConfig_config));
    }

    @Test
    public void testConnectionsMaxReauthMsDefault() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile}));
        Assertions.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong(config.valuesWithPrefixOverride("sasl_ssl.oauthbearer.").get("connections.max.reauth.ms")));
    }

    @Test
    public void testConnectionsMaxReauthMsExplicit() {
        String propertiesFile = this.prepareDefaultConfig();
        int expected = 3600000;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", new StringBuilder(47).append("sasl_ssl.oauthbearer.connections.max.reauth.ms=").append(expected).toString()}));
        Assertions.assertEquals((long)expected, (long)BoxesRunTime.unboxToLong(config.valuesWithPrefixOverride("sasl_ssl.oauthbearer.").get("connections.max.reauth.ms")));
    }

    private <T, U> void testZkConfig(String kafkaPropName, String expectedKafkaPropName, String sysPropName, T propValueToSet, Function1<KafkaConfig, Option<T>> getPropValueFrom, U expectedPropertyValue, Option<T> expectedDefaultValue) {
        Assertions.assertEquals((Object)expectedKafkaPropName, (Object)kafkaPropName);
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile}));
        Assertions.assertNull(emptyConfig.originals().get(kafkaPropName));
        if (expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)expectedDefaultValue.get(), emptyConfig.values().get(kafkaPropName));
            Assertions.assertEquals((Object)expectedDefaultValue.get(), (Object)((Option)getPropValueFrom.apply((Object)emptyConfig)).get());
        } else {
            Assertions.assertNull(emptyConfig.values().get(kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)getPropValueFrom.apply((Object)emptyConfig));
        }
        try {
            System.setProperty(sysPropName, String.valueOf(propValueToSet));
            KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile}));
            Assertions.assertNull(config.originals().get(kafkaPropName));
            if (expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)expectedDefaultValue.get(), config.values().get(kafkaPropName));
            } else {
                Assertions.assertNull(config.values().get(kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some(expectedPropertyValue), (Object)getPropValueFrom.apply((Object)config));
        }
        finally {
            System.clearProperty(sysPropName);
        }
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", new StringBuilder(1).append(kafkaPropName).append("=").append(propValueToSet).toString()}));
        Assertions.assertEquals(expectedPropertyValue, config.values().get(kafkaPropName));
        Assertions.assertEquals((Object)new Some(expectedPropertyValue), (Object)getPropValueFrom.apply((Object)config));
    }

    private <T, U> None$ testZkConfig$default$7() {
        return None$.MODULE$;
    }

    public String prepareDefaultConfig() {
        return this.prepareConfig(new String[]{"broker.id=1", "zookeeper.connect=somewhere"});
    }

    public String prepareConfig(String[] lines) {
        String string;
        File file = TestUtils.tempFile((String)"kafkatest", (String)".properties");
        try (OutputStream writer = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])lines), (Function1 & Serializable)l -> {
                KafkaConfigTest.$anonfun$prepareConfig$1(writer, l);
                return BoxedUnit.UNIT;
            });
            string = file.getAbsolutePath();
        }
        return string;
    }

    public static final /* synthetic */ Nothing$ $anonfun$setUp$1(int status, Option x$1) {
        throw new FatalExitError(status);
    }

    public static final /* synthetic */ Some $anonfun$testZkSslClientEnable$1(KafkaConfig config) {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)config.zkSslClientEnable()));
    }

    public static final /* synthetic */ Option $anonfun$testZkSslKeyStoreLocation$1(KafkaConfig config) {
        return config.zkSslKeyStoreLocation();
    }

    public static final /* synthetic */ Option $anonfun$testZkSslTrustStoreLocation$1(KafkaConfig config) {
        return config.zkSslTrustStoreLocation();
    }

    public static final /* synthetic */ Option $anonfun$testZookeeperKeyStorePassword$1(KafkaConfig config) {
        return config.zkSslKeyStorePassword();
    }

    public static final /* synthetic */ Option $anonfun$testZookeeperTrustStorePassword$1(KafkaConfig config) {
        return config.zkSslTrustStorePassword();
    }

    public static final /* synthetic */ Option $anonfun$testZkSslKeyStoreType$1(KafkaConfig config) {
        return config.zkSslKeyStoreType();
    }

    public static final /* synthetic */ Option $anonfun$testZkSslTrustStoreType$1(KafkaConfig config) {
        return config.zkSslTrustStoreType();
    }

    public static final /* synthetic */ Some $anonfun$testZkSslProtocol$1(KafkaConfig config) {
        return new Some((Object)config.ZkSslProtocol());
    }

    public static final /* synthetic */ Option $anonfun$testZkSslEnabledProtocols$1(KafkaConfig config) {
        return config.ZkSslEnabledProtocols();
    }

    public static final /* synthetic */ Option $anonfun$testZkSslCipherSuites$1(KafkaConfig config) {
        return config.ZkSslCipherSuites();
    }

    public static final /* synthetic */ void $anonfun$testZkSslEndpointIdentificationAlgorithm$1(String sysProp$1, String propertiesFile$4, String kafkaPropName$1, String expectedDefaultValue$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String sysPropValue = (String)x0$1._1();
            String expected = (String)x0$1._2();
            try {
                System.setProperty(sysProp$1, sysPropValue);
                KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile$4}));
                Assertions.assertNull(config.originals().get(kafkaPropName$1));
                Assertions.assertEquals((Object)expectedDefaultValue$1, config.values().get(kafkaPropName$1));
                Assertions.assertEquals((Object)expected, (Object)config.ZkSslEndpointIdentificationAlgorithm());
            }
            finally {
                System.clearProperty(sysProp$1);
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testZkSslEndpointIdentificationAlgorithm$2(String propertiesFile$4, String kafkaPropName$1, String expected) {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile$4, "--override", new StringBuilder(1).append(kafkaPropName$1).append("=").append(expected).toString()}));
        Assertions.assertEquals((Object)expected, config.originals().get(kafkaPropName$1));
        Assertions.assertEquals((Object)expected, config.values().get(kafkaPropName$1));
        Assertions.assertEquals((Object)expected, (Object)config.ZkSslEndpointIdentificationAlgorithm());
    }

    public static final /* synthetic */ Some $anonfun$testZkSslCrlEnable$1(KafkaConfig config) {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)config.ZkSslCrlEnable()));
    }

    public static final /* synthetic */ Some $anonfun$testZkSslOcspEnable$1(KafkaConfig config) {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)config.ZkSslOcspEnable()));
    }

    public static final /* synthetic */ void $anonfun$prepareConfig$1(OutputStream writer$1, String l) {
        writer$1.write(l.getBytes());
        writer$1.write("\n".getBytes());
    }

    public KafkaConfigTest() {
        this.booleanPropValueToSet = true;
        this.stringPropValueToSet = "foo";
        this.passwordPropValueToSet = "ThePa$$word!";
    }
}

