/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.web;

import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.ResourceUtils;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.HierarchicalMessageSource;
import org.springframework.context.MessageSource;
import org.springframework.context.support.StaticMessageSource;
import org.springframework.ui.context.support.ResourceBundleThemeSource;

public class DefaultCasThemeSource
extends ResourceBundleThemeSource {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCasThemeSource.class);
    private final CasConfigurationProperties casProperties;

    @Nonnull
    protected MessageSource createMessageSource(@Nonnull String basename) {
        return this.casProperties.getView().getTemplatePrefixes().stream().map(prefix -> StringUtils.appendIfMissing((String)prefix, (CharSequence)"/", (CharSequence[])new CharSequence[0]).concat(basename).concat(".properties")).filter(ResourceUtils::doesResourceExist).findFirst().map(Unchecked.function(this::loadMessageSourceFromPath)).map(MessageSource.class::cast).orElseGet(Unchecked.supplier(() -> this.createExtendedMessageSource(basename)));
    }

    protected MessageSource createExtendedMessageSource(String basename) {
        HierarchicalMessageSource source = (HierarchicalMessageSource)super.createMessageSource(StringUtils.replace((String)basename, (String)"-default", (String)"-custom"));
        source.setParentMessageSource(super.createMessageSource(basename));
        return source;
    }

    protected StaticMessageSource loadMessageSourceFromPath(String path) throws Exception {
        StaticMessageSource source = new StaticMessageSource();
        if (ResourceUtils.doesResourceExist((String)path)) {
            try (InputStream is = ResourceUtils.getRawResourceFrom((String)path).getInputStream();){
                Properties properties = new Properties();
                properties.load(is);
                properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> List.of(Locale.US, Locale.CANADA, Locale.ENGLISH).forEach(locale -> {
                    LOGGER.trace("Adding theme property [{}] with value [{}] from [{}] for locale [{}]", new Object[]{key, value, path, locale});
                    source.addMessage(key.toString(), locale, value.toString());
                })));
            }
        }
        return source;
    }

    @Generated
    public DefaultCasThemeSource(CasConfigurationProperties casProperties) {
        this.casProperties = casProperties;
    }
}

