/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.credential;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.warrenstrange.googleauth.IGoogleAuthenticator;
import java.util.Collection;
import java.util.Optional;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.AccountNotFoundException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.OneTimeToken;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorAccount;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorTokenCredential;
import org.apereo.cas.gauth.token.GoogleAuthenticatorToken;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialValidator;
import org.apereo.cas.otp.repository.token.OneTimeTokenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleAuthenticatorOneTimeTokenCredentialValidator
implements OneTimeTokenCredentialValidator<GoogleAuthenticatorTokenCredential, GoogleAuthenticatorToken> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GoogleAuthenticatorOneTimeTokenCredentialValidator.class);
    private final IGoogleAuthenticator googleAuthenticatorInstance;
    private final OneTimeTokenRepository tokenRepository;
    private final OneTimeTokenCredentialRepository credentialRepository;

    private static boolean isCredentialAssignedToAccount(GoogleAuthenticatorTokenCredential credential, OneTimeTokenAccount account) {
        return credential.getAccountId() == null || credential.getAccountId().longValue() == account.getId();
    }

    public GoogleAuthenticatorToken validate(Authentication authentication, GoogleAuthenticatorTokenCredential tokenCredential) throws Throwable {
        if (!StringUtils.isNumeric((CharSequence)tokenCredential.getToken())) {
            throw new PreventedException("Invalid non-numeric OTP format specified.");
        }
        String uid = authentication.getPrincipal().getId();
        int otp = Integer.parseInt(tokenCredential.getToken());
        LOGGER.trace("Received OTP [{}] assigned to account [{}]", (Object)otp, (Object)tokenCredential.getAccountId());
        LOGGER.trace("Received principal id [{}]. Attempting to locate account in credential repository...", (Object)uid);
        Collection accounts = this.credentialRepository.get(uid);
        if (accounts == null || accounts.isEmpty()) {
            throw new AccountNotFoundException(uid + " cannot be found in the registry");
        }
        if (accounts.size() > 1 && tokenCredential.getAccountId() == null) {
            throw new PreventedException("Account identifier must be specified if multiple accounts are registered for " + uid);
        }
        LOGGER.trace("Attempting to locate OTP token [{}] in token repository for [{}]...", (Object)otp, (Object)uid);
        if (this.tokenRepository.exists(uid, Integer.valueOf(otp))) {
            throw new AccountExpiredException(uid + " cannot reuse OTP " + otp + " as it may be expired/invalid");
        }
        LOGGER.debug("Attempting to authorize OTP token [{}]...", (Object)otp);
        Optional<GoogleAuthenticatorAccount> result = this.getAuthorizedAccountForToken(tokenCredential, accounts).or(() -> this.getAuthorizedScratchCodeForToken(tokenCredential, authentication, accounts));
        return result.map(acct -> new GoogleAuthenticatorToken(Integer.valueOf(otp), uid)).orElse(null);
    }

    @CanIgnoreReturnValue
    public OneTimeTokenCredentialValidator<GoogleAuthenticatorTokenCredential, GoogleAuthenticatorToken> store(GoogleAuthenticatorToken validatedToken) {
        this.tokenRepository.store((OneTimeToken)validatedToken);
        return this;
    }

    public boolean isTokenAuthorizedFor(int token, OneTimeTokenAccount account) {
        LOGGER.debug("Authorizing token [{}] against account [{}]", (Object)token, (Object)account);
        boolean authorized = this.googleAuthenticatorInstance.authorize(account.getSecretKey(), token);
        if (!authorized && account.getScratchCodes().stream().map(Number::intValue).toList().contains(token)) {
            LOGGER.debug("Token [{}] is a valid scratch code for account [{}]", (Object)token, (Object)account);
            account.getScratchCodes().removeIf(code -> code.intValue() == token);
            this.credentialRepository.update(account);
            return true;
        }
        return authorized;
    }

    protected Optional<GoogleAuthenticatorAccount> getAuthorizedScratchCodeForToken(GoogleAuthenticatorTokenCredential tokenCredential, Authentication authentication, Collection<? extends OneTimeTokenAccount> accounts) {
        String uid = authentication.getPrincipal().getId();
        int otp = Integer.parseInt(tokenCredential.getToken());
        LOGGER.debug("Checking scratch code [{}] for user [{}]", (Object)otp, (Object)uid);
        return accounts.stream().filter(ac -> GoogleAuthenticatorOneTimeTokenCredentialValidator.isCredentialAssignedToAccount(tokenCredential, ac)).peek(ac -> LOGGER.debug("Comparing existing scratch codes [{}] for account [{}] against [{}]", new Object[]{ac.getScratchCodes(), ac.getId(), otp})).filter(ac -> ac.getScratchCodes().stream().map(Number::intValue).toList().contains(otp)).map(GoogleAuthenticatorAccount.class::cast).peek(acct -> {
            LOGGER.info("Using scratch code [{}] to authenticate user [{}]. Scratch code will be removed", (Object)otp, (Object)uid);
            acct.getScratchCodes().removeIf(token -> token.intValue() == otp);
            this.credentialRepository.update((OneTimeTokenAccount)acct);
        }).findFirst();
    }

    protected Optional<GoogleAuthenticatorAccount> getAuthorizedAccountForToken(GoogleAuthenticatorTokenCredential tokenCredential, Collection<? extends OneTimeTokenAccount> accounts) {
        int otp = Integer.parseInt(tokenCredential.getToken());
        return accounts.stream().filter(ac -> GoogleAuthenticatorOneTimeTokenCredentialValidator.isCredentialAssignedToAccount(tokenCredential, ac) && this.isTokenAuthorizedFor(otp, (OneTimeTokenAccount)ac)).map(GoogleAuthenticatorAccount.class::cast).findFirst();
    }

    @Generated
    public GoogleAuthenticatorOneTimeTokenCredentialValidator(IGoogleAuthenticator googleAuthenticatorInstance, OneTimeTokenRepository tokenRepository, OneTimeTokenCredentialRepository credentialRepository) {
        this.googleAuthenticatorInstance = googleAuthenticatorInstance;
        this.tokenRepository = tokenRepository;
        this.credentialRepository = credentialRepository;
    }

    @Generated
    public IGoogleAuthenticator getGoogleAuthenticatorInstance() {
        return this.googleAuthenticatorInstance;
    }

    @Generated
    public OneTimeTokenRepository getTokenRepository() {
        return this.tokenRepository;
    }

    @Generated
    public OneTimeTokenCredentialRepository getCredentialRepository() {
        return this.credentialRepository;
    }
}

