/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service.wa;

import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.time.LocalDateTime;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.wa.GoogleMfaAuthToken;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Tag(name="WA")
@SecurityRequirements(value={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
@Path(value="wa/gauth/tokens")
public interface GoogleMfaAuthTokenService
extends JAXRSService {
    @DELETE
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void delete(@QueryParam(value="expirationDate") LocalDateTime var1);

    @DELETE
    @Path(value="{owner}/{otp}")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void delete(@NotNull @PathParam(value="owner") String var1, @NotNull @PathParam(value="otp") int var2);

    @DELETE
    @Path(value="{owner}")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void delete(@NotNull @PathParam(value="owner") String var1);

    @DELETE
    @Path(value="otp/{otp}")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void delete(@NotNull @PathParam(value="otp") int var1);

    @PUT
    @Path(value="{owner}")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void store(@NotNull @PathParam(value="owner") String var1, @NotNull GoogleMfaAuthToken var2);

    @GET
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Path(value="{owner}/{otp}")
    public GoogleMfaAuthToken read(@NotNull @PathParam(value="owner") String var1, @NotNull @PathParam(value="otp") int var2);

    @GET
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Path(value="{owner}")
    public PagedResult<GoogleMfaAuthToken> read(@NotNull @PathParam(value="owner") String var1);

    @GET
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public PagedResult<GoogleMfaAuthToken> list();
}

