/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl.types;

import org.flowable.common.engine.impl.joda.JodaDeprecationLogger;
import org.flowable.variable.api.types.ValueFields;
import org.flowable.variable.api.types.VariableType;
import org.joda.time.LocalDate;

public class JodaDateType
implements VariableType {
    public static final String TYPE_NAME = "jodadate";

    public String getTypeName() {
        return TYPE_NAME;
    }

    public boolean isCachable() {
        return true;
    }

    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        return LocalDate.class.isAssignableFrom(value.getClass());
    }

    public Object getValue(ValueFields valueFields) {
        Long longValue = valueFields.getLongValue();
        if (longValue != null) {
            return new LocalDate((Object)longValue);
        }
        return null;
    }

    public void setValue(Object value, ValueFields valueFields) {
        if (value != null) {
            if (valueFields.getTaskId() != null) {
                JodaDeprecationLogger.LOGGER.warn("Using Joda-Time LocalDate has been deprecated and will be removed in a future version. Task Variable {} in task {} was a Joda-Time LocalDate. ", (Object)valueFields.getName(), (Object)valueFields.getTaskId());
            } else if (valueFields.getProcessInstanceId() != null) {
                JodaDeprecationLogger.LOGGER.warn("Using Joda-Time LocalDate has been deprecated and will be removed in a future version. Process Variable {} in process instance {} and execution {} was a Joda-Time LocalDate. ", new Object[]{valueFields.getName(), valueFields.getProcessInstanceId(), valueFields.getExecutionId()});
            } else {
                JodaDeprecationLogger.LOGGER.warn("Using Joda-Time LocalDate has been deprecated and will be removed in a future version. Variable {} in {} instance {} and sub-scope {} was a Joda-Time LocalDate. ", new Object[]{valueFields.getName(), valueFields.getScopeType(), valueFields.getScopeId(), valueFields.getSubScopeId()});
            }
            valueFields.setLongValue(Long.valueOf(((LocalDate)value).toDateTimeAtStartOfDay().getMillis()));
        } else {
            valueFields.setLongValue(null);
        }
    }
}

