/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator.token;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.token.BaseOAuth20TokenRequestValidator;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.apereo.cas.util.function.FunctionUtils;
import org.jooq.lambda.Unchecked;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20AuthorizationCodeGrantTypeTokenRequestValidator
extends BaseOAuth20TokenRequestValidator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20AuthorizationCodeGrantTypeTokenRequestValidator.class);

    public OAuth20AuthorizationCodeGrantTypeTokenRequestValidator(OAuth20ConfigurationContext configurationContext) {
        super(configurationContext);
    }

    @Override
    protected OAuth20GrantTypes getGrantType() {
        return OAuth20GrantTypes.AUTHORIZATION_CODE;
    }

    @Override
    protected boolean validateInternal(WebContext context, String grantType, ProfileManager manager, UserProfile uProfile) throws Throwable {
        boolean valid;
        Optional redirectUri = this.getConfigurationContext().getRequestParameterResolver().resolveRequestParameter(context, "redirect_uri");
        Optional code = this.getConfigurationContext().getRequestParameterResolver().resolveRequestParameter(context, "code");
        String clientId = ObjectUtils.defaultIfNull((Object)uProfile.getAttribute("client_id"), (Object)uProfile.getId()).toString();
        LOGGER.debug("Locating registered service for client id [{}]", (Object)clientId);
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(this.getConfigurationContext().getServicesManager(), clientId);
        RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((RegisteredService)registeredService);
        LOGGER.debug("Received grant type [{}] with client id [{}] and redirect URI [{}]", new Object[]{grantType, clientId, redirectUri});
        boolean bl = valid = redirectUri.isPresent() && code.isPresent() && OAuth20Utils.checkCallbackValid((RegisteredService)registeredService, (String)redirectUri.get());
        if (valid) {
            OAuth20Code oauthCode = (OAuth20Code)FunctionUtils.doAndHandle(() -> {
                OAuth20Code state = (OAuth20Code)this.getConfigurationContext().getTicketRegistry().getTicket((String)code.get(), OAuth20Code.class);
                return state == null || state.isExpired() ? null : state;
            });
            if (oauthCode == null || oauthCode.isExpired()) {
                boolean removeTokens = this.getConfigurationContext().getCasProperties().getAuthn().getOauth().getCode().isRemoveRelatedAccessTokens();
                if (removeTokens) {
                    LOGGER.debug("Code [{}] is invalid or expired. Attempting to revoke access tokens issued to the code", code.get());
                    Stream accessTokensByCode = this.getConfigurationContext().getTicketRegistry().getTickets(ticket -> {
                        OAuth20AccessToken accessToken;
                        return ticket instanceof OAuth20AccessToken && StringUtils.equalsIgnoreCase((CharSequence)(accessToken = (OAuth20AccessToken)ticket).getToken(), (CharSequence)((CharSequence)code.get()));
                    });
                    accessTokensByCode.forEach(Unchecked.consumer(ticket -> {
                        LOGGER.debug("Removing access token [{}] issued via expired/unknown code [{}]", (Object)ticket.getId(), code.get());
                        this.getConfigurationContext().getTicketRegistry().deleteTicket(ticket);
                    }));
                }
                LOGGER.warn("Provided OAuth code [{}] is not found or has expired", code.get());
                return false;
            }
            String serviceId = oauthCode.getService().getId();
            OAuthRegisteredService codeRegisteredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(this.getConfigurationContext().getServicesManager(), serviceId);
            Authentication authentication = OAuth20AuthorizationCodeGrantTypeTokenRequestValidator.resolveAuthenticationFrom(oauthCode);
            Principal originalPrincipal = authentication.getPrincipal();
            Map accessStrategyAttributes = CoreAuthenticationUtils.mergeAttributes((Map)originalPrincipal.getAttributes(), (Map)oauthCode.getAuthentication().getPrincipal().getAttributes());
            Principal accessStrategyPrincipal = this.getConfigurationContext().getPrincipalFactory().createPrincipal(oauthCode.getAuthentication().getPrincipal().getId(), accessStrategyAttributes);
            AuditableContext audit = AuditableContext.builder().service(oauthCode.getService()).registeredService((RegisteredService)codeRegisteredService).authentication(oauthCode.getAuthentication()).principal(accessStrategyPrincipal).build();
            AuditableExecutionResult accessResult = this.getConfigurationContext().getRegisteredServiceAccessStrategyEnforcer().execute(audit);
            accessResult.throwExceptionIfNeeded();
            if (!registeredService.equals((Object)codeRegisteredService)) {
                LOGGER.warn("OAuth code [{}] issued to service [{}] does not match [{}] provided, given the redirect URI [{}]", new Object[]{code, serviceId, registeredService.getName(), redirectUri});
                return false;
            }
            if (!this.isGrantTypeSupportedBy(registeredService, grantType)) {
                LOGGER.warn("Requested grant type [{}] is not authorized by service definition [{}]", (Object)grantType, (Object)registeredService.getServiceId());
                return false;
            }
            return true;
        }
        LOGGER.warn("Access token request cannot be validated for grant type [{}] and client id [{}] given the redirect URI [{}]", new Object[]{grantType, clientId, redirectUri});
        return false;
    }
}

