/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.action.impl;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.security.AccessControlService;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class CheckAccess
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CheckAccess.class);
    @NonnullAfterInit
    private AccessControlService service;
    @Nonnull
    private Function<ProfileRequestContext, String> policyNameLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, String> operationLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, String> resourceLookupStrategy = FunctionSupport.constant(null);

    public void setAccessControlService(@Nonnull AccessControlService acs) {
        this.checkSetterPreconditions();
        this.service = (AccessControlService)Constraint.isNotNull((Object)acs, (String)"AccessControlService cannot be null");
    }

    public void setPolicyNameLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.policyNameLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Policy lookup strategy cannot be null");
    }

    public void setPolicyName(@Nonnull @NotEmpty String name) {
        this.checkSetterPreconditions();
        this.policyNameLookupStrategy = FunctionSupport.constant((Object)((String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Policy name cannot be null or empty")));
    }

    public void setOperationLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.operationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Policy lookup strategy cannot be null");
    }

    public void setOperation(@Nullable String op) {
        this.checkSetterPreconditions();
        this.operationLookupStrategy = FunctionSupport.constant((Object)StringSupport.trimOrNull((String)op));
    }

    public void setResourceLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.resourceLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Policy lookup strategy cannot be null");
    }

    public void setResource(@Nullable String res) {
        this.checkSetterPreconditions();
        this.resourceLookupStrategy = FunctionSupport.constant((Object)StringSupport.trimOrNull((String)res));
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.service == null) {
            throw new ComponentInitializationException("AccessControlService cannot be null");
        }
    }

    public void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        HttpServletRequest httpRequest = this.getHttpServletRequest();
        if (httpRequest == null) {
            this.log.warn("{} HttpServletRequest was null, disallowing access", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AccessDenied");
            return;
        }
        String policyName = this.policyNameLookupStrategy.apply(profileRequestContext);
        if (policyName == null) {
            this.log.warn("{} No policy name returned by lookup strategy, disallowing access", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AccessDenied");
        } else if (!this.service.getInstance(policyName).checkAccess((ServletRequest)httpRequest, this.operationLookupStrategy.apply(profileRequestContext), this.resourceLookupStrategy.apply(profileRequestContext))) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AccessDenied");
        }
    }
}

