/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.fasterxml.jackson.databind.ser.std;

import com.signalfx.shaded.fasterxml.jackson.core.JsonGenerator;
import com.signalfx.shaded.fasterxml.jackson.core.JsonToken;
import com.signalfx.shaded.fasterxml.jackson.core.type.WritableTypeId;
import com.signalfx.shaded.fasterxml.jackson.databind.JavaType;
import com.signalfx.shaded.fasterxml.jackson.databind.JsonMappingException;
import com.signalfx.shaded.fasterxml.jackson.databind.JsonNode;
import com.signalfx.shaded.fasterxml.jackson.databind.SerializerProvider;
import com.signalfx.shaded.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.signalfx.shaded.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.signalfx.shaded.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.signalfx.shaded.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

@JacksonStdImpl
public class ToEmptyObjectSerializer
extends StdSerializer<Object> {
    protected ToEmptyObjectSerializer(Class<?> raw) {
        super(raw, false);
    }

    public ToEmptyObjectSerializer(JavaType type) {
        super(type);
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider ctxt) throws IOException {
        gen.writeStartObject(value, 0);
        gen.writeEndObject();
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator gen, SerializerProvider ctxt, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId(value, JsonToken.START_OBJECT));
        typeSer.writeTypeSuffix(gen, typeIdDef);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, Object value) {
        return true;
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return null;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        visitor.expectObjectFormat(typeHint);
    }
}

