/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.cookie.CookieProperties;
import org.apereo.cas.configuration.model.support.mfa.trusteddevice.DeviceFingerprintProperties;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.trusted.util.cipher.CookieDeviceFingerprintComponentCipherExecutor;
import org.apereo.cas.trusted.web.flow.fingerprint.BrowserDeviceFingerprintExtractor;
import org.apereo.cas.trusted.web.flow.fingerprint.ClientIpDeviceFingerprintExtractor;
import org.apereo.cas.trusted.web.flow.fingerprint.CookieDeviceFingerprintExtractor;
import org.apereo.cas.trusted.web.flow.fingerprint.DefaultDeviceFingerprintStrategy;
import org.apereo.cas.trusted.web.flow.fingerprint.DeviceFingerprintExtractor;
import org.apereo.cas.trusted.web.flow.fingerprint.DeviceFingerprintStrategy;
import org.apereo.cas.trusted.web.flow.fingerprint.GeoLocationDeviceFingerprintExtractor;
import org.apereo.cas.trusted.web.flow.fingerprint.UserAgentDeviceFingerprintExtractor;
import org.apereo.cas.util.cipher.CipherExecutorUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.gen.Base64RandomStringGenerator;
import org.apereo.cas.util.gen.RandomStringGenerator;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.cookie.CookieValueManager;
import org.apereo.cas.web.support.CookieUtils;
import org.apereo.cas.web.support.gen.CookieRetrievingCookieGenerator;
import org.apereo.cas.web.support.mgmr.DefaultCookieSameSitePolicy;
import org.apereo.cas.web.support.mgmr.EncryptedCookieValueManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.MultifactorAuthenticationTrustedDevices})
@Configuration(value="MultifactorAuthnTrustedDeviceFingerprintConfiguration", proxyBeanMethods=false)
class MultifactorAuthnTrustedDeviceFingerprintConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MultifactorAuthnTrustedDeviceFingerprintConfiguration.class);

    MultifactorAuthnTrustedDeviceFingerprintConfiguration() {
    }

    @AutoConfigureOrder(value=0x7FFFFFFF)
    @ConditionalOnBean(name={"geoLocationService"})
    @Configuration(value="MultifactorAuthnTrustedDeviceGeoLocationConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class MultifactorAuthnTrustedDeviceGeoLocationConfiguration {
        MultifactorAuthnTrustedDeviceGeoLocationConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"deviceFingerprintGeoLocationComponentExtractor"})
        public DeviceFingerprintExtractor deviceFingerprintGeoLocationComponentExtractor(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="geoLocationService") ObjectProvider<GeoLocationService> geoLocationService) {
            return (DeviceFingerprintExtractor)BeanSupplier.of(DeviceFingerprintExtractor.class).when(BeanCondition.on((String)"cas.authn.mfa.trusted.device-fingerprint.geolocation.enabled").isTrue().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                DeviceFingerprintProperties.GeoLocation properties = casProperties.getAuthn().getMfa().getTrusted().getDeviceFingerprint().getGeolocation();
                GeoLocationDeviceFingerprintExtractor component = new GeoLocationDeviceFingerprintExtractor((GeoLocationService)geoLocationService.getObject());
                component.setOrder(properties.getOrder());
                return component;
            }).otherwiseProxy().get();
        }
    }

    @Configuration(value="MultifactorAuthnTrustedDeviceFingerprintCookieConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class MultifactorAuthnTrustedDeviceFingerprintCookieConfiguration {
        MultifactorAuthnTrustedDeviceFingerprintCookieConfiguration() {
        }

        @ConditionalOnMissingBean(name={"deviceFingerprintCookieGenerator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasCookieBuilder deviceFingerprintCookieGenerator(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="deviceFingerprintCookieValueManager") CookieValueManager deviceFingerprintCookieValueManager) {
            return (CasCookieBuilder)BeanSupplier.of(CasCookieBuilder.class).when(BeanCondition.on((String)"cas.authn.mfa.trusted.device-fingerprint.cookie.enabled").isTrue().evenIfMissing().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                DeviceFingerprintProperties.Cookie cookie = casProperties.getAuthn().getMfa().getTrusted().getDeviceFingerprint().getCookie();
                return new CookieRetrievingCookieGenerator(CookieUtils.buildCookieGenerationContext((CookieProperties)cookie), deviceFingerprintCookieValueManager);
            }).otherwiseProxy().get();
        }

        @ConditionalOnMissingBean(name={"deviceFingerprintCookieRandomStringGenerator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public RandomStringGenerator deviceFingerprintCookieRandomStringGenerator() {
            return new Base64RandomStringGenerator();
        }

        @Bean
        @ConditionalOnMissingBean(name={"deviceFingerprintCookieValueManager"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CookieValueManager deviceFingerprintCookieValueManager(@Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, @Qualifier(value="deviceFingerprintCookieCipherExecutor") CipherExecutor deviceFingerprintCookieCipherExecutor) {
            return new EncryptedCookieValueManager(deviceFingerprintCookieCipherExecutor, tenantExtractor, DefaultCookieSameSitePolicy.INSTANCE);
        }

        @ConditionalOnMissingBean(name={"deviceFingerprintCookieCipherExecutor"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CipherExecutor deviceFingerprintCookieCipherExecutor(CasConfigurationProperties casProperties) {
            DeviceFingerprintProperties.Cookie cookie = casProperties.getAuthn().getMfa().getTrusted().getDeviceFingerprint().getCookie();
            EncryptionJwtSigningJwtCryptographyProperties crypto = cookie.getCrypto();
            boolean enabled = crypto.isEnabled();
            if (!enabled && StringUtils.isNotBlank((CharSequence)crypto.getEncryption().getKey()) && StringUtils.isNotBlank((CharSequence)crypto.getSigning().getKey())) {
                LOGGER.warn("Token encryption/signing is not enabled explicitly in the configuration for cookie [{}], yet signing/encryption keys are defined for operations. CAS will proceed to enable the cookie encryption/signing functionality.", (Object)cookie.getName());
                enabled = true;
            }
            if (enabled) {
                return CipherExecutorUtils.newStringCipherExecutor((EncryptionJwtSigningJwtCryptographyProperties)crypto, CookieDeviceFingerprintComponentCipherExecutor.class);
            }
            return CipherExecutor.noOp();
        }
    }

    @Configuration(value="MultifactorAuthnTrustedDeviceFingerprintStrategyConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class MultifactorAuthnTrustedDeviceFingerprintStrategyConfiguration {
        MultifactorAuthnTrustedDeviceFingerprintStrategyConfiguration() {
        }

        @ConditionalOnMissingBean(name={"deviceFingerprintStrategy"})
        @Bean(value={"deviceFingerprintStrategy"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public DeviceFingerprintStrategy deviceFingerprintStrategy(List<DeviceFingerprintExtractor> extractors, CasConfigurationProperties casProperties) {
            DeviceFingerprintProperties properties = casProperties.getAuthn().getMfa().getTrusted().getDeviceFingerprint();
            List activeExtractors = extractors.stream().filter(BeanSupplier::isNotProxy).collect(Collectors.toList());
            return new DefaultDeviceFingerprintStrategy(activeExtractors, properties.getCore().getComponentSeparator());
        }
    }

    @Configuration(value="MultifactorAuthnTrustedDeviceFingerprintComponentConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class MultifactorAuthnTrustedDeviceFingerprintComponentConfiguration {
        MultifactorAuthnTrustedDeviceFingerprintComponentConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"deviceFingerprintUserAgentComponentExtractor"})
        public DeviceFingerprintExtractor deviceFingerprintUserAgentComponentExtractor(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (DeviceFingerprintExtractor)BeanSupplier.of(DeviceFingerprintExtractor.class).when(BeanCondition.on((String)"cas.authn.mfa.trusted.device-fingerprint.user-agent.enabled").isTrue().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                DeviceFingerprintProperties.UserAgent properties = casProperties.getAuthn().getMfa().getTrusted().getDeviceFingerprint().getUserAgent();
                UserAgentDeviceFingerprintExtractor component = new UserAgentDeviceFingerprintExtractor();
                component.setOrder(properties.getOrder());
                return component;
            }).otherwiseProxy().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"browserFingerprintComponentExtractor"})
        public DeviceFingerprintExtractor browserFingerprintComponentExtractor(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (DeviceFingerprintExtractor)BeanSupplier.of(DeviceFingerprintExtractor.class).when(BeanCondition.on((String)"cas.authn.mfa.trusted.device-fingerprint.browser.enabled").isTrue().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                DeviceFingerprintProperties.GeoLocation properties = casProperties.getAuthn().getMfa().getTrusted().getDeviceFingerprint().getBrowser();
                BrowserDeviceFingerprintExtractor component = new BrowserDeviceFingerprintExtractor();
                component.setOrder(properties.getOrder());
                return component;
            }).otherwiseProxy().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"deviceFingerprintClientIpComponentExtractor"})
        public DeviceFingerprintExtractor deviceFingerprintClientIpComponentExtractor(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (DeviceFingerprintExtractor)BeanSupplier.of(DeviceFingerprintExtractor.class).when(BeanCondition.on((String)"cas.authn.mfa.trusted.device-fingerprint.client-ip.enabled").isTrue().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                DeviceFingerprintProperties.ClientIp properties = casProperties.getAuthn().getMfa().getTrusted().getDeviceFingerprint().getClientIp();
                ClientIpDeviceFingerprintExtractor component = new ClientIpDeviceFingerprintExtractor();
                component.setOrder(properties.getOrder());
                return component;
            }).otherwiseProxy().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"deviceFingerprintCookieComponentExtractor"})
        public DeviceFingerprintExtractor deviceFingerprintCookieComponentExtractor(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="deviceFingerprintCookieGenerator") CasCookieBuilder deviceFingerprintCookieGenerator, @Qualifier(value="deviceFingerprintCookieRandomStringGenerator") RandomStringGenerator deviceFingerprintCookieRandomStringGenerator) {
            return (DeviceFingerprintExtractor)BeanSupplier.of(DeviceFingerprintExtractor.class).when(BeanCondition.on((String)"cas.authn.mfa.trusted.device-fingerprint.cookie.enabled").isTrue().evenIfMissing().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                DeviceFingerprintProperties.Cookie properties = casProperties.getAuthn().getMfa().getTrusted().getDeviceFingerprint().getCookie();
                CookieDeviceFingerprintExtractor component = new CookieDeviceFingerprintExtractor(deviceFingerprintCookieGenerator, deviceFingerprintCookieRandomStringGenerator);
                component.setOrder(properties.getOrder());
                return component;
            }).otherwiseProxy().get();
        }
    }
}

