/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.context.properties;

import java.util.Set;
import org.springframework.boot.actuate.context.properties.ConfigurationPropertiesReportEndpoint;
import org.springframework.boot.actuate.endpoint.SecurityContext;
import org.springframework.boot.actuate.endpoint.Show;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.annotation.EndpointWebExtension;

@EndpointWebExtension(endpoint=ConfigurationPropertiesReportEndpoint.class)
public class ConfigurationPropertiesReportEndpointWebExtension {
    private final ConfigurationPropertiesReportEndpoint delegate;
    private final Show showValues;
    private final Set<String> roles;

    public ConfigurationPropertiesReportEndpointWebExtension(ConfigurationPropertiesReportEndpoint delegate, Show showValues, Set<String> roles) {
        this.delegate = delegate;
        this.showValues = showValues;
        this.roles = roles;
    }

    @ReadOperation
    public ConfigurationPropertiesReportEndpoint.ConfigurationPropertiesDescriptor configurationProperties(SecurityContext securityContext) {
        boolean showUnsanitized = this.showValues.isShown(securityContext, this.roles);
        return this.delegate.getConfigurationProperties(showUnsanitized);
    }

    @ReadOperation
    public WebEndpointResponse<ConfigurationPropertiesReportEndpoint.ConfigurationPropertiesDescriptor> configurationPropertiesWithPrefix(SecurityContext securityContext, @Selector String prefix) {
        boolean showUnsanitized = this.showValues.isShown(securityContext, this.roles);
        ConfigurationPropertiesReportEndpoint.ConfigurationPropertiesDescriptor configurationProperties = this.delegate.getConfigurationProperties(prefix, showUnsanitized);
        boolean foundMatchingBeans = configurationProperties.getContexts().values().stream().anyMatch(context -> !context.getBeans().isEmpty());
        return foundMatchingBeans ? new WebEndpointResponse<ConfigurationPropertiesReportEndpoint.ConfigurationPropertiesDescriptor>(configurationProperties, 200) : new WebEndpointResponse<int>(404);
    }
}

