/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.persistence.entity;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.ibatis.session.RowBounds;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.management.TableMetaData;
import org.flowable.common.engine.api.management.TablePage;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.db.DbSqlSession;
import org.flowable.common.engine.impl.persistence.entity.TableDataManager;
import org.flowable.common.engine.impl.persistence.entity.TablePageQueryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableDataManagerImpl
implements TableDataManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableDataManagerImpl.class);
    protected AbstractEngineConfiguration engineConfiguration;

    public TableDataManagerImpl(AbstractEngineConfiguration engineConfiguration) {
        this.engineConfiguration = engineConfiguration;
    }

    @Override
    public Map<String, Long> getTableCount() {
        HashMap<String, Long> tableCount = new HashMap<String, Long>();
        try {
            for (String tableName : this.getTablesPresentInDatabase()) {
                tableCount.put(tableName, this.getTableCount(tableName));
            }
            LOGGER.debug("Number of rows per flowable table: {}", tableCount);
        }
        catch (Exception e) {
            throw new FlowableException("couldn't get table counts", (Throwable)e);
        }
        return tableCount;
    }

    @Override
    public List<String> getTablesPresentInDatabase() {
        ArrayList<String> tableNames = new ArrayList<String>();
        try {
            Connection connection = this.getDbSqlSession().getSqlSession().getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            LOGGER.debug("retrieving flowable tables from jdbc metadata");
            String databaseTablePrefix = this.getDbSqlSession().getDbSqlSessionFactory().getDatabaseTablePrefix();
            String actTableNameFilter = this.getTableNameFilter(databaseMetaData, databaseTablePrefix, "ACT");
            String flwTableNameFilter = this.getTableNameFilter(databaseMetaData, databaseTablePrefix, "FLW");
            String catalog = this.getDatabaseCatalog();
            String schema = this.getDatabaseSchema();
            tableNames.addAll(this.getTableNames(databaseMetaData, catalog, schema, actTableNameFilter));
            tableNames.addAll(this.getTableNames(databaseMetaData, catalog, schema, flwTableNameFilter));
        }
        catch (Exception e) {
            throw new FlowableException("couldn't get flowable table names using metadata: " + e.getMessage(), (Throwable)e);
        }
        return tableNames;
    }

    protected String getTableNameFilter(DatabaseMetaData databaseMetaData, String databaseTablePrefix, String flowableTablePrefix) throws SQLException {
        String tableNameFilter = "postgres".equals(this.getDbSqlSession().getDbSqlSessionFactory().getDatabaseType()) || "cockroachdb".equals(this.getDbSqlSession().getDbSqlSessionFactory().getDatabaseType()) ? databaseTablePrefix + flowableTablePrefix.toLowerCase(Locale.ROOT) + databaseMetaData.getSearchStringEscape() + "_%" : databaseTablePrefix + flowableTablePrefix + databaseMetaData.getSearchStringEscape() + "_%";
        return tableNameFilter;
    }

    protected List<String> getTableNames(DatabaseMetaData databaseMetaData, String catalog, String schema, String tableNameFilter) throws SQLException {
        ArrayList<String> tableNames = new ArrayList<String>();
        try (ResultSet tables = databaseMetaData.getTables(catalog, schema, tableNameFilter, DbSqlSession.JDBC_METADATA_TABLE_TYPES);){
            while (tables.next()) {
                String tableName = tables.getString("TABLE_NAME");
                tableName = tableName.toUpperCase(Locale.ROOT);
                tableNames.add(tableName);
                LOGGER.debug("retrieved flowable table name {}", (Object)tableName);
            }
        }
        return tableNames;
    }

    protected String getDatabaseCatalog() {
        String catalog = null;
        if (this.engineConfiguration.getDatabaseCatalog() != null && this.engineConfiguration.getDatabaseCatalog().length() > 0) {
            catalog = this.engineConfiguration.getDatabaseCatalog();
        }
        return catalog;
    }

    protected String getDatabaseSchema() {
        String schema = null;
        if (this.engineConfiguration.getDatabaseSchema() != null && this.engineConfiguration.getDatabaseSchema().length() > 0) {
            schema = "oracle".equals(this.getDbSqlSession().getDbSqlSessionFactory().getDatabaseType()) ? this.engineConfiguration.getDatabaseSchema().toUpperCase(Locale.ROOT) : this.engineConfiguration.getDatabaseSchema();
        }
        return schema;
    }

    protected long getTableCount(String tableName) {
        LOGGER.debug("selecting table count for {}", (Object)tableName);
        Long count = (Long)this.getDbSqlSession().selectOne("org.flowable.common.engine.impl.TablePageMap.selectTableCount", Collections.singletonMap("tableName", tableName));
        return count;
    }

    @Override
    public TablePage getTablePage(TablePageQueryImpl tablePageQuery, int firstResult, int maxResults) {
        TablePage tablePage = new TablePage();
        List tableData = this.getDbSqlSession().getSqlSession().selectList("org.flowable.common.engine.impl.TablePageMap.selectTableData", (Object)tablePageQuery, new RowBounds(firstResult, maxResults));
        tablePage.setTableName(tablePageQuery.getTableName());
        tablePage.setTotal(this.getTableCount(tablePageQuery.getTableName()));
        tablePage.setRows(tableData);
        tablePage.setFirstResult((long)firstResult);
        return tablePage;
    }

    @Override
    public TableMetaData getTableMetaData(String tableName) {
        TableMetaData result = new TableMetaData();
        try {
            result.setTableName(tableName);
            DatabaseMetaData metaData = this.getDbSqlSession().getSqlSession().getConnection().getMetaData();
            if ("postgres".equals(this.getDbSqlSession().getDbSqlSessionFactory().getDatabaseType()) || "cockroachdb".equals(this.getDbSqlSession().getDbSqlSessionFactory().getDatabaseType())) {
                tableName = tableName.toLowerCase(Locale.ROOT);
            }
            String catalog = this.getDatabaseCatalog();
            String schema = this.getDatabaseSchema();
            ResultSet resultSet = metaData.getColumns(catalog, schema, tableName, null);
            while (resultSet.next()) {
                boolean wrongSchema = false;
                if (schema != null && schema.length() > 0) {
                    for (int i = 0; i < resultSet.getMetaData().getColumnCount(); ++i) {
                        String columnName = resultSet.getMetaData().getColumnName(i + 1);
                        if (!"TABLE_SCHEM".equalsIgnoreCase(columnName) && !"TABLE_SCHEMA".equalsIgnoreCase(columnName)) continue;
                        if (schema.equalsIgnoreCase(resultSet.getString(resultSet.getMetaData().getColumnName(i + 1)))) break;
                        wrongSchema = true;
                        break;
                    }
                }
                if (wrongSchema) continue;
                String name = resultSet.getString("COLUMN_NAME").toUpperCase(Locale.ROOT);
                String type = resultSet.getString("TYPE_NAME").toUpperCase(Locale.ROOT);
                result.addColumnMetaData(name, type);
            }
        }
        catch (SQLException e) {
            throw new FlowableException("Could not retrieve database metadata: " + e.getMessage());
        }
        if (result.getColumnNames().isEmpty()) {
            result = null;
        }
        return result;
    }

    protected DbSqlSession getDbSqlSession() {
        return Context.getCommandContext().getSession(DbSqlSession.class);
    }
}

