/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.aot;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.builder.xml.XMLMapperEntityResolver;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.parsing.XPathParser;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.ResourceHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.TypeReference;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.xml.sax.EntityResolver;

public class FlowableMyBatisResourceHintsRegistrar {
    public static void registerMappingResources(String baseFolder, RuntimeHints runtimeHints, ClassLoader classLoader) {
        ResourceHints resourceHints = runtimeHints.resources();
        String mappingsPath = baseFolder + "/mappings.xml";
        ClassPathResource mappingsResource = new ClassPathResource(mappingsPath);
        resourceHints.registerResource((Resource)mappingsResource);
        try (InputStream mappingsStream = mappingsResource.getInputStream();){
            XPathParser parser = FlowableMyBatisResourceHintsRegistrar.createParser(mappingsStream);
            List mappers = parser.evalNodes("/configuration/mappers/mapper");
            for (XNode mapper : mappers) {
                FlowableMyBatisResourceHintsRegistrar.registerMapper(mapper.getStringAttribute("resource"), runtimeHints, classLoader);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read mappings " + mappingsPath, e);
        }
    }

    public static void registerMapper(String mapperPath, RuntimeHints hints, ClassLoader classLoader) {
        ResourceHints resourceHints = hints.resources();
        ClassPathResource mapperResource = new ClassPathResource(mapperPath);
        resourceHints.registerResource((Resource)mapperResource);
        ReflectionHints reflectionHints = hints.reflection();
        MemberCategory[] memberCategories = MemberCategory.values();
        try (InputStream mapperStream = mapperResource.getInputStream();){
            XPathParser parser = FlowableMyBatisResourceHintsRegistrar.createParser(mapperStream);
            XNode mapper = parser.evalNode("/mapper");
            for (XNode resultMap : mapper.evalNodes("/mapper/resultMap")) {
                String type = resultMap.getStringAttribute("type");
                if (type == null) continue;
                reflectionHints.registerType(TypeReference.of((String)type), memberCategories);
            }
            for (XNode statement : mapper.evalNodes("select|insert|update|delete")) {
                String resultType;
                String parameterType = statement.getStringAttribute("parameterType");
                if (parameterType != null) {
                    if (parameterType.startsWith("org.flowable") || parameterType.startsWith("java.")) {
                        reflectionHints.registerType(TypeReference.of((String)parameterType), memberCategories);
                    } else if (parameterType.equals("map")) {
                        reflectionHints.registerType(Map.class, memberCategories);
                    }
                }
                if ((resultType = statement.getStringAttribute("resultType")) == null) continue;
                if (resultType.equals("long")) {
                    reflectionHints.registerType(Long.TYPE, memberCategories);
                    reflectionHints.registerType(Long.class, memberCategories);
                    continue;
                }
                if (resultType.equals("string")) {
                    reflectionHints.registerType(String.class, memberCategories);
                    continue;
                }
                if (!resultType.equals("map")) continue;
                reflectionHints.registerType(HashMap.class, memberCategories);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read mapper from " + mapperPath, e);
        }
    }

    protected static XPathParser createParser(InputStream stream) {
        return new XPathParser(stream, false, null, (EntityResolver)new XMLMapperEntityResolver());
    }
}

