/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl;

import java.util.function.Consumer;
import org.flowable.common.engine.api.Engine;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;

public abstract class AbstractBuildableEngineConfiguration<E extends Engine>
extends AbstractEngineConfiguration {
    protected boolean runPostEngineBuildConsumer = true;
    protected Consumer<E> postEngineBuildConsumer;

    public E buildEngine() {
        this.init();
        this.initPostEngineBuildConsumer();
        E engine = this.createEngine();
        if (this.runPostEngineBuildConsumer) {
            this.postEngineBuildConsumer.accept(engine);
        }
        return engine;
    }

    protected abstract E createEngine();

    protected abstract void init();

    protected void initPostEngineBuildConsumer() {
        if (this.postEngineBuildConsumer == null) {
            this.postEngineBuildConsumer = this.createPostEngineBuildConsumer();
        }
    }

    protected abstract Consumer<E> createPostEngineBuildConsumer();

    public boolean isRunPostEngineBuildConsumer() {
        return this.runPostEngineBuildConsumer;
    }

    public void setRunPostEngineBuildConsumer(boolean runPostEngineBuildConsumer) {
        this.runPostEngineBuildConsumer = runPostEngineBuildConsumer;
    }

    public Consumer<E> getPostEngineBuildConsumer() {
        return this.postEngineBuildConsumer;
    }

    public void setPostEngineBuildConsumer(Consumer<E> postEngineBuildConsumer) {
        this.postEngineBuildConsumer = postEngineBuildConsumer;
    }
}

