/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics;

import java.util.Collections;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class KafkaMetricTest {
    private static final MetricName METRIC_NAME = new MetricName("name", "group", "description", Collections.emptyMap());

    @Test
    public void testIsMeasurable() {
        Measurable metricValueProvider = (config, now) -> 0.0;
        KafkaMetric metric = new KafkaMetric(new Object(), METRIC_NAME, (MetricValueProvider)metricValueProvider, new MetricConfig(), (Time)new MockTime());
        Assertions.assertTrue((boolean)metric.isMeasurable());
        Assertions.assertEquals((Object)metricValueProvider, (Object)metric.measurable());
    }

    @Test
    public void testIsMeasurableWithGaugeProvider() {
        Gauge metricValueProvider = (config, now) -> 0.0;
        KafkaMetric metric = new KafkaMetric(new Object(), METRIC_NAME, (MetricValueProvider)metricValueProvider, new MetricConfig(), (Time)new MockTime());
        Assertions.assertFalse((boolean)metric.isMeasurable());
        Assertions.assertThrows(IllegalStateException.class, () -> ((KafkaMetric)metric).measurable());
    }
}

