/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.mustache;

import com.samskivert.mustache.BasicCollector;
import com.samskivert.mustache.Mustache;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultCollector
extends BasicCollector {
    private final boolean _allowAccessCoercion;

    public DefaultCollector() {
        this(true);
    }

    public DefaultCollector(boolean allowAccessCoercion) {
        this._allowAccessCoercion = allowAccessCoercion;
    }

    @Override
    public Mustache.VariableFetcher createFetcher(Object ctx, String name) {
        Mustache.VariableFetcher fetcher = super.createFetcher(ctx, name);
        if (fetcher != null) {
            return fetcher;
        }
        Class<?> cclass = ctx.getClass();
        final Method m = this.getMethod(cclass, name);
        if (m != null) {
            return new Mustache.VariableFetcher(){

                @Override
                public Object get(Object ctx, String name) throws Exception {
                    return m.invoke(ctx, new Object[0]);
                }
            };
        }
        final Field f = this.getField(cclass, name);
        if (f != null) {
            return new Mustache.VariableFetcher(){

                @Override
                public Object get(Object ctx, String name) throws Exception {
                    return f.get(ctx);
                }
            };
        }
        final Method im = this.getIfaceMethod(cclass, name);
        if (im != null) {
            return new Mustache.VariableFetcher(){

                @Override
                public Object get(Object ctx, String name) throws Exception {
                    return im.invoke(ctx, new Object[0]);
                }
            };
        }
        return null;
    }

    @Override
    public <K, V> Map<K, V> createFetcherCache() {
        return new ConcurrentHashMap();
    }

    protected Method getMethod(Class<?> clazz, String name) {
        if (this._allowAccessCoercion) {
            for (Class<?> cc = clazz; cc != null && cc != Object.class; cc = cc.getSuperclass()) {
                Method m = this.getMethodOn(cc, name);
                if (m == null) continue;
                return m;
            }
        } else {
            try {
                return clazz.getMethod(name, new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected Method getIfaceMethod(Class<?> clazz, String name) {
        LinkedHashSet ifaces = new LinkedHashSet();
        for (Class<?> cc = clazz; cc != null && cc != Object.class; cc = cc.getSuperclass()) {
            this.addIfaces(ifaces, cc, false);
        }
        for (Class clazz2 : ifaces) {
            Method m = this.getMethodOn(clazz2, name);
            if (m == null) continue;
            return m;
        }
        return null;
    }

    private void addIfaces(Set<Class<?>> ifaces, Class<?> clazz, boolean isIface) {
        if (isIface) {
            ifaces.add(clazz);
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            this.addIfaces(ifaces, iface, true);
        }
    }

    protected Method getMethodOn(Class<?> clazz, String name) {
        Method m;
        try {
            m = clazz.getDeclaredMethod(name, new Class[0]);
            if (!m.getReturnType().equals(Void.TYPE)) {
                return this.makeAccessible(m);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String upperName = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        try {
            m = clazz.getDeclaredMethod("get" + upperName, new Class[0]);
            if (!m.getReturnType().equals(Void.TYPE)) {
                return this.makeAccessible(m);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            m = clazz.getDeclaredMethod("is" + upperName, new Class[0]);
            if (m.getReturnType().equals(Boolean.TYPE) || m.getReturnType().equals(Boolean.class)) {
                return this.makeAccessible(m);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Method makeAccessible(Method m) {
        if (m.isAccessible()) {
            return m;
        }
        if (!this._allowAccessCoercion) {
            return null;
        }
        m.setAccessible(true);
        return m;
    }

    protected Field getField(Class<?> clazz, String name) {
        if (!this._allowAccessCoercion) {
            try {
                return clazz.getField(name);
            }
            catch (Exception e) {
                return null;
            }
        }
        try {
            Field f = clazz.getDeclaredField(name);
            if (!f.isAccessible()) {
                f.setAccessible(true);
            }
            return f;
        }
        catch (Exception exception) {
            Class<?> sclass = clazz.getSuperclass();
            if (sclass != Object.class && sclass != null) {
                return this.getField(clazz.getSuperclass(), name);
            }
            return null;
        }
    }
}

