/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.requests.FetchRequest;

public enum FetchIsolation {
    LOG_END,
    HIGH_WATERMARK,
    TXN_COMMITTED;


    public static FetchIsolation of(FetchRequest request) {
        return FetchIsolation.of(request.replicaId(), request.isolationLevel());
    }

    public static FetchIsolation of(int replicaId, IsolationLevel isolationLevel) {
        if (!FetchRequest.isConsumer((int)replicaId)) {
            return LOG_END;
        }
        if (isolationLevel == IsolationLevel.READ_COMMITTED) {
            return TXN_COMMITTED;
        }
        return HIGH_WATERMARK;
    }
}

