/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.syncope.client.console.rest.GroupRestClient;
import org.apache.syncope.client.console.wizards.any.AbstractAttrsWizardStep;
import org.apache.syncope.client.console.wizards.any.DerAttrs;
import org.apache.syncope.client.console.wizards.any.PlainAttrs;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.client.ui.commons.wizards.any.AnyWrapper;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AnyTypeClassTO;
import org.apache.syncope.common.lib.to.AttributableTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.to.TypeExtensionTO;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.core.util.lang.PropertyResolver;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public abstract class AbstractAttrs<S extends SchemaTO>
extends AbstractAttrsWizardStep<S> {
    private static final long serialVersionUID = -5387344116983102292L;
    @SpringBean
    protected GroupRestClient groupRestClient;
    protected final IModel<List<MembershipTO>> memberships;
    protected final Map<String, Map<String, S>> membershipSchemas = new LinkedHashMap<String, Map<String, S>>();

    public AbstractAttrs(AnyWrapper<?> modelObject, AjaxWizard.Mode mode, List<String> anyTypeClasses, List<String> whichAttrs) {
        super(modelObject.getInnerObject(), mode, anyTypeClasses, whichAttrs);
        this.memberships = new ListModel(List.of());
        this.setOutputMarkupId(true);
    }

    private List<MembershipTO> loadMemberships() {
        AttributableTO attributableTO = this.attributable;
        if (attributableTO instanceof AnyTO) {
            AnyTO anyTO = (AnyTO)attributableTO;
            this.membershipSchemas.clear();
            ArrayList<MembershipTO> membs = new ArrayList<MembershipTO>();
            try {
                ((Iterable)PropertyResolver.getPropertyField((String)"memberships", (Object)anyTO).get(anyTO)).forEach(memb -> {
                    this.setSchemas(memb.getGroupKey(), this.anyTypeClassRestClient.list(this.getMembershipAuxClasses((MembershipTO)memb, anyTO.getType())).stream().map(AnyTypeClassTO::getKey).collect(Collectors.toList()));
                    this.setAttrs((MembershipTO)memb);
                    if (this instanceof PlainAttrs && !memb.getPlainAttrs().isEmpty()) {
                        membs.add((MembershipTO)memb);
                    } else if (this instanceof DerAttrs && !memb.getDerAttrs().isEmpty()) {
                        membs.add((MembershipTO)memb);
                    }
                });
            }
            catch (IllegalAccessException | IllegalArgumentException | WicketRuntimeException throwable) {
                // empty catch block
            }
            return membs;
        }
        return List.of();
    }

    private void setSchemas(String membership, List<String> anyTypeClasses) {
        Map<Object, Object> mscs;
        if (this.membershipSchemas.containsKey(membership)) {
            mscs = this.membershipSchemas.get(membership);
        } else {
            mscs = new LinkedHashMap();
            this.membershipSchemas.put(membership, mscs);
        }
        this.setSchemas(anyTypeClasses, mscs);
    }

    protected List<String> getMembershipAuxClasses(MembershipTO membershipTO, String anyType) {
        try {
            GroupTO groupTO = (GroupTO)this.groupRestClient.read(membershipTO.getGroupKey());
            return groupTO.getTypeExtension(anyType).map(TypeExtensionTO::getAuxClasses).orElseGet(List::of);
        }
        catch (Exception e) {
            return List.of();
        }
    }

    protected abstract void setAttrs(MembershipTO var1);

    protected abstract List<Attr> getAttrsFromTO(MembershipTO var1);

    @Override
    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        if (CollectionUtils.isEmpty((Collection)((Collection)this.attrs.getObject())) && CollectionUtils.isEmpty((Collection)((Collection)this.memberships.getObject()))) {
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)String.format("$('#emptyPlaceholder').append(\"%s\"); $('#attributes').hide();", this.getString("attribute.empty.list"))));
        }
    }

    @Override
    public boolean evaluate() {
        this.attrs.setObject(this.loadAttrs());
        this.memberships.setObject(this.loadMemberships());
        return !((List)this.attrs.getObject()).isEmpty() || !((List)this.memberships.getObject()).isEmpty();
    }
}

