/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.policies;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.panels.AbstractModalPanel;
import org.apache.syncope.client.console.rest.PolicyRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxNumberFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.client.ui.commons.panels.WizardModalPanel;
import org.apache.syncope.client.ui.commons.wizards.AbstractModalPanelBuilder;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.lib.policy.PolicyTO;
import org.apache.syncope.common.lib.types.BackOffStrategy;
import org.apache.syncope.common.lib.types.ConflictResolutionAction;
import org.apache.syncope.common.lib.types.PolicyType;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.core.util.lang.PropertyResolver;
import org.apache.wicket.core.util.lang.PropertyResolverConverter;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;

public class PolicyModalPanelBuilder<T extends PolicyTO>
extends AbstractModalPanelBuilder<T> {
    private static final long serialVersionUID = 5945391813567245081L;
    protected final BaseModal<T> modal;
    protected final PolicyType type;
    protected final PolicyRestClient policyRestClient;

    public PolicyModalPanelBuilder(PolicyType type, T policyTO, BaseModal<T> modal, PolicyRestClient policyRestClient, PageReference pageRef) {
        super(policyTO, pageRef);
        this.type = type;
        this.modal = modal;
        this.policyRestClient = policyRestClient;
    }

    public WizardModalPanel<T> build(String id, int index, AjaxWizard.Mode mode) {
        return new Profile(this, (PolicyTO)this.newModelObject(), this.modal, this.pageRef);
    }

    private static class Profile
    extends AbstractModalPanel<T> {
        private static final long serialVersionUID = -3043839139187792810L;
        private final T policyTO;
        private final LoadableDetachableModel<List<String>> accessPolicyConfClasses;
        final /* synthetic */ PolicyModalPanelBuilder this$0;

        Profile(final T policyTO, BaseModal<T> modal, PageReference pageRef) {
            this.this$0 = var1_1;
            super(modal, pageRef);
            this.accessPolicyConfClasses = new LoadableDetachableModel<List<String>>(){
                private static final long serialVersionUID = 5275935387613157437L;

                protected List<String> load() {
                    return SyncopeWebApplication.get().getAccessPolicyConfProvider().get();
                }
            };
            modal.setFormModel(policyTO);
            this.policyTO = policyTO;
            ArrayList<Object> fields = new ArrayList<Object>();
            fields.add(new AjaxTextFieldPanel("field", "name", (IModel)new PropertyModel(policyTO, "name"), false).setRequired(true));
            switch (var1_1.type) {
                case ACCOUNT: {
                    fields.add(new AjaxNumberFieldPanel.Builder().min((Number)0).build("field", "maxAuthenticationAttempts", Integer.class, (IModel)new PropertyModel(policyTO, "maxAuthenticationAttempts")).setRequired(true));
                    fields.add(new AjaxCheckBoxPanel("field", "propagateSuspension", (IModel)new PropertyModel(policyTO, "propagateSuspension"), false));
                    break;
                }
                case PASSWORD: {
                    fields.add(new AjaxNumberFieldPanel.Builder().min((Number)0).build("field", "historyLength", Integer.class, (IModel)new PropertyModel(policyTO, "historyLength")).setRequired(true));
                    fields.add(new AjaxCheckBoxPanel("field", "allowNullPassword", (IModel)new PropertyModel(policyTO, "allowNullPassword"), false));
                    break;
                }
                case PROPAGATION: {
                    fields.add(new AjaxCheckBoxPanel("field", "fetchAroundProvisioning", (IModel)new PropertyModel(policyTO, "fetchAroundProvisioning"), false));
                    fields.add(new AjaxCheckBoxPanel("field", "updateDelta", (IModel)new PropertyModel(policyTO, "updateDelta"), false));
                    fields.add(new AjaxNumberFieldPanel.Builder().min((Number)1).build("field", "maxAttempts", Integer.class, (IModel)new PropertyModel(policyTO, "maxAttempts")).setRequired(true));
                    final AjaxDropDownChoicePanel backOffStrategy = new AjaxDropDownChoicePanel("field", "backOffStrategy", (IModel)new PropertyModel(policyTO, "backOffStrategy")).setChoices(List.of((Serializable[])BackOffStrategy.values()));
                    fields.add(backOffStrategy);
                    final PropertyModel backOffParamsModel = new PropertyModel(policyTO, "backOffParams");
                    final AjaxNumberFieldPanel initialInterval = new AjaxNumberFieldPanel.Builder().min((Number)1L).build("field", "initialInterval", Long.class, new BackOffParamsModel((PropertyModel<String>)backOffParamsModel, 0));
                    fields.add(initialInterval.setOutputMarkupPlaceholderTag(true));
                    final AjaxNumberFieldPanel maxInterval = new AjaxNumberFieldPanel.Builder().min((Number)1L).build("field", "maxInterval", Long.class, new BackOffParamsModel((PropertyModel<String>)backOffParamsModel, 1));
                    fields.add(maxInterval.setOutputMarkupPlaceholderTag(true).setVisible(false));
                    final AjaxNumberFieldPanel multiplier = new AjaxNumberFieldPanel.Builder().min((Number)1.0).build("field", "multiplier", Double.class, new BackOffParamsModel((PropertyModel<String>)backOffParamsModel, 2));
                    fields.add(multiplier.setOutputMarkupPlaceholderTag(true).setVisible(false));
                    this.showHide((AjaxDropDownChoicePanel<Serializable>)backOffStrategy, (AjaxNumberFieldPanel<Long>)initialInterval, (AjaxNumberFieldPanel<Long>)maxInterval, (AjaxNumberFieldPanel<Double>)multiplier);
                    backOffStrategy.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                        private static final long serialVersionUID = -1107858522700306810L;

                        protected void onUpdate(AjaxRequestTarget target) {
                            BackOffStrategy strategy = (BackOffStrategy)backOffStrategy.getField().getModelObject();
                            backOffParamsModel.setObject((Object)strategy.getDefaultBackOffParams());
                            Profile.this.showHide((AjaxDropDownChoicePanel<Serializable>)backOffStrategy, (AjaxNumberFieldPanel<Long>)initialInterval, (AjaxNumberFieldPanel<Long>)maxInterval, (AjaxNumberFieldPanel<Double>)multiplier);
                            target.add(new Component[]{initialInterval});
                            target.add(new Component[]{maxInterval});
                            target.add(new Component[]{multiplier});
                        }
                    }});
                    break;
                }
                case INBOUND: 
                case PUSH: {
                    fields.add(new AjaxDropDownChoicePanel("field", "conflictResolutionAction", (IModel)new PropertyModel(policyTO, "conflictResolutionAction")).setChoices(List.of((Serializable[])ConflictResolutionAction.values())));
                    break;
                }
                case ACCESS: {
                    fields.add(new AjaxDropDownChoicePanel("field", "conf", (IModel)new IModel<Serializable>(){
                        private static final long serialVersionUID = -6515946495655944432L;

                        public Serializable getObject() {
                            return Optional.ofNullable(PropertyResolver.getValue((String)"conf", (Object)policyTO)).map(obj -> obj.getClass().getName()).orElse(null);
                        }

                        public void setObject(Serializable object) {
                            Object conf = Optional.ofNullable(object).map(o -> {
                                try {
                                    return Class.forName(object.toString()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                                }
                                catch (Exception e) {
                                    LOG.error("Could not instantiate {}", (Object)object, (Object)e);
                                    return null;
                                }
                            }).orElse(null);
                            PropertyResolverConverter prc = new PropertyResolverConverter(Application.get().getConverterLocator(), SyncopeConsoleSession.get().getLocale());
                            PropertyResolver.setValue((String)"conf", (Object)policyTO, Optional.ofNullable(conf).orElse(null), (PropertyResolverConverter)prc);
                        }
                    }).setChoices(this.accessPolicyConfClasses).setRequired(true));
                    break;
                }
                case ATTR_RELEASE: {
                    fields.add(new AjaxNumberFieldPanel.Builder().build("field", "order", Integer.class, (IModel)new PropertyModel(policyTO, "order")));
                    fields.add(new AjaxCheckBoxPanel("field", "status", (IModel)new PropertyModel(policyTO, "status"), false));
                    break;
                }
            }
            this.add(new Component[]{new ListView<Component>("fields", fields){
                private static final long serialVersionUID = -9180479401817023838L;

                protected void populateItem(ListItem<Component> item) {
                    item.add(new Component[]{(Component)item.getModelObject()});
                }
            }});
        }

        private void showHide(AjaxDropDownChoicePanel<Serializable> backOffStrategy, AjaxNumberFieldPanel<Long> initialInterval, AjaxNumberFieldPanel<Long> maxInterval, AjaxNumberFieldPanel<Double> multiplier) {
            BackOffStrategy strategy = (BackOffStrategy)backOffStrategy.getField().getModelObject();
            switch (strategy) {
                case EXPONENTIAL: {
                    initialInterval.addLabel("initialInterval");
                    maxInterval.setVisible(true);
                    multiplier.setVisible(true);
                    break;
                }
                case RANDOM: {
                    initialInterval.addLabel("initialInterval");
                    maxInterval.setVisible(true);
                    multiplier.setVisible(true);
                    break;
                }
                default: {
                    initialInterval.addLabel("period");
                    maxInterval.setVisible(false);
                    multiplier.setVisible(false);
                }
            }
        }

        @Override
        public void onSubmit(AjaxRequestTarget target) {
            try {
                if (this.policyTO.getKey() == null) {
                    this.this$0.policyRestClient.create(this.this$0.type, this.policyTO);
                } else {
                    this.this$0.policyRestClient.update(this.this$0.type, this.policyTO);
                }
                SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                this.modal.close((IPartialPageRequestHandler)target);
            }
            catch (Exception e) {
                LOG.error("While creating/updating policy", (Throwable)e);
                SyncopeConsoleSession.get().onException(e);
            }
            ((BaseWebPage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
        }
    }

    protected static class BackOffParamsModel<N extends Number>
    implements IModel<N> {
        private static final long serialVersionUID = 28839546672164L;
        protected final PropertyModel<String> backOffParamsModel;
        protected final int index;

        BackOffParamsModel(PropertyModel<String> backOffParamsModel, int index) {
            this.backOffParamsModel = backOffParamsModel;
            this.index = index;
        }

        public N getObject() {
            String[] split = ((String)this.backOffParamsModel.getObject()).split(";");
            if (this.index >= split.length) {
                return null;
            }
            return (N)(this.index == 2 ? (Number)Double.valueOf(((String)this.backOffParamsModel.getObject()).split(";")[this.index]) : (Number)Long.valueOf(((String)this.backOffParamsModel.getObject()).split(";")[this.index]));
        }

        public void setObject(N object) {
            CharSequence[] split = ((String)this.backOffParamsModel.getObject()).split(";");
            if (this.index < split.length) {
                split[this.index] = object.toString();
                this.backOffParamsModel.setObject((Object)String.join((CharSequence)";", split));
            }
        }
    }
}

