/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken.response;

import com.nimbusds.jose.Header;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import java.text.ParseException;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceCipherExecutor;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.crypto.DecodableCipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OAuth20JwtAccessTokenDecodableCipher
implements DecodableCipher<String, String> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20JwtAccessTokenDecodableCipher.class);
    private final RegisteredService registeredService;
    private final JwtBuilder accessTokenJwtBuilder;

    protected RegisteredService resolveRegisteredService(Header header) {
        Object serviceId;
        OAuthRegisteredService oAuthRegisteredService = (OAuthRegisteredService)this.registeredService;
        if (oAuthRegisteredService == null && (serviceId = header.getCustomParam(RegisteredServiceCipherExecutor.CUSTOM_HEADER_REGISTERED_SERVICE_ID)) != null) {
            long serviceIdentifier = Long.parseLong(serviceId.toString());
            oAuthRegisteredService = (OAuthRegisteredService)this.accessTokenJwtBuilder.getServicesManager().findServiceBy(serviceIdentifier, OAuthRegisteredService.class);
        }
        return oAuthRegisteredService;
    }

    public String decode(String tokenId, Object[] parameters) {
        if (StringUtils.isBlank((CharSequence)tokenId)) {
            LOGGER.debug("No access token is provided to decode");
            return tokenId;
        }
        try {
            Header header = JWTParser.parse((String)tokenId).getHeader();
            JWTClaimsSet claims = this.accessTokenJwtBuilder.unpack(Optional.ofNullable(this.resolveRegisteredService(header)), tokenId);
            return claims.getJWTID();
        }
        catch (ParseException e) {
            LOGGER.trace("Token is not valid JWT, returning it as-is: [{}]", (Object)tokenId);
            return tokenId;
        }
    }

    @Generated
    public OAuth20JwtAccessTokenDecodableCipher(RegisteredService registeredService, JwtBuilder accessTokenJwtBuilder) {
        this.registeredService = registeredService;
        this.accessTokenJwtBuilder = accessTokenJwtBuilder;
    }
}

