/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.syncope.ext.openfga.client.ApiClient;
import org.apache.syncope.ext.openfga.client.model.RelationReference;
import org.apache.syncope.ext.openfga.client.model.SourceInfo;

@JsonPropertyOrder(value={"directly_related_user_types", "module", "source_info"})
public class RelationMetadata {
    public static final String JSON_PROPERTY_DIRECTLY_RELATED_USER_TYPES = "directly_related_user_types";
    @Nullable
    private List<RelationReference> directlyRelatedUserTypes = new ArrayList<RelationReference>();
    public static final String JSON_PROPERTY_MODULE = "module";
    @Nullable
    private String module;
    public static final String JSON_PROPERTY_SOURCE_INFO = "source_info";
    @Nullable
    private SourceInfo sourceInfo;

    public RelationMetadata directlyRelatedUserTypes(@Nullable List<RelationReference> directlyRelatedUserTypes) {
        this.directlyRelatedUserTypes = directlyRelatedUserTypes;
        return this;
    }

    public RelationMetadata addDirectlyRelatedUserTypesItem(RelationReference directlyRelatedUserTypesItem) {
        if (this.directlyRelatedUserTypes == null) {
            this.directlyRelatedUserTypes = new ArrayList<RelationReference>();
        }
        this.directlyRelatedUserTypes.add(directlyRelatedUserTypesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="directly_related_user_types", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<RelationReference> getDirectlyRelatedUserTypes() {
        return this.directlyRelatedUserTypes;
    }

    @JsonProperty(value="directly_related_user_types", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDirectlyRelatedUserTypes(@Nullable List<RelationReference> directlyRelatedUserTypes) {
        this.directlyRelatedUserTypes = directlyRelatedUserTypes;
    }

    public RelationMetadata module(@Nullable String module) {
        this.module = module;
        return this;
    }

    @Nullable
    @JsonProperty(value="module", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getModule() {
        return this.module;
    }

    @JsonProperty(value="module", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setModule(@Nullable String module) {
        this.module = module;
    }

    public RelationMetadata sourceInfo(@Nullable SourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
        return this;
    }

    @Nullable
    @JsonProperty(value="source_info", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    @JsonProperty(value="source_info", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceInfo(@Nullable SourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelationMetadata relationMetadata = (RelationMetadata)o;
        return Objects.equals(this.directlyRelatedUserTypes, relationMetadata.directlyRelatedUserTypes) && Objects.equals(this.module, relationMetadata.module) && Objects.equals(this.sourceInfo, relationMetadata.sourceInfo);
    }

    public int hashCode() {
        return Objects.hash(this.directlyRelatedUserTypes, this.module, this.sourceInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RelationMetadata {\n");
        sb.append("    directlyRelatedUserTypes: ").append(this.toIndentedString(this.directlyRelatedUserTypes)).append("\n");
        sb.append("    module: ").append(this.toIndentedString(this.module)).append("\n");
        sb.append("    sourceInfo: ").append(this.toIndentedString(this.sourceInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getDirectlyRelatedUserTypes() != null) {
            for (int i = 0; i < this.getDirectlyRelatedUserTypes().size(); ++i) {
                if (this.getDirectlyRelatedUserTypes().get(i) == null) continue;
                joiner.add(this.getDirectlyRelatedUserTypes().get(i).toUrlQueryString(String.format(Locale.ROOT, "%sdirectly_related_user_types%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format(Locale.ROOT, "%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getModule() != null) {
            joiner.add(String.format(Locale.ROOT, "%smodule%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getModule()))));
        }
        if (this.getSourceInfo() != null) {
            joiner.add(this.getSourceInfo().toUrlQueryString((String)prefix + JSON_PROPERTY_SOURCE_INFO + suffix));
        }
        return joiner.toString();
    }
}

