/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.ui.form.slider;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.wicketstuff.jquery.core.JQueryBehavior;
import org.wicketstuff.jquery.core.JQueryEvent;
import org.wicketstuff.jquery.core.ajax.IJQueryAjaxAware;
import org.wicketstuff.jquery.core.ajax.JQueryAjaxPostBehavior;
import org.wicketstuff.jquery.core.event.IValueChangedListener;
import org.wicketstuff.jquery.ui.ajax.OnChangeAjaxBehavior;
import org.wicketstuff.jquery.ui.form.slider.AjaxSliderBehavior;
import org.wicketstuff.jquery.ui.form.slider.RangeSlider;
import org.wicketstuff.jquery.ui.form.slider.RangeValue;

public class AjaxRangeSlider
extends RangeSlider
implements IJQueryAjaxAware,
IValueChangedListener {
    private static final long serialVersionUID = 1L;

    public AjaxRangeSlider(String id) {
        super(id);
    }

    public AjaxRangeSlider(String id, IModel<RangeValue> model) {
        super(id, model);
    }

    public AjaxRangeSlider(String id, IModel<RangeValue> model, Label label) {
        super(id, model, label);
    }

    public AjaxRangeSlider(String id, IModel<RangeValue> model, TextField<Integer> lower, TextField<Integer> upper) {
        super(id, model, lower, upper);
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof OnChangeAjaxBehavior.ChangeEvent) {
            this.lower.processInput();
            this.upper.processInput();
            this.validate();
            if (this.isValid() && this.lower.isValid() && this.upper.isValid()) {
                this.onValueChanged((IPartialPageRequestHandler)target);
            } else {
                this.onError(target);
            }
        }
    }

    public void onValueChanged(IPartialPageRequestHandler handler) {
    }

    protected void onError(AjaxRequestTarget target) {
    }

    @Override
    public JQueryBehavior newWidgetBehavior(String selector) {
        return new AjaxSliderBehavior(selector, this.options){
            private static final long serialVersionUID = 1L;

            @Override
            public void onConfigure(Component component) {
                super.onConfigure(component);
                AjaxRangeSlider.this.onConfigure(this);
            }

            public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
                AjaxRangeSlider.this.onAjax(target, event);
            }

            @Override
            protected JQueryAjaxPostBehavior newOnChangeAjaxBehavior(IJQueryAjaxAware source) {
                return new OnChangeAjaxBehavior(source, new FormComponent[]{AjaxRangeSlider.this.lower, AjaxRangeSlider.this.upper});
            }
        };
    }
}

