/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.BaseCasActuatorEndpoint;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.Access;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;

@Endpoint(id="authenticationPolicies", defaultAccess=Access.NONE)
public class RegisteredAuthenticationPoliciesEndpoint
extends BaseCasActuatorEndpoint {
    private final ObjectProvider<AuthenticationEventExecutionPlan> authenticationEventExecutionPlan;

    public RegisteredAuthenticationPoliciesEndpoint(CasConfigurationProperties casProperties, ObjectProvider<AuthenticationEventExecutionPlan> authenticationEventExecutionPlan) {
        super(casProperties);
        this.authenticationEventExecutionPlan = authenticationEventExecutionPlan;
    }

    @ReadOperation(produces={"application/json", "application/vnd.spring-boot.actuator.v2+json", "application/vnd.cas.services+yaml"})
    @Operation(summary="Get available authentication policies")
    public Collection<AuthenticationPolicyDetails> handle() {
        return ((AuthenticationEventExecutionPlan)this.authenticationEventExecutionPlan.getObject()).getAuthenticationPolicies().stream().map(policy -> ((AuthenticationPolicyDetails.AuthenticationPolicyDetailsBuilder)((AuthenticationPolicyDetails.AuthenticationPolicyDetailsBuilder)AuthenticationPolicyDetails.builder().name(policy.getName())).order(policy.getOrder())).build()).sorted(Comparator.comparing(AuthenticationPolicyDetails::getOrder)).collect(Collectors.toList());
    }

    @ReadOperation(produces={"application/json", "application/vnd.spring-boot.actuator.v2+json", "application/vnd.cas.services+yaml"})
    @Operation(summary="Get available authentication policy by name", parameters={@Parameter(name="name", required=true, description="The name of the policy to fetch")})
    public AuthenticationPolicyDetails fetchPolicy(@Selector String name) {
        return ((AuthenticationEventExecutionPlan)this.authenticationEventExecutionPlan.getObject()).getAuthenticationPolicies().stream().filter(authnHandler -> authnHandler.getName().equals(name)).findFirst().map(policy -> ((AuthenticationPolicyDetails.AuthenticationPolicyDetailsBuilder)((AuthenticationPolicyDetails.AuthenticationPolicyDetailsBuilder)AuthenticationPolicyDetails.builder().name(policy.getName())).order(policy.getOrder())).build()).orElse(null);
    }

    private static final class AuthenticationPolicyDetails
    implements Serializable {
        private static final long serialVersionUID = 6755362844006190415L;
        private final String name;
        private final Integer order;

        @Generated
        protected AuthenticationPolicyDetails(AuthenticationPolicyDetailsBuilder<?, ?> b) {
            this.name = b.name;
            this.order = b.order;
        }

        @Generated
        public static AuthenticationPolicyDetailsBuilder<?, ?> builder() {
            return new AuthenticationPolicyDetailsBuilderImpl();
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Integer getOrder() {
            return this.order;
        }

        @Generated
        public static abstract class AuthenticationPolicyDetailsBuilder<C extends AuthenticationPolicyDetails, B extends AuthenticationPolicyDetailsBuilder<C, B>> {
            @Generated
            private String name;
            @Generated
            private Integer order;

            @Generated
            public B name(String name) {
                this.name = name;
                return this.self();
            }

            @Generated
            public B order(Integer order) {
                this.order = order;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "RegisteredAuthenticationPoliciesEndpoint.AuthenticationPolicyDetails.AuthenticationPolicyDetailsBuilder(name=" + this.name + ", order=" + this.order + ")";
            }
        }

        @Generated
        private static final class AuthenticationPolicyDetailsBuilderImpl
        extends AuthenticationPolicyDetailsBuilder<AuthenticationPolicyDetails, AuthenticationPolicyDetailsBuilderImpl> {
            @Generated
            private AuthenticationPolicyDetailsBuilderImpl() {
            }

            @Override
            @Generated
            protected AuthenticationPolicyDetailsBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public AuthenticationPolicyDetails build() {
                return new AuthenticationPolicyDetails(this);
            }
        }
    }
}

