/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.lib;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.transport.common.gzip.GZIPInInterceptor;
import org.apache.cxf.transport.common.gzip.GZIPOutInterceptor;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.syncope.client.lib.AnonymousAuthenticationHandler;
import org.apache.syncope.client.lib.AuthenticationHandler;
import org.apache.syncope.client.lib.BasicAuthenticationHandler;
import org.apache.syncope.client.lib.JWTAuthenticationHandler;
import org.apache.syncope.client.lib.RestClientExceptionMapper;
import org.apache.syncope.client.lib.batch.BatchRequest;
import org.apache.syncope.common.lib.search.AnyObjectFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.search.ConnObjectTOFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.search.GroupFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.search.OrderByClauseBuilder;
import org.apache.syncope.common.lib.search.UserFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.rest.api.Preference;
import org.apache.syncope.common.rest.api.service.AccessTokenService;
import org.apache.syncope.common.rest.api.service.AnyService;
import org.apache.syncope.common.rest.api.service.ExecutableService;
import org.apache.syncope.common.rest.api.service.UserSelfService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncopeClient {
    protected static final Logger LOG = LoggerFactory.getLogger(SyncopeClient.class);
    protected static final String HEADER_SPLIT_PROPERTY = "org.apache.cxf.http.header.split";
    protected static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    protected final MediaType mediaType;
    protected final JAXRSClientFactoryBean restClientFactory;
    protected final RestClientExceptionMapper exceptionMapper;
    protected final boolean useCompression;
    protected final HTTPClientPolicy httpClientPolicy;
    protected final TLSClientParameters tlsClientParameters;

    public SyncopeClient(MediaType mediaType, JAXRSClientFactoryBean restClientFactory, RestClientExceptionMapper exceptionMapper, AuthenticationHandler authHandler, boolean useCompression, HTTPClientPolicy httpClientPolicy, TLSClientParameters tlsClientParameters) {
        this.mediaType = mediaType;
        this.restClientFactory = restClientFactory;
        if (this.restClientFactory.getHeaders() == null) {
            this.restClientFactory.setHeaders(new HashMap());
        }
        this.exceptionMapper = exceptionMapper;
        this.useCompression = useCompression;
        this.httpClientPolicy = httpClientPolicy;
        this.tlsClientParameters = tlsClientParameters;
        this.init(authHandler);
    }

    protected void init(AuthenticationHandler authHandler) {
        this.cleanup();
        if (authHandler instanceof AnonymousAuthenticationHandler) {
            AnonymousAuthenticationHandler anonymousAuthenticationHandler = (AnonymousAuthenticationHandler)authHandler;
            this.restClientFactory.setUsername(anonymousAuthenticationHandler.getUsername());
            this.restClientFactory.setPassword(anonymousAuthenticationHandler.getPassword());
        } else if (authHandler instanceof BasicAuthenticationHandler) {
            BasicAuthenticationHandler basicAuthenticationHandler = (BasicAuthenticationHandler)authHandler;
            this.restClientFactory.setUsername(basicAuthenticationHandler.getUsername());
            this.restClientFactory.setPassword(basicAuthenticationHandler.getPassword());
            String jwt = this.getService(AccessTokenService.class).login().getHeaderString("X-Syncope-Token");
            this.restClientFactory.getHeaders().put("Authorization", List.of("Bearer " + jwt));
            this.restClientFactory.setUsername(null);
            this.restClientFactory.setPassword(null);
        } else if (authHandler instanceof JWTAuthenticationHandler) {
            JWTAuthenticationHandler jwtAuthenticationHandler = (JWTAuthenticationHandler)authHandler;
            this.restClientFactory.getHeaders().put("Authorization", List.of("Bearer " + jwtAuthenticationHandler.getJwt()));
        }
    }

    protected void cleanup() {
        this.restClientFactory.getHeaders().remove("Authorization");
        this.restClientFactory.getHeaders().remove("X-Syncope-Delegated-By");
        this.restClientFactory.setUsername(null);
        this.restClientFactory.setPassword(null);
    }

    public String getAddress() {
        return this.restClientFactory.getAddress();
    }

    public SyncopeClient delegatedBy(String delegating) {
        if (delegating == null) {
            this.restClientFactory.getHeaders().remove("X-Syncope-Delegated-By");
        } else {
            this.restClientFactory.getHeaders().put("X-Syncope-Delegated-By", List.of(delegating));
        }
        return this;
    }

    public void refresh() {
        String jwt = this.getService(AccessTokenService.class).refresh().getHeaderString("X-Syncope-Token");
        this.restClientFactory.getHeaders().put("Authorization", List.of("Bearer " + jwt));
    }

    public void logout() {
        try {
            this.getService(AccessTokenService.class).logout();
        }
        catch (Exception e) {
            LOG.error("While logging out, cleaning up anyway", (Throwable)e);
        }
        this.cleanup();
    }

    public void login(AuthenticationHandler handler) {
        this.init(handler);
    }

    public static UserFiqlSearchConditionBuilder getUserSearchConditionBuilder() {
        return new UserFiqlSearchConditionBuilder();
    }

    public static GroupFiqlSearchConditionBuilder getGroupSearchConditionBuilder() {
        return new GroupFiqlSearchConditionBuilder();
    }

    public static AnyObjectFiqlSearchConditionBuilder getAnyObjectSearchConditionBuilder(String type) {
        return new AnyObjectFiqlSearchConditionBuilder(type);
    }

    public static ConnObjectTOFiqlSearchConditionBuilder getConnObjectTOFiqlSearchConditionBuilder() {
        return new ConnObjectTOFiqlSearchConditionBuilder();
    }

    public static OrderByClauseBuilder getOrderByClauseBuilder() {
        return new OrderByClauseBuilder();
    }

    public String getJWT() {
        String header;
        List headerValues = (List)this.restClientFactory.getHeaders().get("Authorization");
        String string = header = headerValues == null || headerValues.isEmpty() ? null : (String)headerValues.getFirst();
        if (header != null && header.startsWith("Bearer ")) {
            return header.substring("Bearer ".length());
        }
        return null;
    }

    public String getDomain() {
        List headerValues = (List)this.restClientFactory.getHeaders().get("X-Syncope-Domain");
        return headerValues == null || headerValues.isEmpty() ? "Master" : (String)headerValues.getFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getService(Class<T> serviceClass) {
        Object serviceInstance;
        JAXRSClientFactoryBean jAXRSClientFactoryBean = this.restClientFactory;
        synchronized (jAXRSClientFactoryBean) {
            this.restClientFactory.setServiceClass(serviceClass);
            serviceInstance = this.restClientFactory.create(serviceClass, new Object[0]);
        }
        Client client = WebClient.client((Object)serviceInstance);
        client.type(this.mediaType).accept(new MediaType[]{this.mediaType});
        if (serviceInstance instanceof AnyService || serviceInstance instanceof ExecutableService) {
            client.accept(new String[]{"multipart/mixed"});
        }
        ClientConfiguration config = WebClient.getConfig((Object)client);
        config.getRequestContext().put(HEADER_SPLIT_PROPERTY, true);
        config.getRequestContext().put("use.async.http.conduit", Boolean.TRUE);
        if (this.useCompression) {
            config.getInInterceptors().add(new GZIPInInterceptor());
            config.getOutInterceptors().add(new GZIPOutInterceptor());
        }
        HTTPConduit httpConduit = (HTTPConduit)config.getConduit();
        Optional.ofNullable(this.httpClientPolicy).ifPresent(arg_0 -> ((HTTPConduit)httpConduit).setClient(arg_0));
        Optional.ofNullable(this.tlsClientParameters).ifPresent(arg_0 -> ((HTTPConduit)httpConduit).setTlsClientParameters(arg_0));
        return (T)serviceInstance;
    }

    public Triple<Map<String, Set<String>>, List<String>, UserTO> self() {
        Exception ex;
        UserSelfService service = this.getService(UserSelfService.class);
        WebClient.getConfig((Object)WebClient.client((Object)service)).getRequestContext().put(HEADER_SPLIT_PROPERTY, false);
        Response response = service.read();
        if (response.getStatusInfo().getStatusCode() != Response.Status.OK.getStatusCode() && (ex = this.exceptionMapper.fromResponse(response)) != null) {
            throw (RuntimeException)ex;
        }
        try {
            return Triple.of((Object)((Map)MAPPER.readValue(response.getHeaderString("X-Syncope-Entitlements"), (TypeReference)new TypeReference<Map<String, Set<String>>>(this){})), (Object)((List)MAPPER.readValue(response.getHeaderString("X-Syncope-Delegations"), (TypeReference)new TypeReference<List<String>>(this){})), (Object)((UserTO)response.readEntity(UserTO.class)));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T header(T service, String key, Object ... values) {
        WebClient.client(service).header(key, values);
        return service;
    }

    public static <T> T prefer(T service, Preference preference) {
        return SyncopeClient.header(service, "Prefer", preference.toString());
    }

    public static <T> T nullPriorityAsync(T service, boolean nullPriorityAsync) {
        return SyncopeClient.header(service, "X-Syncope-Null-Priority-Async", nullPriorityAsync);
    }

    protected static <T> T match(T service, EntityTag etag, boolean ifNot) {
        WebClient.client(service).match(etag, ifNot);
        return service;
    }

    public static <T> T ifMatch(T service, EntityTag etag) {
        return SyncopeClient.match(service, etag, false);
    }

    public static <T> T ifNoneMatch(T service, EntityTag etag) {
        return SyncopeClient.match(service, etag, true);
    }

    public static <T> EntityTag getLatestEntityTag(T service) {
        return WebClient.client(service).getResponse().getEntityTag();
    }

    public BatchRequest batch() {
        return new BatchRequest(this.mediaType, this.restClientFactory.getAddress(), this.restClientFactory.getProviders(), this.getJWT(), this.tlsClientParameters);
    }
}

