/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.csvdir.methods;

import java.sql.SQLException;
import java.util.Set;
import net.tirasa.connid.bundles.csvdir.CSVDirConfiguration;
import net.tirasa.connid.bundles.csvdir.CSVDirConnection;
import net.tirasa.connid.bundles.csvdir.methods.CommonOperation;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.Uid;

public class CSVDirUpdate
extends CommonOperation {
    private static final Log LOG = Log.getLog(CSVDirUpdate.class);
    private final CSVDirConnection conn;
    private final CSVDirConfiguration conf;
    private final Uid uid;
    private Set<Attribute> attrs = null;

    public CSVDirUpdate(CSVDirConfiguration conf, Uid uid, Set<Attribute> set) throws ClassNotFoundException, SQLException {
        this.conf = conf;
        this.uid = uid;
        this.attrs = set;
        this.conn = CSVDirConnection.open(conf);
    }

    public Uid execute(ObjectClass oc) {
        try {
            Uid uid = this.executeImpl(oc);
            return uid;
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "error during updating", new Object[0]);
            throw new ConnectorException((Throwable)e);
        }
        finally {
            try {
                this.conn.close();
            }
            catch (SQLException e) {
                LOG.error((Throwable)e, "Error closing connections", new Object[0]);
            }
        }
    }

    private Uid executeImpl(ObjectClass oc) throws SQLException {
        if (this.uid == null || StringUtil.isBlank((String)this.uid.getUidValue())) {
            throw new IllegalArgumentException("No Name attribute provided in the attributes");
        }
        if (!CSVDirUpdate.userExists(oc, this.uid.getUidValue(), this.conn, this.conf).booleanValue()) {
            throw new ConnectorException("User doesn't exist");
        }
        this.conn.updateAccount(oc, this.getAttributeMap(this.conf, this.attrs, new Name(this.uid.getUidValue())), this.uid);
        LOG.ok("Update commited", new Object[0]);
        return this.uid;
    }
}

