/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.kendo.ui.datatable.button;

import org.apache.wicket.model.IModel;
import org.apache.wicket.protocol.http.WebSession;
import org.wicketstuff.jquery.core.IJQuerySecurityProvider;
import org.wicketstuff.kendo.ui.KendoIcon;
import org.wicketstuff.kendo.ui.datatable.button.CommandButton;

public class SecuredCommandButton
extends CommandButton {
    private static final long serialVersionUID = 1L;
    private final IJQuerySecurityProvider provider;
    private final String[] roles;

    public SecuredCommandButton(String name, String[] roles) {
        this(name, roles, (IJQuerySecurityProvider)WebSession.get());
    }

    public SecuredCommandButton(String name, String[] roles, IJQuerySecurityProvider provider) {
        super(name);
        this.roles = roles;
        this.provider = provider;
    }

    public SecuredCommandButton(String name, String property, String[] roles) {
        this(name, property, roles, (IJQuerySecurityProvider)WebSession.get());
    }

    public SecuredCommandButton(String name, String property, String[] roles, IJQuerySecurityProvider provider) {
        super(name, property);
        this.roles = roles;
        this.provider = provider;
    }

    public SecuredCommandButton(String name, IModel<String> text, String[] roles) {
        this(name, text, roles, (IJQuerySecurityProvider)WebSession.get());
    }

    public SecuredCommandButton(String name, IModel<String> text, String[] roles, IJQuerySecurityProvider provider) {
        super(name, text);
        this.roles = roles;
        this.provider = provider;
    }

    public SecuredCommandButton(String name, IModel<String> text, String property, String[] roles) {
        this(name, text, property, roles, (IJQuerySecurityProvider)WebSession.get());
    }

    public SecuredCommandButton(String name, IModel<String> text, String property, String[] roles, IJQuerySecurityProvider provider) {
        super(name, text, property);
        this.roles = roles;
        this.provider = provider;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public final boolean isLocked() {
        return !this.provider.hasRole(this.getRoles());
    }

    @Override
    public boolean isEnabled() {
        return !this.isLocked();
    }

    @Override
    public String getIconClass() {
        return this.isLocked() ? KendoIcon.getCssClass("lock") : super.getIconClass();
    }
}

