/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.agenda;

import java.util.Collection;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.HasExecutionListeners;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.util.CollectionUtil;
import org.flowable.engine.delegate.BpmnError;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.agenda.AbstractOperation;
import org.flowable.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.flowable.engine.impl.bpmn.helper.ErrorPropagation;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.delegate.ActivityBehavior;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.JobUtil;
import org.flowable.engine.logging.LogMDC;
import org.flowable.job.service.JobService;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinueMultiInstanceOperation
extends AbstractOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContinueMultiInstanceOperation.class);
    protected ExecutionEntity multiInstanceRootExecution;
    protected int loopCounter;

    public ContinueMultiInstanceOperation(CommandContext commandContext, ExecutionEntity execution, ExecutionEntity multiInstanceRootExecution, int loopCounter) {
        super(commandContext, execution);
        this.multiInstanceRootExecution = multiInstanceRootExecution;
        this.loopCounter = loopCounter;
    }

    @Override
    public void run() {
        FlowElement currentFlowElement = this.getCurrentFlowElement(this.execution);
        if (!(currentFlowElement instanceof FlowNode)) {
            throw new RuntimeException("Programmatic error: no valid multi instance flow node, type: " + String.valueOf(currentFlowElement) + ". Halting.");
        }
        this.continueThroughMultiInstanceFlowNode((FlowNode)currentFlowElement);
    }

    protected void continueThroughMultiInstanceFlowNode(FlowNode flowNode) {
        this.setLoopCounterVariable(flowNode);
        if (!flowNode.isAsynchronous()) {
            this.executeSynchronous(flowNode);
        } else {
            this.executeAsynchronous(flowNode);
        }
    }

    protected void executeSynchronous(FlowNode flowNode) {
        CommandContextUtil.getActivityInstanceEntityManager(this.commandContext).recordActivityStart(this.execution);
        if (CollectionUtil.isNotEmpty((Collection)flowNode.getExecutionListeners())) {
            try {
                this.executeExecutionListeners((HasExecutionListeners)flowNode, "start");
            }
            catch (BpmnError e) {
                ErrorPropagation.propagateError(e, (DelegateExecution)this.execution);
                return;
            }
        }
        ActivityBehavior activityBehavior = (ActivityBehavior)flowNode.getBehavior();
        LOGGER.debug("Executing activityBehavior {} on activity '{}' with execution {}", new Object[]{activityBehavior.getClass(), flowNode.getId(), this.execution.getId()});
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(this.commandContext);
        FlowableEventDispatcher eventDispatcher = null;
        if (processEngineConfiguration != null) {
            eventDispatcher = processEngineConfiguration.getEventDispatcher();
        }
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            processEngineConfiguration.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createActivityEvent(FlowableEngineEventType.ACTIVITY_STARTED, flowNode.getId(), flowNode.getName(), this.execution.getId(), this.execution.getProcessInstanceId(), this.execution.getProcessDefinitionId(), (FlowElement)flowNode), processEngineConfiguration.getEngineCfgKey());
        }
        try {
            activityBehavior.execute(this.execution);
        }
        catch (BpmnError error) {
            ErrorPropagation.propagateError(error, (DelegateExecution)this.execution);
        }
        catch (RuntimeException e) {
            if (LogMDC.isMDCEnabled()) {
                LogMDC.putMDCExecution(this.execution);
            }
            throw e;
        }
    }

    protected void executeAsynchronous(FlowNode flowNode) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(this.commandContext);
        JobService jobService = processEngineConfiguration.getJobServiceConfiguration().getJobService();
        JobEntity job = JobUtil.createJob(this.execution, (BaseElement)flowNode, "async-continuation", processEngineConfiguration);
        jobService.createAsyncJob(job, flowNode.isExclusive());
        jobService.scheduleAsyncJob(job);
    }

    protected ActivityBehavior setLoopCounterVariable(FlowNode flowNode) {
        ActivityBehavior activityBehavior = (ActivityBehavior)flowNode.getBehavior();
        if (!(activityBehavior instanceof MultiInstanceActivityBehavior)) {
            throw new FlowableException("Programmatic error: expected multi instance activity behavior, but got " + String.valueOf(activityBehavior.getClass()));
        }
        MultiInstanceActivityBehavior multiInstanceActivityBehavior = (MultiInstanceActivityBehavior)activityBehavior;
        String elementIndexVariable = multiInstanceActivityBehavior.getCollectionElementIndexVariable();
        this.execution.setVariableLocal(elementIndexVariable, this.loopCounter);
        return activityBehavior;
    }
}

