/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.templates;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.ldaptive.FilterTemplate;
import org.ldaptive.LdapEntry;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchResponse;
import org.ldaptive.concurrent.SearchOperationWorker;
import org.ldaptive.templates.Query;
import org.ldaptive.templates.SearchTemplates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchTemplatesOperation {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SearchOperationWorker searchOperationWorker;
    private SearchTemplates[] searchTemplates;

    public SearchTemplatesOperation() {
    }

    public SearchTemplatesOperation(SearchOperationWorker worker, SearchTemplates ... templates) {
        this.searchOperationWorker = worker;
        this.searchTemplates = templates;
    }

    public SearchOperationWorker getSearchOperationWorker() {
        return this.searchOperationWorker;
    }

    public void setSearchOperationWorker(SearchOperationWorker worker) {
        this.searchOperationWorker = worker;
    }

    public SearchTemplates[] getSearchTemplates() {
        return this.searchTemplates;
    }

    public void setSearchTemplates(SearchTemplates[] templates) {
        this.searchTemplates = templates;
    }

    public SearchResponse execute(Query query) {
        this.logger.debug("Query: {}", (Object)query);
        SearchTemplates templates = null;
        if (query.getTerms().length > 0) {
            this.logger.debug("Processing query: {}", (Object)Arrays.toString(query.getTerms()));
            int termCount = query.getTerms().length;
            if (termCount > this.searchTemplates.length) {
                termCount = this.searchTemplates.length;
            }
            if (termCount > 0) {
                templates = this.searchTemplates[termCount - 1];
                if (templates != null) {
                    this.logger.debug("Found execute templates {} for term count of {}", (Object)templates, (Object)termCount);
                } else {
                    this.logger.debug("No execute module found for term count of {}", (Object)termCount);
                }
            } else {
                this.logger.debug("No terms found in query {}", (Object)query);
            }
        }
        if (templates != null) {
            return this.execute(templates.format(query), query.getReturnAttributes(), query.getFromResult(), query.getToResult());
        }
        return null;
    }

    protected SearchResponse execute(FilterTemplate[] templates, String[] returnAttrs, Integer fromResult, Integer toResult) {
        this.logger.debug("Performing search with {} templates", (Object)Arrays.toString(templates));
        Collection<SearchResponse> responses = this.searchOperationWorker.execute(templates, returnAttrs);
        SearchResponse result = new SearchResponse();
        for (SearchResponse res : responses) {
            for (LdapEntry entry : res.getEntries()) {
                if (result.getEntries().stream().noneMatch(e -> entry.getParsedDn().equals(e.getParsedDn()))) {
                    result.addEntries(entry);
                    this.logger.debug("Search found: {}", (Object)entry.getDn());
                    continue;
                }
                this.logger.debug("Search found duplicate: {}", (Object)entry.getDn());
            }
        }
        SearchResponse subResult = fromResult != null ? result.subResult(fromResult, Objects.requireNonNullElseGet(toResult, result::entrySize)) : (toResult != null ? result.subResult(0, toResult) : result);
        return subResult;
    }

    public void close() {
        if (this.searchOperationWorker != null) {
            ((SearchOperation)this.searchOperationWorker.getOperation()).getConnectionFactory().close();
        }
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::searchOperationWorker=" + this.searchOperationWorker + ", searchTemplates=" + Arrays.toString(this.searchTemplates) + "]";
    }
}

