/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.persondir.cache;

import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.ArrayUtils;
import org.apereo.cas.authentication.attribute.AbstractDefaultAttributePersonAttributeDao;
import org.apereo.cas.authentication.attribute.SimplePersonAttributes;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDao;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDaoFilter;
import org.apereo.cas.authentication.principal.attribute.PersonAttributes;
import org.apereo.cas.authentication.principal.attribute.UsernameAttributeProvider;
import org.apereo.cas.persondir.cache.AttributeBasedCacheKeyGenerator;
import org.apereo.cas.persondir.cache.CacheKeyGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class CachingPersonAttributeDaoImpl
extends AbstractDefaultAttributePersonAttributeDao
implements InitializingBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CachingPersonAttributeDaoImpl.class);
    protected static final Set<PersonAttributes> NULL_RESULTS_OBJECT = new HashSet<PersonAttributes>();
    private PersonAttributeDao cachedPersonAttributesDao;
    private CacheKeyGenerator cacheKeyGenerator;
    private Map<Serializable, Set<PersonAttributes>> userInfoCache;
    private boolean cacheNullResults;
    private Set<PersonAttributes> nullResultsObject = NULL_RESULTS_OBJECT;
    private long queries;
    private long misses;

    public void afterPropertiesSet() {
        if (this.cacheKeyGenerator == null) {
            this.cacheKeyGenerator = new AttributeBasedCacheKeyGenerator();
            UsernameAttributeProvider usernameAttributeProvider = this.getUsernameAttributeProvider();
            String usernameAttribute = usernameAttributeProvider.getUsernameAttribute();
            this.cacheKeyGenerator.setDefaultAttributeName(usernameAttribute);
        }
    }

    public Set<PersonAttributes> getPeopleWithMultivaluedAttributes(Map<String, List<Object>> seed, PersonAttributeDaoFilter filter, Set<PersonAttributes> resultPeople) {
        Set<PersonAttributes> cacheResults;
        PersonAttributeDaoMethodInvocation methodInvocation = new PersonAttributeDaoMethodInvocation(seed);
        Serializable cacheKey = this.cacheKeyGenerator.generateKey(methodInvocation);
        if (cacheKey != null && (cacheResults = this.userInfoCache.get(cacheKey)) != null) {
            if (this.nullResultsObject.equals(cacheResults)) {
                cacheResults = null;
            }
            LOGGER.debug("Retrieved query from cache for key=[{}], results=[{}]", (Object)cacheKey, cacheResults);
            ++this.queries;
            return cacheResults;
        }
        Set queryResults = this.cachedPersonAttributesDao.getPeopleWithMultivaluedAttributes(seed, filter, resultPeople);
        if (cacheKey != null) {
            if (queryResults != null) {
                this.userInfoCache.put(cacheKey, queryResults);
            } else if (this.cacheNullResults) {
                this.userInfoCache.put(cacheKey, this.nullResultsObject);
            }
            ++this.queries;
            ++this.misses;
        }
        return queryResults;
    }

    public void removeUserAttributes(String uid) {
        Map seed = this.toSeedMap(uid);
        this.removeUserAttributesMultivaluedSeed(seed);
    }

    public void removeUserAttributesMultivaluedSeed(Map<String, List<Object>> seed) {
        PersonAttributeDaoMethodInvocation methodInvocation = new PersonAttributeDaoMethodInvocation(seed);
        Serializable cacheKey = this.cacheKeyGenerator.generateKey(methodInvocation);
        this.userInfoCache.remove(cacheKey);
    }

    public String[] getId() {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(((Object)((Object)this)).getClass().getSimpleName());
        ids.addAll(Arrays.asList(this.cachedPersonAttributesDao.getId()));
        return ids.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public Set<String> getPossibleUserAttributeNames(PersonAttributeDaoFilter filter) {
        return this.cachedPersonAttributesDao.getPossibleUserAttributeNames(filter);
    }

    public Set<String> getAvailableQueryAttributes(PersonAttributeDaoFilter filter) {
        return this.cachedPersonAttributesDao.getAvailableQueryAttributes(filter);
    }

    @Generated
    public PersonAttributeDao getCachedPersonAttributesDao() {
        return this.cachedPersonAttributesDao;
    }

    @Generated
    public void setCachedPersonAttributesDao(PersonAttributeDao cachedPersonAttributesDao) {
        this.cachedPersonAttributesDao = cachedPersonAttributesDao;
    }

    @Generated
    public CacheKeyGenerator getCacheKeyGenerator() {
        return this.cacheKeyGenerator;
    }

    @Generated
    public void setCacheKeyGenerator(CacheKeyGenerator cacheKeyGenerator) {
        this.cacheKeyGenerator = cacheKeyGenerator;
    }

    @Generated
    public Map<Serializable, Set<PersonAttributes>> getUserInfoCache() {
        return this.userInfoCache;
    }

    @Generated
    public void setUserInfoCache(Map<Serializable, Set<PersonAttributes>> userInfoCache) {
        this.userInfoCache = userInfoCache;
    }

    @Generated
    public boolean isCacheNullResults() {
        return this.cacheNullResults;
    }

    @Generated
    public void setCacheNullResults(boolean cacheNullResults) {
        this.cacheNullResults = cacheNullResults;
    }

    @Generated
    public Set<PersonAttributes> getNullResultsObject() {
        return this.nullResultsObject;
    }

    @Generated
    public void setNullResultsObject(Set<PersonAttributes> nullResultsObject) {
        this.nullResultsObject = nullResultsObject;
    }

    @Generated
    public long getQueries() {
        return this.queries;
    }

    @Generated
    public long getMisses() {
        return this.misses;
    }

    static {
        NULL_RESULTS_OBJECT.add((PersonAttributes)new SimplePersonAttributes(UUID.randomUUID().toString()));
    }

    private static class PersonAttributeDaoMethodInvocation
    implements MethodInvocation {
        private static final Method METHOD;
        private final Object[] arguments;

        PersonAttributeDaoMethodInvocation(Object ... args) {
            this.arguments = args;
        }

        @Nonnull
        public AccessibleObject getStaticPart() {
            throw new UnsupportedOperationException("getStaticPart() is not supported.");
        }

        public Object getThis() {
            throw new UnsupportedOperationException("getThis() is not supported.");
        }

        public Object proceed() {
            throw new UnsupportedOperationException("proceed() is not supported.");
        }

        @Nonnull
        public Method getMethod() {
            return METHOD;
        }

        @Generated
        public Object[] getArguments() {
            return this.arguments;
        }

        static {
            try {
                METHOD = PersonAttributeDao.class.getMethod("getPeopleWithMultivaluedAttributes", Map.class);
            }
            catch (SecurityException e) {
                NoSuchMethodError nsme = new NoSuchMethodError("The 'getPeopleWithMultivaluedAttributes(" + String.valueOf(Map.class) + ")' method on the '" + String.valueOf(PersonAttributeDao.class) + "' is not accessible due to a security policy.");
                nsme.initCause(e);
                throw nsme;
            }
            catch (NoSuchMethodException e) {
                NoSuchMethodError nsme = new NoSuchMethodError("The 'getPeopleWithMultivaluedAttributes(" + String.valueOf(Map.class) + ")' method on the '" + String.valueOf(PersonAttributeDao.class) + "' does not exist.");
                nsme.initCause(e);
                throw nsme;
            }
        }
    }
}

