/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.core.panel;

import org.apache.wicket.Component;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.wicketstuff.jquery.core.IJQueryWidget;

public abstract class FormSubmittingPanel<T>
extends GenericPanel<T>
implements IFormSubmittingComponent {
    private static final long serialVersionUID = 1L;
    private boolean processForm = true;

    public FormSubmittingPanel(String id) {
        super(id);
    }

    public FormSubmittingPanel(String id, IModel<T> model) {
        super(id, model);
    }

    protected void submit(IPartialPageRequestHandler handler) {
        String input = String.format("<input type=\"hidden\" name=\"%s\" value=\"\" />", this.getInputName());
        handler.appendJavaScript((CharSequence)String.format("jQuery('%s').append('%s').submit();", IJQueryWidget.JQueryWidget.getSelector(this.getForm()), input));
    }

    public Form<?> getForm() {
        return Form.findForm((Component)this);
    }

    public String getInputName() {
        return Form.getRootFormRelativeId((Component)this);
    }

    public final boolean getDefaultFormProcessing() {
        return this.processForm;
    }

    public final FormSubmittingPanel<T> setDefaultFormProcessing(boolean processForm) {
        this.processForm = processForm;
        return this;
    }

    public void onAfterSubmit() {
    }
}

