/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.convert.service;

import java.util.Collections;
import java.util.Set;
import org.springframework.binding.convert.converters.Converter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.util.Assert;

public class SpringBindingConverterAdapter
implements GenericConverter {
    private Converter converter;

    public SpringBindingConverterAdapter(Converter converter) {
        Assert.notNull((Object)converter, (String)"A Spring Binding converter is required.");
        this.converter = converter;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        try {
            return this.converter.convertSourceToTargetClass(source, targetType.getObjectType());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(this.converter.getSourceClass(), this.converter.getTargetClass()));
    }
}

