/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareMode$Disabled$;
import kafka.admin.RackAwareMode$Enforced$;
import kafka.admin.RackAwareMode$Safe$;
import kafka.cluster.Broker;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicConfig$Client$;
import kafka.server.DynamicConfig$Ip$;
import kafka.server.DynamicConfig$User$;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.zk.ConfigEntityZNode$;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicZNode$;
import org.apache.kafka.admin.AdminUtils;
import org.apache.kafka.admin.BrokerMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.BrokerNotAvailableException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.server.common.AdminOperationException;
import org.apache.kafka.server.config.ConfigType;
import org.apache.kafka.server.log.remote.storage.RemoteLogManagerConfig;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.zookeeper.KeeperException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t%g\u0001\u0002\u001a4\u0001aB\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0017\")A\u000b\u0001C\u0001+\")\u0011\f\u0001C\u00015\"I\u00111\u0003\u0001\u0012\u0002\u0013\u0005\u0011Q\u0003\u0005\n\u0003W\u0001\u0011\u0013!C\u0001\u0003[A\u0011\"!\r\u0001#\u0003%\t!a\r\t\u000f\u0005]\u0002\u0001\"\u0001\u0002:!I\u0011Q\r\u0001\u0012\u0002\u0013\u0005\u0011Q\u0006\u0005\n\u0003O\u0002\u0011\u0013!C\u0001\u0003SBq!!\u001c\u0001\t\u0003\ty\u0007C\u0005\u0002\b\u0002\t\n\u0011\"\u0001\u00024!I\u0011\u0011\u0012\u0001\u0012\u0002\u0013\u0005\u00111\u0007\u0005\b\u0003\u0017\u0003A\u0011AAG\u0011\u001d\t)\n\u0001C\u0005\u0003/C\u0011\"a-\u0001#\u0003%I!a\r\t\u000f\u0005U\u0006\u0001\"\u0001\u00028\"9\u00111\u0018\u0001\u0005\u0002\u0005u\u0006\"CAk\u0001E\u0005I\u0011AAl\u0011%\tY\u000eAI\u0001\n\u0003\ti\u000eC\u0005\u0002b\u0002\t\n\u0011\"\u0001\u00024!9\u00111\u001d\u0001\u0005\u0002\u0005\u0015\b\"CAy\u0001E\u0005I\u0011AAl\u0011%\t\u0019\u0010AI\u0001\n\u0003\ti\u000eC\u0004\u0002v\u0002!\t!a>\t\u000f\t\u0005\u0001\u0001\"\u0003\u0003\u0004!9!Q\u0003\u0001\u0005\u0002\t]\u0001b\u0002B\u0010\u0001\u0011\u0005!\u0011\u0005\u0005\n\u0005g\u0001\u0011\u0013!C\u0001\u0003gAqA!\u000e\u0001\t\u0013\u00119\u0004C\u0004\u0003@\u0001!\tA!\u0011\t\u000f\t%\u0003\u0001\"\u0001\u0003L!I!Q\u000b\u0001\u0012\u0002\u0013\u0005\u00111\u0007\u0005\b\u0005/\u0002A\u0011\u0002B-\u0011\u001d\u0011\t\u0007\u0001C\u0001\u0005GBqA!\u001b\u0001\t\u0003\u0011Y\u0007C\u0004\u0003r\u0001!\tAa\u001d\t\u000f\te\u0004\u0001\"\u0001\u0003|!9!\u0011\u0010\u0001\u0005\u0002\t\r\u0005b\u0002BE\u0001\u0011%!1\u0012\u0005\b\u0005\u001f\u0003A\u0011\u0002BI\u0011%\u0011y\nAI\u0001\n\u0013\t\u0019\u0004C\u0004\u0003\"\u0002!\tAa)\t\u000f\t%\u0006\u0001\"\u0001\u0003,\"9!\u0011\u0017\u0001\u0005\u0002\tMv!\u0003B^g\u0005\u0005\t\u0012\u0001B_\r!\u00114'!A\t\u0002\t}\u0006B\u0002+0\t\u0003\u0011\t\rC\u0005\u0003D>\n\n\u0011\"\u0001\u0003F\ni\u0011\tZ7j]j[7\t\\5f]RT!\u0001N\u001b\u0002\u0005i\\'\"\u0001\u001c\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001!O \u0011\u0005ijT\"A\u001e\u000b\u0003q\nQa]2bY\u0006L!AP\u001e\u0003\r\u0005s\u0017PU3g!\t\u00015)D\u0001B\u0015\t\u0011U'A\u0003vi&d7/\u0003\u0002E\u0003\n9Aj\\4hS:<\u0017\u0001\u0003>l\u00072LWM\u001c;\u0011\u0005\u001dCU\"A\u001a\n\u0005%\u001b$!D&bM.\f'l[\"mS\u0016tG/A\u0006lC\u001a\\\u0017mQ8oM&<\u0007c\u0001\u001eM\u001d&\u0011Qj\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005=\u0013V\"\u0001)\u000b\u0005E+\u0014AB:feZ,'/\u0003\u0002T!\nY1*\u00194lC\u000e{gNZ5h\u0003\u0019a\u0014N\\5u}Q\u0019ak\u0016-\u0011\u0005\u001d\u0003\u0001\"B#\u0004\u0001\u00041\u0005b\u0002&\u0004!\u0003\u0005\raS\u0001\fGJ,\u0017\r^3U_BL7\r\u0006\u0005\\=.\u0004(\u000f`A\u0005!\tQD,\u0003\u0002^w\t!QK\\5u\u0011\u0015yF\u00011\u0001a\u0003\u0015!x\u000e]5d!\t\t\u0007N\u0004\u0002cMB\u00111mO\u0007\u0002I*\u0011QmN\u0001\u0007yI|w\u000e\u001e \n\u0005\u001d\\\u0014A\u0002)sK\u0012,g-\u0003\u0002jU\n11\u000b\u001e:j]\u001eT!aZ\u001e\t\u000b1$\u0001\u0019A7\u0002\u0015A\f'\u000f^5uS>t7\u000f\u0005\u0002;]&\u0011qn\u000f\u0002\u0004\u0013:$\b\"B9\u0005\u0001\u0004i\u0017!\u0005:fa2L7-\u0019;j_:4\u0015m\u0019;pe\"91\u000f\u0002I\u0001\u0002\u0004!\u0018a\u0003;pa&\u001c7i\u001c8gS\u001e\u0004\"!\u001e>\u000e\u0003YT!a\u001e=\u0002\tU$\u0018\u000e\u001c\u0006\u0002s\u0006!!.\u0019<b\u0013\tYhO\u0001\u0006Qe>\u0004XM\u001d;jKNDq! \u0003\u0011\u0002\u0003\u0007a0A\u0007sC\u000e\\\u0017i^1sK6{G-\u001a\t\u0004\u007f\u0006\u0015QBAA\u0001\u0015\r\t\u0019!N\u0001\u0006C\u0012l\u0017N\\\u0005\u0005\u0003\u000f\t\tAA\u0007SC\u000e\\\u0017i^1sK6{G-\u001a\u0005\n\u0003\u0017!\u0001\u0013!a\u0001\u0003\u001b\t1\"^:fgR{\u0007/[2JIB\u0019!(a\u0004\n\u0007\u0005E1HA\u0004C_>dW-\u00198\u0002+\r\u0014X-\u0019;f)>\u0004\u0018n\u0019\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011q\u0003\u0016\u0004i\u0006e1FAA\u000e!\u0011\ti\"a\n\u000e\u0005\u0005}!\u0002BA\u0011\u0003G\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u00152(\u0001\u0006b]:|G/\u0019;j_:LA!!\u000b\u0002 \t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002+\r\u0014X-\u0019;f)>\u0004\u0018n\u0019\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011q\u0006\u0016\u0004}\u0006e\u0011!F2sK\u0006$X\rV8qS\u000e$C-\u001a4bk2$HEN\u000b\u0003\u0003kQC!!\u0004\u0002\u001a\u0005\u0011r-\u001a;Ce>\\WM]'fi\u0006$\u0017\r^1t)\u0019\tY$a\u0017\u0002^A1\u0011QHA\"\u0003\u000fj!!a\u0010\u000b\u0007\u0005\u00053(\u0001\u0006d_2dWm\u0019;j_:LA!!\u0012\u0002@\t\u00191+Z9\u0011\t\u0005%\u0013qK\u0007\u0003\u0003\u0017RA!a\u0001\u0002N)\u0019a'a\u0014\u000b\t\u0005E\u00131K\u0001\u0007CB\f7\r[3\u000b\u0005\u0005U\u0013aA8sO&!\u0011\u0011LA&\u00059\u0011%o\\6fe6+G/\u00193bi\u0006Dq! \u0005\u0011\u0002\u0003\u0007a\u0010C\u0005\u0002`!\u0001\n\u00111\u0001\u0002b\u0005Q!M]8lKJd\u0015n\u001d;\u0011\tib\u00151\r\t\u0006\u0003{\t\u0019%\\\u0001\u001dO\u0016$(I]8lKJlU\r^1eCR\f7\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0003q9W\r\u001e\"s_.,'/T3uC\u0012\fG/Y:%I\u00164\u0017-\u001e7uII*\"!a\u001b+\t\u0005\u0005\u0014\u0011D\u0001\u001aGJ,\u0017\r^3U_BL7mV5uQ\u0006\u001b8/[4o[\u0016tG\u000fF\u0006\\\u0003c\n\u0019(a\u001e\u0002\u0002\u0006\u0015\u0005\"B0\f\u0001\u0004\u0001\u0007BBA;\u0017\u0001\u0007A/\u0001\u0004d_:4\u0017n\u001a\u0005\b\u0003sZ\u0001\u0019AA>\u0003i\u0001\u0018M\u001d;ji&|gNU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u!\u001d\ti$! n\u0003GJA!a \u0002@\t\u0019Q*\u00199\t\u0013\u0005\r5\u0002%AA\u0002\u00055\u0011\u0001\u0003<bY&$\u0017\r^3\t\u0013\u0005-1\u0002%AA\u0002\u00055\u0011aI2sK\u0006$X\rV8qS\u000e<\u0016\u000e\u001e5BgNLwM\\7f]R$C-\u001a4bk2$H\u0005N\u0001$GJ,\u0017\r^3U_BL7mV5uQ\u0006\u001b8/[4o[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0003M1\u0018\r\\5eCR,Gk\u001c9jG\u000e\u0013X-\u0019;f)\u001dY\u0016qRAI\u0003'CQa\u0018\bA\u0002\u0001Dq!!\u001f\u000f\u0001\u0004\tY\b\u0003\u0004\u0002v9\u0001\r\u0001^\u0001\u001eoJLG/\u001a+pa&\u001c\u0007+\u0019:uSRLwN\\!tg&<g.\\3oiRI1,!'\u0002\u001c\u00065\u0016\u0011\u0017\u0005\u0006?>\u0001\r\u0001\u0019\u0005\b\u0003;{\u0001\u0019AAP\u0003E\u0011X\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e\t\b\u0003{\ti(\\AQ!\u0011\t\u0019+!+\u000e\u0005\u0005\u0015&bAATk\u0005Q1m\u001c8ue>dG.\u001a:\n\t\u0005-\u0016Q\u0015\u0002\u0012%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$\bbBAX\u001f\u0001\u0007\u0011QB\u0001\tSN,\u0006\u000fZ1uK\"I\u00111B\b\u0011\u0002\u0003\u0007\u0011QB\u0001(oJLG/\u001a+pa&\u001c\u0007+\u0019:uSRLwN\\!tg&<g.\\3oi\u0012\"WMZ1vYR$C'A\u0006eK2,G/\u001a+pa&\u001cGcA.\u0002:\")q,\u0005a\u0001A\u0006i\u0011\r\u001a3QCJ$\u0018\u000e^5p]N$b\"a\u001f\u0002@\u0006\u0005\u0017QYAe\u0003\u001b\f\t\u000eC\u0003`%\u0001\u0007\u0001\rC\u0004\u0002DJ\u0001\r!a(\u0002%\u0015D\u0018n\u001d;j]\u001e\f5o]5h]6,g\u000e\u001e\u0005\b\u0003\u000f\u0014\u0002\u0019AA\u001e\u0003)\tG\u000e\u001c\"s_.,'o\u001d\u0005\t\u0003\u0017\u0014\u0002\u0013!a\u0001[\u0006ia.^7QCJ$\u0018\u000e^5p]ND\u0011\"!(\u0013!\u0003\u0005\r!a4\u0011\tib\u00151\u0010\u0005\n\u0003'\u0014\u0002\u0013!a\u0001\u0003\u001b\tAB^1mS\u0012\fG/Z(oYf\fq#\u00193e!\u0006\u0014H/\u001b;j_:\u001cH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005e'fA7\u0002\u001a\u00059\u0012\r\u001a3QCJ$\u0018\u000e^5p]N$C-\u001a4bk2$H%N\u000b\u0003\u0003?TC!a4\u0002\u001a\u00059\u0012\r\u001a3QCJ$\u0018\u000e^5p]N$C-\u001a4bk2$HEN\u0001\u001eGJ,\u0017\r^3OK^\u0004\u0016M\u001d;ji&|gn]!tg&<g.\\3oiRa\u0011qTAt\u0003S\fY/!<\u0002p\")qL\u0006a\u0001A\"9\u00111\u0019\fA\u0002\u0005}\u0005bBAd-\u0001\u0007\u00111\b\u0005\t\u0003\u00174\u0002\u0013!a\u0001[\"I\u0011Q\u0014\f\u0011\u0002\u0003\u0007\u0011qZ\u0001(GJ,\u0017\r^3OK^\u0004\u0016M\u001d;ji&|gn]!tg&<g.\\3oi\u0012\"WMZ1vYR$C'A\u0014de\u0016\fG/\u001a(foB\u000b'\u000f^5uS>t7/Q:tS\u001etW.\u001a8uI\u0011,g-Y;mi\u0012*\u0014AH2sK\u0006$X\rU1si&$\u0018n\u001c8t/&$\b.Q:tS\u001etW.\u001a8u)!\ty*!?\u0002|\u0006u\b\"B0\u001a\u0001\u0004\u0001\u0007bBAb3\u0001\u0007\u0011q\u0014\u0005\b\u0003\u007fL\u0002\u0019AAP\u0003YqWm\u001e)beRLG/[8o\u0003N\u001c\u0018n\u001a8nK:$\u0018!\u0007<bY&$\u0017\r^3SKBd\u0017nY1BgNLwM\\7f]R$ra\u0017B\u0003\u0005\u000f\u0011Y\u0001C\u0004\u0002\u001ej\u0001\r!a\u001f\t\r\t%!\u00041\u0001n\u0003e)\u0007\u0010]3di\u0016$'+\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:\t\u000f\t5!\u00041\u0001\u0003\u0010\u0005\u0011\u0012M^1jY\u0006\u0014G.\u001a\"s_.,'/\u00133t!\u0011\t'\u0011C7\n\u0007\tM!NA\u0002TKR\f1\u0002]1sg\u0016\u0014%o\\6feR!!\u0011\u0004B\u000e!\rQD*\u001c\u0005\u0007\u0005;Y\u0002\u0019\u00011\u0002\r\t\u0014xn[3s\u00035\u0019\u0007.\u00198hK\u000e{gNZ5hgRI1La\t\u0003(\t-\"q\u0006\u0005\u0007\u0005Ka\u0002\u0019\u00011\u0002\u0015\u0015tG/\u001b;z)f\u0004X\r\u0003\u0004\u0003*q\u0001\r\u0001Y\u0001\u000bK:$\u0018\u000e^=OC6,\u0007B\u0002B\u00179\u0001\u0007A/A\u0004d_:4\u0017nZ:\t\u0013\tEB\u0004%AA\u0002\u00055\u0011AD5t+N,'o\u00117jK:$\u0018\nZ\u0001\u0018G\"\fgnZ3D_:4\u0017nZ:%I\u00164\u0017-\u001e7uIQ\n!\u0003\u001e:z\u00072,\u0017M\\)v_R\fgj\u001c3fgRA\u0011Q\u0002B\u001d\u0005w\u0011i\u0004\u0003\u0004\u0003&y\u0001\r\u0001\u0019\u0005\u0007\u0005Sq\u0002\u0019\u00011\t\u000f\tEb\u00041\u0001\u0002\u000e\u0005!2\r[1oO\u0016\u001cE.[3oi&#7i\u001c8gS\u001e$Ra\u0017B\"\u0005\u000fBaA!\u0012 \u0001\u0004\u0001\u0017!E:b]&$\u0018N_3e\u00072LWM\u001c;JI\"1!QF\u0010A\u0002Q\fad\u00195b]\u001e,Wk]3s\u001fJ,6/\u001a:DY&,g\u000e^%e\u0007>tg-[4\u0015\u000fm\u0013iE!\u0015\u0003T!1!q\n\u0011A\u0002\u0001\f1c]1oSRL'0\u001a3F]RLG/\u001f(b[\u0016DaA!\f!\u0001\u0004!\b\"\u0003B\u0019AA\u0005\t\u0019AA\u0007\u0003!\u001a\u0007.\u00198hKV\u001bXM](s+N,'o\u00117jK:$\u0018\nZ\"p]\u001aLw\r\n3fM\u0006,H\u000e\u001e\u00134\u0003A1\u0018\r\\5eCR,\u0017\n]\"p]\u001aLw\rF\u0003\\\u00057\u0012y\u0006\u0003\u0004\u0003^\t\u0002\r\u0001Y\u0001\u0003SBDaA!\f#\u0001\u0004!\u0018AD2iC:<W-\u00139D_:4\u0017n\u001a\u000b\u00067\n\u0015$q\r\u0005\u0007\u0005;\u001a\u0003\u0019\u00011\t\r\t52\u00051\u0001u\u0003M1\u0018\r\\5eCR,Gk\u001c9jG\u000e{gNZ5h)\u0015Y&Q\u000eB8\u0011\u0015yF\u00051\u0001a\u0011\u0019\u0011i\u0003\na\u0001i\u0006\t2\r[1oO\u0016$v\u000e]5d\u0007>tg-[4\u0015\u000bm\u0013)Ha\u001e\t\u000b}+\u0003\u0019\u00011\t\r\t5R\u00051\u0001u\u0003I\u0019\u0007.\u00198hK\n\u0013xn[3s\u0007>tg-[4\u0015\u000bm\u0013iH!!\t\u000f\t}d\u00051\u0001\u0002d\u00059!M]8lKJ\u001c\bB\u0002B\u0017M\u0001\u0007A\u000fF\u0003\\\u0005\u000b\u00139\tC\u0004\u0003\u001e\u001d\u0002\rA!\u0007\t\r\t5r\u00051\u0001u\u0003Q1\u0018\r\\5eCR,'I]8lKJ\u001cuN\u001c4jOR\u00191L!$\t\r\t5\u0002\u00061\u0001u\u0003I\u0019\u0007.\u00198hK\u0016sG/\u001b;z\u0007>tg-[4\u0015\u0013m\u0013\u0019Ja&\u0003\u001c\nu\u0005B\u0002BKS\u0001\u0007\u0001-\u0001\bs_>$XI\u001c;jif$\u0016\u0010]3\t\r\te\u0015\u00061\u0001a\u0003]1W\u000f\u001c7TC:LG/\u001b>fI\u0016sG/\u001b;z\u001d\u0006lW\r\u0003\u0004\u0003.%\u0002\r\u0001\u001e\u0005\n\u0005cI\u0003\u0013!a\u0001\u0003\u001b\tAd\u00195b]\u001e,WI\u001c;jif\u001cuN\u001c4jO\u0012\"WMZ1vYR$C'A\tgKR\u001c\u0007.\u00128uSRL8i\u001c8gS\u001e$R\u0001\u001eBS\u0005OCaA!&,\u0001\u0004\u0001\u0007B\u0002B(W\u0001\u0007\u0001-A\u000bgKR\u001c\u0007.\u00117m\u000b:$\u0018\u000e^=D_:4\u0017nZ:\u0015\t\t5&q\u0016\t\u0007\u0003{\ti\b\u0019;\t\r\t\u0015B\u00061\u0001a\u0003i1W\r^2i\u00032d7\t[5mI\u0016sG/\u001b;z\u0007>tg-[4t)\u0019\u0011iK!.\u00038\"1!QS\u0017A\u0002\u0001DaA!/.\u0001\u0004\u0001\u0017aD2iS2$WI\u001c;jif$\u0016\u0010]3\u0002\u001b\u0005#W.\u001b8[W\u000ec\u0017.\u001a8u!\t9uf\u0005\u00020sQ\u0011!QX\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t\u001d'fA&\u0002\u001a\u0001")
public class AdminZkClient
implements Logging {
    private final KafkaZkClient zkClient;
    private final Option<KafkaConfig> kafkaConfig;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<KafkaConfig> $lessinit$greater$default$2() {
        return None$.MODULE$;
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void createTopic(String topic, int partitions, int replicationFactor, Properties topicConfig, RackAwareMode rackAwareMode, boolean usesTopicId) {
        java.util.List brokerMetadatas = CollectionConverters$.MODULE$.SeqHasAsJava(this.getBrokerMetadatas(rackAwareMode, this.getBrokerMetadatas$default$2())).asJava();
        Map<Object, Seq<Object>> replicaAssignment = CoreUtils$.MODULE$.replicaToBrokerAssignmentAsScala(AdminUtils.assignReplicasToBrokers((Collection)brokerMetadatas, (int)partitions, (int)replicationFactor, (int)-1, (int)-1));
        boolean x$5 = this.createTopicWithAssignment$default$4();
        this.createTopicWithAssignment(topic, topicConfig, replicaAssignment, x$5, usesTopicId);
    }

    public Properties createTopic$default$4() {
        return new Properties();
    }

    public RackAwareMode createTopic$default$5() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public boolean createTopic$default$6() {
        return false;
    }

    public Seq<BrokerMetadata> getBrokerMetadatas(RackAwareMode rackAwareMode, Option<Seq<Object>> brokerList) {
        Seq<Broker> allBrokers = this.zkClient.getAllBrokersInCluster();
        Seq brokers = (Seq)brokerList.map((Function1 & Serializable)brokerIds -> (Seq)allBrokers.filter((Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)brokerIds.contains((Object)BoxesRunTime.boxToInteger((int)b.id()))))).getOrElse((Function0 & Serializable)() -> allBrokers);
        Seq brokersWithRack = (Seq)brokers.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$getBrokerMetadatas$4(x$1)));
        RackAwareMode rackAwareMode2 = rackAwareMode;
        RackAwareMode$Enforced$ rackAwareMode$Enforced$ = RackAwareMode$Enforced$.MODULE$;
        if (rackAwareMode2 != null && rackAwareMode2.equals(rackAwareMode$Enforced$) && brokersWithRack.nonEmpty() && brokersWithRack.size() < brokers.size()) {
            throw new AdminOperationException("Not all brokers have rack information. Add --disable-rack-aware in command line to make replica assignment without rack information.");
        }
        return (Seq)(RackAwareMode$Disabled$.MODULE$.equals(rackAwareMode) ? (Seq)brokers.map((Function1 & Serializable)broker -> new BrokerMetadata(broker.id(), Optional.empty())) : (RackAwareMode$Safe$.MODULE$.equals(rackAwareMode) && brokersWithRack.size() < brokers.size() ? (Seq)brokers.map((Function1 & Serializable)broker -> new BrokerMetadata(broker.id(), Optional.empty())) : (Seq)brokers.map((Function1 & Serializable)broker -> new BrokerMetadata(broker.id(), Optional.ofNullable(broker.rack().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())))))).sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id), (Ordering)Ordering.Int$.MODULE$);
    }

    public RackAwareMode getBrokerMetadatas$default$1() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public Option<Seq<Object>> getBrokerMetadatas$default$2() {
        return None$.MODULE$;
    }

    public void createTopicWithAssignment(String topic, Properties config, Map<Object, Seq<Object>> partitionReplicaAssignment, boolean validate, boolean usesTopicId) {
        if (validate) {
            this.validateTopicCreate(topic, partitionReplicaAssignment, config);
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Creating topic ").append(topic).append(" with configuration ").append(config).append(" and initial partition ").append("assignment ").append(partitionReplicaAssignment).toString());
        this.zkClient.setOrCreateEntityConfigs("topics", topic, config);
        this.writeTopicPartitionAssignment(topic, (Map<Object, ReplicaAssignment>)((Map)partitionReplicaAssignment.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int k = x0$1._1$mcI$sp();
                Seq v = (Seq)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)ReplicaAssignment$.MODULE$.apply((Seq<Object>)v));
            }
            throw new MatchError(null);
        })), false, usesTopicId);
    }

    public boolean createTopicWithAssignment$default$4() {
        return true;
    }

    public boolean createTopicWithAssignment$default$5() {
        return false;
    }

    public void validateTopicCreate(String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, Properties config) {
        Topic.validate((String)topic);
        if (this.zkClient.isTopicMarkedForDeletion(topic)) {
            throw new TopicExistsException(new StringBuilder(32).append("Topic '").append(topic).append("' is marked for deletion.").toString());
        }
        if (this.zkClient.topicExists(topic)) {
            throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
        }
        if (Topic.hasCollisionChars((String)topic)) {
            scala.collection.immutable.Set<String> allTopics = this.zkClient.getAllTopicsInCluster(this.zkClient.getAllTopicsInCluster$default$1());
            if (allTopics.contains((Object)topic)) {
                throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
            }
            scala.collection.immutable.Set collidingTopics = (scala.collection.immutable.Set)allTopics.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$validateTopicCreate$1(topic, x$3)));
            if (collidingTopics.nonEmpty()) {
                throw new InvalidTopicException(new StringBuilder(40).append("Topic '").append(topic).append("' collides with existing topics: ").append(collidingTopics.mkString(", ")).toString());
            }
        }
        if (((IterableOnceOps)partitionReplicaAssignment.values().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.size()))).toSet().size() != 1) {
            throw new InvalidReplicaAssignmentException("All partitions should have the same number of replicas");
        }
        partitionReplicaAssignment.values().foreach((Function1 & Serializable)reps -> {
            AdminZkClient.$anonfun$validateTopicCreate$3(partitionReplicaAssignment, reps);
            return BoxedUnit.UNIT;
        });
        int partitionSize = partitionReplicaAssignment.size();
        int sequenceSum = partitionSize * (partitionSize - 1) / 2;
        if (partitionReplicaAssignment.size() != partitionReplicaAssignment.toSet().size() || BoxesRunTime.unboxToInt((Object)((IterableOnceOps)partitionReplicaAssignment.keys().filter((Function1)(JFunction1.mcZI.sp & Serializable)x$5 -> x$5 >= 0)).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) != sequenceSum) {
            throw new InvalidReplicaAssignmentException("partitions should be a consecutive 0-based integer sequence");
        }
        LogConfig.validate((Properties)config, (java.util.Map)((java.util.Map)this.kafkaConfig.map((Function1 & Serializable)x$6 -> x$6.extractLogConfigMap()).getOrElse((Function0 & Serializable)() -> Collections.emptyMap())), (boolean)this.kafkaConfig.exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$validateTopicCreate$7(x$7))));
    }

    private void writeTopicPartitionAssignment(String topic, Map<Object, ReplicaAssignment> replicaAssignment, boolean isUpdate, boolean usesTopicId) {
        try {
            scala.collection.immutable.Map assignment = replicaAssignment.map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    int partitionId = x0$1._1$mcI$sp();
                    ReplicaAssignment replicas = (ReplicaAssignment)x0$1._2();
                    return new Tuple2((Object)new TopicPartition(topic, partitionId), (Object)replicas);
                }
                throw new MatchError(null);
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            if (!isUpdate) {
                None$ topicIdOpt = usesTopicId ? new Some((Object)Uuid.randomUuid()) : None$.MODULE$;
                this.zkClient.createTopicAssignment(topic, (Option<Uuid>)topicIdOpt, (Map<TopicPartition, Seq<Object>>)((Map)assignment.map((Function1 & Serializable)x0$2 -> {
                    if (x0$2 != null) {
                        TopicPartition k = (TopicPartition)x0$2._1();
                        ReplicaAssignment v = (ReplicaAssignment)x0$2._2();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), v.replicas());
                    }
                    throw new MatchError(null);
                })));
            } else {
                Map<String, Uuid> topicIds = this.zkClient.getTopicIdsForTopics((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
                this.zkClient.setTopicAssignment(topic, (Option<Uuid>)topicIds.get((Object)topic), (Map<TopicPartition, ReplicaAssignment>)assignment, this.zkClient.setTopicAssignment$default$4());
            }
            this.debug((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Updated path %s with %s for replica assignment"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{TopicZNode$.MODULE$.path(topic), assignment})));
            return;
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
        }
        catch (Throwable e2) {
            throw new AdminOperationException(e2.toString());
        }
    }

    private boolean writeTopicPartitionAssignment$default$4() {
        return false;
    }

    public void deleteTopic(String topic) {
        if (this.zkClient.topicExists(topic)) {
            try {
                this.zkClient.createDeleteTopicPath(topic);
                return;
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                throw new TopicAlreadyMarkedForDeletionException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("topic %s is already marked for deletion"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            }
            catch (Throwable e) {
                throw new AdminOperationException(e.getMessage());
            }
        }
        throw new UnknownTopicOrPartitionException(new StringBuilder(33).append("Topic `").append(topic).append("` to delete does not exist").toString());
    }

    public Map<Object, Seq<Object>> addPartitions(String topic, Map<Object, ReplicaAssignment> existingAssignment, Seq<BrokerMetadata> allBrokers, int numPartitions, Option<Map<Object, Seq<Object>>> replicaAssignment, boolean validateOnly) {
        Map<Object, ReplicaAssignment> proposedAssignmentForNewPartitions = this.createNewPartitionsAssignment(topic, existingAssignment, allBrokers, numPartitions, replicaAssignment);
        if (validateOnly) {
            return (Map)((MapOps)existingAssignment.$plus$plus(proposedAssignmentForNewPartitions)).map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    int k = x0$1._1$mcI$sp();
                    ReplicaAssignment v = (ReplicaAssignment)x0$1._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), v.replicas());
                }
                throw new MatchError(null);
            });
        }
        return (Map)this.createPartitionsWithAssignment(topic, existingAssignment, proposedAssignmentForNewPartitions).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                int k = x0$2._1$mcI$sp();
                ReplicaAssignment v = (ReplicaAssignment)x0$2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), v.replicas());
            }
            throw new MatchError(null);
        });
    }

    public int addPartitions$default$4() {
        return 1;
    }

    public Option<Map<Object, Seq<Object>>> addPartitions$default$5() {
        return None$.MODULE$;
    }

    public boolean addPartitions$default$6() {
        return false;
    }

    public Map<Object, ReplicaAssignment> createNewPartitionsAssignment(String topic, Map<Object, ReplicaAssignment> existingAssignment, Seq<BrokerMetadata> allBrokers, int numPartitions, Option<Map<Object, Seq<Object>>> replicaAssignment) {
        Seq<Object> existingAssignmentPartition0 = ((ReplicaAssignment)existingAssignment.getOrElse((Object)BoxesRunTime.boxToInteger((int)0), (Function0 & Serializable)() -> {
            throw new AdminOperationException(new StringBuilder(92).append("Unexpected existing replica assignment for topic '").append(topic).append("', partition id 0 is missing. ").append("Assignment: ").append(existingAssignment).toString());
        })).replicas();
        int partitionsToAdd = numPartitions - existingAssignment.size();
        if (partitionsToAdd <= 0) {
            throw new InvalidPartitionsException(new StringBuilder(120).append("The number of partitions for a topic can only be increased. ").append("Topic ").append(topic).append(" currently has ").append(existingAssignment.size()).append(" partitions, ").append(numPartitions).append(" would not be an increase.").toString());
        }
        replicaAssignment.foreach((Function1 & Serializable)proposedReplicaAssignment -> {
            this.validateReplicaAssignment((Map<Object, Seq<Object>>)proposedReplicaAssignment, existingAssignmentPartition0.size(), (scala.collection.immutable.Set<Object>)((IterableOnceOps)allBrokers.map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.id))).toSet());
            return BoxedUnit.UNIT;
        });
        return (Map)((Map)replicaAssignment.getOrElse((Function0 & Serializable)() -> {
            int startIndex = package$.MODULE$.max(0, allBrokers.indexWhere((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$createNewPartitionsAssignment$5(existingAssignmentPartition0, x$9))));
            return CoreUtils$.MODULE$.replicaToBrokerAssignmentAsScala(AdminUtils.assignReplicasToBrokers((Collection)CollectionConverters$.MODULE$.SeqHasAsJava(allBrokers).asJava(), (int)partitionsToAdd, (int)existingAssignmentPartition0.size(), (int)startIndex, (int)existingAssignment.size()));
        })).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                void apply_removingReplicas;
                int tp = x0$1._1$mcI$sp();
                Seq replicas = (Seq)x0$1._2();
                Nil$ nil$ = Nil$.MODULE$;
                Nil$ apply_addingReplicas = Nil$.MODULE$;
                Object var3_4 = null;
                nil$ = null;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp)), (Object)new ReplicaAssignment((Seq<Object>)replicas, (Seq<Object>)apply_addingReplicas, (Seq<Object>)apply_removingReplicas));
            }
            throw new MatchError(null);
        });
    }

    public int createNewPartitionsAssignment$default$4() {
        return 1;
    }

    public Option<Map<Object, Seq<Object>>> createNewPartitionsAssignment$default$5() {
        return None$.MODULE$;
    }

    public Map<Object, ReplicaAssignment> createPartitionsWithAssignment(String topic, Map<Object, ReplicaAssignment> existingAssignment, Map<Object, ReplicaAssignment> newPartitionAssignment) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(68).append("Creating ").append(newPartitionAssignment.size()).append(" partitions for '").append(topic).append("' with the following replica assignment: ").append(newPartitionAssignment).append(".").toString());
        Map combinedAssignment = (Map)existingAssignment.$plus$plus(newPartitionAssignment);
        this.writeTopicPartitionAssignment(topic, (Map<Object, ReplicaAssignment>)combinedAssignment, true, false);
        return combinedAssignment;
    }

    private void validateReplicaAssignment(Map<Object, Seq<Object>> replicaAssignment, int expectedReplicationFactor, scala.collection.immutable.Set<Object> availableBrokerIds) {
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(partitionId, replicas) -> AdminZkClient.$anonfun$validateReplicaAssignment$1(availableBrokerIds, BoxesRunTime.unboxToInt((Object)partitionId), replicas);
        replicaAssignment.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
        Object var8_4 = null;
        Map badRepFactors = (Map)replicaAssignment.collect((PartialFunction)new Serializable(null, expectedReplicationFactor){
            private static final long serialVersionUID = 0L;
            private final int expectedReplicationFactor$1;

            public final <A1 extends Tuple2<Object, Seq<Object>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 != null) {
                    int partition = x1._1$mcI$sp();
                    Seq replicas = (Seq)x1._2();
                    if (replicas.size() != this.expectedReplicationFactor$1) {
                        return (B1)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)BoxesRunTime.boxToInteger((int)replicas.size()));
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Object, Seq<Object>> x1) {
                return x1 != null && ((Seq)x1._2()).size() != this.expectedReplicationFactor$1;
            }
            {
                this.expectedReplicationFactor$1 = expectedReplicationFactor$1;
            }
        });
        if (badRepFactors.nonEmpty()) {
            scala.collection.immutable.Seq sortedBadRepFactors = (scala.collection.immutable.Seq)badRepFactors.toSeq().sortBy((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$2(x0$1)), (Ordering)Ordering.Int$.MODULE$);
            scala.collection.immutable.Seq partitions = (scala.collection.immutable.Seq)sortedBadRepFactors.map((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$3(x0$2)));
            scala.collection.immutable.Seq repFactors = (scala.collection.immutable.Seq)sortedBadRepFactors.map((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$4(x0$3)));
            throw new InvalidReplicaAssignmentException(new StringBuilder(131).append("Inconsistent replication factor between partitions, ").append("partition 0 has ").append(expectedReplicationFactor).append(" while partitions [").append(partitions.mkString(", ")).append("] have ").append("replication factors [").append(repFactors.mkString(", ")).append("], respectively.").toString());
        }
    }

    public Option<Object> parseBroker(String broker) {
        switch (broker == null ? 0 : broker.hashCode()) {
            case -428804519: {
                if (!"<default>".equals(broker)) break;
                return None$.MODULE$;
            }
        }
        try {
            return new Some((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(broker))));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(new StringBuilder(78).append("Error parsing broker ").append(broker).append(". The broker's Entity Name must be a single integer value").toString());
        }
    }

    public void changeConfigs(String entityType, String entityName, Properties configs, boolean isUserClientId) {
        switch (entityType == null ? 0 : entityType.hashCode()) {
            case -868034268: {
                if (!"topics".equals(entityType)) break;
                this.changeTopicConfig(entityName, configs);
                return;
            }
            case 104492: {
                if (!"ips".equals(entityType)) break;
                this.changeIpConfig(entityName, configs);
                return;
            }
            case 111578632: {
                if (!"users".equals(entityType)) break;
                this.changeUserOrUserClientIdConfig(entityName, configs, isUserClientId);
                return;
            }
            case 150569914: {
                if (!"brokers".equals(entityType)) break;
                this.changeBrokerConfig(this.parseBroker(entityName), configs);
                return;
            }
            case 860587528: {
                if (!"clients".equals(entityType)) break;
                this.changeClientIdConfig(entityName, configs);
                return;
            }
        }
        throw new IllegalArgumentException(new StringBuilder(51).append(entityType).append(" is not a known entityType. Should be one of List(").append(String.join((CharSequence)", ", ConfigType.ALL)).append(")").toString());
    }

    public boolean changeConfigs$default$4() {
        return false;
    }

    private boolean tryCleanQuotaNodes(String entityType, String entityName, boolean isUserClientId) {
        String currPath = ConfigEntityZNode$.MODULE$.path(entityType, entityName);
        if (this.zkClient.getChildren(currPath).isEmpty()) {
            ObjectRef pathToDelete = ObjectRef.create((Object)currPath);
            if (isUserClientId) {
                String user = entityName.substring(0, entityName.indexOf("/"));
                String clientId = entityName.substring(entityName.lastIndexOf("/") + 1);
                String clientsPath = ConfigEntityZNode$.MODULE$.path("users", new StringBuilder(8).append(user).append("/").append("clients").toString());
                Seq<String> seq = this.zkClient.getChildren(clientsPath);
                .colon.colon colon2 = new .colon.colon((Object)clientId, (List)Nil$.MODULE$);
                if (seq != null && seq.equals((Object)colon2)) {
                    pathToDelete.elem = clientsPath;
                    Properties userData = this.fetchEntityConfig("users", user);
                    String userPath = ConfigEntityZNode$.MODULE$.path("users", user);
                    Seq<String> userChildren = this.zkClient.getChildren(userPath);
                    if (userData.isEmpty()) {
                        Seq<String> seq2 = userChildren;
                        .colon.colon colon3 = new .colon.colon((Object)"clients", (List)Nil$.MODULE$);
                        if (seq2 != null && seq2.equals((Object)colon3)) {
                            pathToDelete.elem = userPath;
                        }
                    }
                }
            }
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Deleting zk node ").append((String)pathToDelete$1.elem).append(" since node of entityType ").append(entityType).append(" and entityName ").append(entityName).append(" is empty.").toString());
            this.zkClient.deletePath((String)pathToDelete.elem, this.zkClient.deletePath$default$2(), this.zkClient.deletePath$default$3());
            return true;
        }
        return false;
    }

    public void changeClientIdConfig(String sanitizedClientId, Properties configs) {
        DynamicConfig$Client$.MODULE$.validate(configs);
        this.changeEntityConfig("clients", sanitizedClientId, configs, false);
    }

    public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configs, boolean isUserClientId) {
        String string = sanitizedEntityName;
        String string2 = "<default>";
        if (string != null && string.equals(string2) || sanitizedEntityName.contains("/clients")) {
            DynamicConfig$Client$.MODULE$.validate(configs);
        } else {
            DynamicConfig$User$.MODULE$.validate(configs);
        }
        this.changeEntityConfig("users", sanitizedEntityName, configs, isUserClientId);
    }

    public boolean changeUserOrUserClientIdConfig$default$3() {
        return false;
    }

    private void validateIpConfig(String ip, Properties configs) {
        if (!DynamicConfig$Ip$.MODULE$.isValidIpEntity(ip)) {
            throw new AdminOperationException(new StringBuilder(38).append(ip).append(" is not a valid IP or resolvable host.").toString());
        }
        DynamicConfig$Ip$.MODULE$.validate(configs);
    }

    public void changeIpConfig(String ip, Properties configs) {
        this.validateIpConfig(ip, configs);
        this.changeEntityConfig("ips", ip, configs, false);
    }

    public void validateTopicConfig(String topic, Properties configs) {
        Topic.validate((String)topic);
        if (!this.zkClient.topicExists(topic)) {
            throw new UnknownTopicOrPartitionException(new StringBuilder(24).append("Topic '").append(topic).append("' does not exist.").toString());
        }
        LogConfig.validate((Properties)configs, (java.util.Map)((java.util.Map)this.kafkaConfig.map((Function1 & Serializable)x$10 -> x$10.extractLogConfigMap()).getOrElse((Function0 & Serializable)() -> Collections.emptyMap())), (boolean)this.kafkaConfig.exists((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$validateTopicConfig$3(x$11))));
    }

    public void changeTopicConfig(String topic, Properties configs) {
        this.validateTopicConfig(topic, configs);
        this.changeEntityConfig("topics", topic, configs, false);
    }

    public void changeBrokerConfig(Seq<Object> brokers, Properties configs) {
        DynamicConfig$Broker$.MODULE$.validate(configs);
        brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable)broker -> this.changeEntityConfig("brokers", Integer.toString(broker), configs, false));
    }

    public void changeBrokerConfig(Option<Object> broker, Properties configs) {
        DynamicConfig$Broker$.MODULE$.validate(configs);
        this.changeEntityConfig("brokers", (String)broker.map((Function1 & Serializable)x$12 -> AdminZkClient.$anonfun$changeBrokerConfig$2(BoxesRunTime.unboxToInt((Object)x$12))).getOrElse((Function0 & Serializable)() -> "<default>"), configs, false);
    }

    private void validateBrokerConfig(Properties configs) {
        DynamicConfig$Broker$.MODULE$.validate(configs);
    }

    private void changeEntityConfig(String rootEntityType, String fullSanitizedEntityName, Properties configs, boolean isUserClientId) {
        String sanitizedEntityPath = new StringBuilder(11).append(rootEntityType).append('/').append(fullSanitizedEntityName).toString();
        boolean needUpdateConfigs = true;
        if (("clients".equals(rootEntityType) || "users".equals(rootEntityType) || "ips".equals(rootEntityType)) && configs.isEmpty() && this.tryCleanQuotaNodes(rootEntityType, fullSanitizedEntityName, isUserClientId)) {
            needUpdateConfigs = false;
        }
        if (needUpdateConfigs) {
            this.zkClient.setOrCreateEntityConfigs(rootEntityType, fullSanitizedEntityName, configs);
        }
        this.zkClient.createConfigChangeNotification(sanitizedEntityPath);
    }

    private boolean changeEntityConfig$default$4() {
        return false;
    }

    public Properties fetchEntityConfig(String rootEntityType, String sanitizedEntityName) {
        return this.zkClient.getEntityConfigs(rootEntityType, sanitizedEntityName);
    }

    public Map<String, Properties> fetchAllEntityConfigs(String entityType) {
        return ((IterableOnceOps)this.zkClient.getAllEntitiesWithConfig(entityType).map((Function1 & Serializable)entity -> new Tuple2(entity, (Object)this.fetchEntityConfig(entityType, (String)entity)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, Properties> fetchAllChildEntityConfigs(String rootEntityType, String childEntityType) {
        return ((IterableOnceOps)((IterableOps)this.entityPaths$1((Option)None$.MODULE$, rootEntityType).flatMap((Function1 & Serializable)entity -> this.entityPaths$1((Option)new Some((Object)new StringBuilder(11).append((String)entity).append('/').append(childEntityType).toString()), rootEntityType))).map((Function1 & Serializable)entityPath -> new Tuple2(entityPath, (Object)this.fetchEntityConfig(rootEntityType, (String)entityPath)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ boolean $anonfun$getBrokerMetadatas$4(Broker x$1) {
        return x$1.rack().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicCreate$1(String topic$2, String x$3) {
        return Topic.hasCollision((String)topic$2, (String)x$3);
    }

    public static final /* synthetic */ void $anonfun$validateTopicCreate$3(Map partitionReplicaAssignment$2, Seq reps) {
        if (reps.size() != reps.toSet().size()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(36).append("Duplicate replica assignment found: ").append(partitionReplicaAssignment$2).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicCreate$7(KafkaConfig x$7) {
        RemoteLogManagerConfig remoteLogManagerConfig = x$7.remoteLogManagerConfig();
        if (remoteLogManagerConfig == null) {
            throw null;
        }
        return remoteLogManagerConfig.getBoolean("remote.log.storage.system.enable");
    }

    public static final /* synthetic */ boolean $anonfun$createNewPartitionsAssignment$5(Seq existingAssignmentPartition0$1, BrokerMetadata x$9) {
        return x$9.id >= BoxesRunTime.unboxToInt((Object)existingAssignmentPartition0$1.head());
    }

    public static final /* synthetic */ Tuple2 $anonfun$validateReplicaAssignment$1(scala.collection.immutable.Set availableBrokerIds$1, int partitionId, Seq replicas) {
        if (replicas.isEmpty()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(54).append("Cannot have replication factor of 0 for partition id ").append(partitionId).append(".").toString());
        }
        if (replicas.size() != replicas.toSet().size()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(72).append("Duplicate brokers not allowed in replica assignment: ").append(replicas.mkString(", ")).append(" for partition id ").append(partitionId).append(".").toString());
        }
        if (!replicas.toSet().subsetOf((Set)availableBrokerIds$1)) {
            throw new BrokerNotAvailableException(new StringBuilder(101).append("Some brokers specified for partition id ").append(partitionId).append(" are not available. ").append("Specified brokers: ").append(replicas.mkString(", ")).append(", ").append("available brokers: ").append(availableBrokerIds$1.mkString(", ")).append(".").toString());
        }
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partitionId)), (Object)BoxesRunTime.boxToInteger((int)replicas.size()));
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$2(Tuple2 x0$1) {
        if (x0$1 != null) {
            return x0$1._1$mcI$sp();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$3(Tuple2 x0$2) {
        if (x0$2 != null) {
            return x0$2._1$mcI$sp();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$4(Tuple2 x0$3) {
        if (x0$3 != null) {
            return x0$3._2$mcI$sp();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicConfig$3(KafkaConfig x$11) {
        RemoteLogManagerConfig remoteLogManagerConfig = x$11.remoteLogManagerConfig();
        if (remoteLogManagerConfig == null) {
            throw null;
        }
        return remoteLogManagerConfig.getBoolean("remote.log.storage.system.enable");
    }

    public static final /* synthetic */ String $anonfun$changeBrokerConfig$2(int x$12) {
        return Integer.toString(x$12);
    }

    private final Seq entityPaths$1(Option rootPath, String rootEntityType$1) {
        String string;
        if (rootPath instanceof Some) {
            String path = (String)((Some)rootPath).value();
            string = new StringBuilder(11).append(rootEntityType$1).append('/').append(path).toString();
        } else if (None$.MODULE$.equals(rootPath)) {
            string = rootEntityType$1;
        } else {
            throw new MatchError((Object)rootPath);
        }
        String root = string;
        Seq<String> entityNames = this.zkClient.getAllEntitiesWithConfig(root);
        if (rootPath instanceof Some) {
            String path = (String)((Some)rootPath).value();
            return (Seq)entityNames.map((Function1 & Serializable)entityName -> new StringBuilder(11).append(path).append('/').append((String)entityName).toString());
        }
        if (None$.MODULE$.equals(rootPath)) {
            return entityNames;
        }
        throw new MatchError((Object)rootPath);
    }

    public AdminZkClient(KafkaZkClient zkClient, Option<KafkaConfig> kafkaConfig) {
        this.zkClient = zkClient;
        this.kafkaConfig = kafkaConfig;
    }
}

