/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.ConflictResolutionAction;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.PullMode;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.task.AnyTemplatePullTask;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.job.JobExecutionException;
import org.apache.syncope.core.provisioning.api.pushpull.InboundActions;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.ReconFilterBuilder;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopeSinglePullExecutor;
import org.apache.syncope.core.provisioning.api.pushpull.UserPullResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.PullJobDelegate;
import org.apache.syncope.core.provisioning.java.pushpull.PullResultHandlerDispatcher;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.provisioning.java.utils.TemplateUtils;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.springframework.beans.factory.annotation.Autowired;

public class SinglePullJobDelegate
extends PullJobDelegate
implements SyncopeSinglePullExecutor {
    @Autowired
    protected ImplementationDAO implementationDAO;
    @Autowired
    protected RealmSearchDAO realmSearchDAO;

    public List<ProvisioningReport> pull(ExternalResource resource, Provision provision, Connector connector, ReconFilterBuilder reconFilterBuilder, Set<String> moreAttrsToGet, PullTaskTO pullTaskTO, String executor) throws JobExecutionException {
        LOG.debug("Executing pull on {}", (Object)resource);
        this.taskType = TaskType.PULL;
        try {
            this.task = (SchedTask)this.entityFactory.newEntity(PullTask.class);
            ((PullTask)this.task).setName(pullTaskTO.getName());
            ((PullTask)this.task).setResource(resource);
            ((PullTask)this.task).setMatchingRule(pullTaskTO.getMatchingRule() == null ? MatchingRule.UPDATE : pullTaskTO.getMatchingRule());
            ((PullTask)this.task).setUnmatchingRule(pullTaskTO.getUnmatchingRule() == null ? UnmatchingRule.PROVISION : pullTaskTO.getUnmatchingRule());
            ((PullTask)this.task).setPullMode(PullMode.FILTERED_RECONCILIATION);
            ((PullTask)this.task).setPerformCreate(pullTaskTO.isPerformCreate());
            ((PullTask)this.task).setPerformUpdate(pullTaskTO.isPerformUpdate());
            ((PullTask)this.task).setPerformDelete(pullTaskTO.isPerformDelete());
            ((PullTask)this.task).setSyncStatus(pullTaskTO.isSyncStatus());
            ((PullTask)this.task).setDestinationRealm((Realm)this.realmSearchDAO.findByFullPath(pullTaskTO.getDestinationRealm()).orElseThrow(() -> new NotFoundException("Realm " + pullTaskTO.getDestinationRealm())));
            ((PullTask)this.task).setRemediation(pullTaskTO.isRemediation());
            TemplateUtils.check(pullTaskTO.getTemplates(), ClientExceptionType.InvalidPullTask);
            pullTaskTO.getTemplates().forEach((type, template) -> this.anyTypeDAO.findById(type).ifPresentOrElse(anyType -> {
                AnyTemplatePullTask anyTemplate = ((PullTask)this.task).getTemplate(anyType.getKey()).orElse(null);
                if (anyTemplate == null) {
                    anyTemplate = (AnyTemplatePullTask)this.entityFactory.newEntity(AnyTemplatePullTask.class);
                    anyTemplate.setAnyType(anyType);
                    anyTemplate.setPullTask((PullTask)this.task);
                    ((PullTask)this.task).add(anyTemplate);
                }
                anyTemplate.set(template);
            }, () -> LOG.debug("Invalid AnyType {} specified, ignoring...", type)));
            this.profile = new ProvisioningProfile(connector, this.taskType, (ProvisioningTask)((PullTask)this.task), ConflictResolutionAction.FIRSTMATCH, this.getInboundActions(pullTaskTO.getActions().stream().map(arg_0 -> ((ImplementationDAO)this.implementationDAO).findById(arg_0)).flatMap(Optional::stream).toList()), executor, false);
            this.dispatcher = new PullResultHandlerDispatcher((ProvisioningProfile<PullTask, InboundActions>)this.profile, this);
            for (InboundActions action : this.profile.getActions()) {
                action.beforeAll(this.profile);
            }
            AnyType anyType = (AnyType)this.anyTypeDAO.findById(provision.getAnyType()).orElseThrow(() -> new NotFoundException("AnyType" + provision.getAnyType()));
            this.ghandler = this.buildGroupHandler();
            this.dispatcher.addHandlerSupplier(provision.getObjectClass(), () -> {
                UserPullResultHandler handler = switch (anyType.getKind()) {
                    case AnyTypeKind.USER -> this.buildUserHandler();
                    case AnyTypeKind.GROUP -> this.ghandler;
                    default -> this.buildAnyObjectHandler();
                };
                handler.setProfile(this.profile);
                return handler;
            });
            HashSet<String> matg = new HashSet<String>(moreAttrsToGet);
            this.profile.getActions().forEach(a -> matg.addAll(a.moreAttrsToGet(this.profile, provision)));
            connector.filteredReconciliation(new ObjectClass(provision.getObjectClass()), reconFilterBuilder, (SyncResultsHandler)this.dispatcher, MappingUtils.buildOperationOptions(MappingUtils.getInboundItems(provision.getMapping().getItems().stream()), (String[])matg.toArray(String[]::new)));
            try {
                this.setGroupOwners();
            }
            catch (Exception e) {
                LOG.error("While setting group owners", (Throwable)e);
            }
            for (InboundActions action : this.profile.getActions()) {
                action.afterAll(this.profile);
            }
            return this.profile.getResults();
        }
        catch (Exception e) {
            JobExecutionException jobExecutionException;
            throw e instanceof JobExecutionException ? (jobExecutionException = (JobExecutionException)((Object)e)) : new JobExecutionException("While pulling from connector", (Throwable)e);
        }
    }
}

