/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.ConnConfPropSchema;
import org.apache.syncope.common.lib.types.ConnConfProperty;
import org.apache.syncope.common.lib.types.ConnPoolConf;
import org.apache.syncope.core.persistence.api.dao.ConnInstanceDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.entity.ConnInstance;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.utils.ConnPoolConfUtils;
import org.apache.syncope.core.provisioning.api.ConnIdBundleManager;
import org.apache.syncope.core.provisioning.api.data.ConnInstanceDataBinder;
import org.identityconnectors.framework.api.ConfigurationProperties;
import org.identityconnectors.framework.api.ConfigurationProperty;
import org.identityconnectors.framework.api.ConnectorInfo;
import org.identityconnectors.framework.impl.api.ConfigurationPropertyImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnInstanceDataBinderImpl
implements ConnInstanceDataBinder {
    protected static final Logger LOG = LoggerFactory.getLogger(ConnInstanceDataBinder.class);
    protected final ConnIdBundleManager connIdBundleManager;
    protected final ConnInstanceDAO connInstanceDAO;
    protected final RealmSearchDAO realmSearchDAO;
    protected final EntityFactory entityFactory;

    public ConnInstanceDataBinderImpl(ConnIdBundleManager connIdBundleManager, ConnInstanceDAO connInstanceDAO, RealmSearchDAO realmSearchDAO, EntityFactory entityFactory) {
        this.connIdBundleManager = connIdBundleManager;
        this.connInstanceDAO = connInstanceDAO;
        this.realmSearchDAO = realmSearchDAO;
        this.entityFactory = entityFactory;
    }

    public ConnInstance getConnInstance(ConnInstanceTO connInstanceTO) {
        SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
        if (connInstanceTO.getLocation() == null) {
            sce.getElements().add("location");
        }
        if (connInstanceTO.getBundleName() == null) {
            sce.getElements().add("bundlename");
        }
        if (connInstanceTO.getVersion() == null) {
            sce.getElements().add("bundleversion");
        }
        if (connInstanceTO.getConnectorName() == null) {
            sce.getElements().add("connectorname");
        }
        if (connInstanceTO.getConf().isEmpty()) {
            sce.getElements().add("configuration");
        }
        ConnInstance connInstance = (ConnInstance)this.entityFactory.newEntity(ConnInstance.class);
        connInstance.setBundleName(connInstanceTO.getBundleName());
        connInstance.setConnectorName(connInstanceTO.getConnectorName());
        connInstance.setVersion(connInstanceTO.getVersion());
        connInstance.setDisplayName(connInstanceTO.getDisplayName());
        connInstance.setConnRequestTimeout(connInstanceTO.getConnRequestTimeout());
        connInstance.getCapabilities().addAll(connInstanceTO.getCapabilities());
        Optional.ofNullable(connInstanceTO.getAdminRealm()).ifPresent(r -> connInstance.setAdminRealm((Realm)this.realmSearchDAO.findByFullPath(r).orElse(null)));
        if (connInstance.getAdminRealm() == null) {
            sce.getElements().add("Invalid or null realm specified: " + connInstanceTO.getAdminRealm());
        }
        Optional.ofNullable(connInstanceTO.getLocation()).ifPresent(arg_0 -> ((ConnInstance)connInstance).setLocation(arg_0));
        connInstance.setConf(connInstanceTO.getConf());
        Optional.ofNullable(connInstanceTO.getPoolConf()).ifPresent(conf -> connInstance.setPoolConf(ConnPoolConfUtils.getConnPoolConf((ConnPoolConf)conf)));
        if (!sce.isEmpty()) {
            throw sce;
        }
        return connInstance;
    }

    public ConnInstance update(ConnInstanceTO connInstanceTO) {
        ConnInstance connInstance = Optional.ofNullable(this.connInstanceDAO.authFind(connInstanceTO.getKey())).orElseThrow(() -> new NotFoundException("Connector '" + connInstanceTO.getKey() + "'"));
        connInstance.getCapabilities().clear();
        connInstance.getCapabilities().addAll(connInstanceTO.getCapabilities());
        Optional.ofNullable(connInstanceTO.getAdminRealm()).ifPresent(r -> connInstance.setAdminRealm((Realm)this.realmSearchDAO.findByFullPath(r).orElseThrow(() -> {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
            sce.getElements().add("Invalid or null realm specified: " + connInstanceTO.getAdminRealm());
            return sce;
        })));
        Optional.ofNullable(connInstanceTO.getLocation()).ifPresent(arg_0 -> ((ConnInstance)connInstance).setLocation(arg_0));
        Optional.ofNullable(connInstanceTO.getBundleName()).ifPresent(arg_0 -> ((ConnInstance)connInstance).setBundleName(arg_0));
        Optional.ofNullable(connInstanceTO.getVersion()).ifPresent(arg_0 -> ((ConnInstance)connInstance).setVersion(arg_0));
        Optional.ofNullable(connInstanceTO.getConnectorName()).ifPresent(arg_0 -> ((ConnInstance)connInstance).setConnectorName(arg_0));
        Optional.ofNullable(connInstanceTO.getDisplayName()).ifPresent(arg_0 -> ((ConnInstance)connInstance).setDisplayName(arg_0));
        Optional.ofNullable(connInstanceTO.getConf()).filter(Predicate.not(Collection::isEmpty)).ifPresent(arg_0 -> ((ConnInstance)connInstance).setConf(arg_0));
        Optional.ofNullable(connInstanceTO.getConnRequestTimeout()).ifPresent(arg_0 -> ((ConnInstance)connInstance).setConnRequestTimeout(arg_0));
        Optional.ofNullable(connInstanceTO.getPoolConf()).ifPresentOrElse(conf -> connInstance.setPoolConf(ConnPoolConfUtils.getConnPoolConf((ConnPoolConf)conf)), () -> connInstance.setPoolConf(null));
        return connInstance;
    }

    public ConnConfPropSchema build(ConfigurationProperty property) {
        ConnConfPropSchema connConfPropSchema = new ConnConfPropSchema();
        connConfPropSchema.setName(property.getName());
        connConfPropSchema.setDisplayName(property.getDisplayName(property.getName()));
        connConfPropSchema.setHelpMessage(property.getHelpMessage(property.getName()));
        connConfPropSchema.setRequired(property.isRequired());
        connConfPropSchema.setType(property.getType().getName());
        connConfPropSchema.setOrder(((ConfigurationPropertyImpl)property).getOrder());
        connConfPropSchema.setConfidential(property.isConfidential());
        if (property.getValue() != null) {
            if (property.getValue().getClass().isArray()) {
                connConfPropSchema.getDefaultValues().addAll(List.of((Object[])property.getValue()));
            } else {
                Object object = property.getValue();
                if (object instanceof Collection) {
                    Collection collection = (Collection)object;
                    connConfPropSchema.getDefaultValues().addAll(collection);
                } else {
                    connConfPropSchema.getDefaultValues().add(property.getValue());
                }
            }
        }
        return connConfPropSchema;
    }

    public ConnInstanceTO getConnInstanceTO(ConnInstance connInstance) {
        ConnInstanceTO connInstanceTO = new ConnInstanceTO();
        connInstanceTO.setKey(connInstance.getKey());
        connInstanceTO.setBundleName(connInstance.getBundleName());
        connInstanceTO.setConnectorName(connInstance.getConnectorName());
        connInstanceTO.setVersion(connInstance.getVersion());
        connInstanceTO.setDisplayName(connInstance.getDisplayName());
        connInstanceTO.setConnRequestTimeout(connInstance.getConnRequestTimeout());
        connInstanceTO.setAdminRealm(connInstance.getAdminRealm().getFullPath());
        connInstanceTO.getCapabilities().addAll(connInstance.getCapabilities());
        connInstanceTO.getConf().addAll(connInstance.getConf());
        try {
            Pair info = this.connIdBundleManager.getConnectorInfo(connInstance);
            connInstanceTO.setLocation(((URI)info.getLeft()).toASCIIString());
            ConfigurationProperties properties = this.connIdBundleManager.getConfigurationProperties((ConnectorInfo)info.getRight());
            properties.getPropertyNames().forEach(propName -> {
                ConnConfPropSchema schema = this.build(properties.getProperty(propName));
                ConnConfProperty property = connInstanceTO.getConf(propName).orElseGet(() -> {
                    ConnConfProperty p = new ConnConfProperty();
                    connInstanceTO.getConf().add(p);
                    return p;
                });
                property.setSchema(schema);
            });
        }
        catch (Exception e) {
            LOG.error("Could not get ConnId information for {} / {}#{}#{}", new Object[]{connInstance.getLocation(), connInstance.getBundleName(), connInstance.getConnectorName(), connInstance.getVersion(), e});
            connInstanceTO.setErrored(true);
            connInstanceTO.setLocation(connInstance.getLocation());
        }
        connInstanceTO.setPoolConf(connInstance.getPoolConf());
        return connInstanceTO;
    }
}

