/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.authentication.principal;

import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.adaptors.x509.authentication.principal.AbstractX509PrincipalResolver;
import org.apereo.cas.adaptors.x509.authentication.principal.X509ExtractorUtils;
import org.apereo.cas.authentication.principal.resolvers.PrincipalResolutionContext;
import org.apereo.cas.util.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509SubjectAlternativeNameRFC822EmailPrincipalResolver
extends AbstractX509PrincipalResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(X509SubjectAlternativeNameRFC822EmailPrincipalResolver.class);

    public X509SubjectAlternativeNameRFC822EmailPrincipalResolver(PrincipalResolutionContext context) {
        super(context);
    }

    @Override
    protected String resolvePrincipalInternal(X509Certificate certificate) {
        LOGGER.debug("Resolving principal from Subject Alternative Name RFC8222 type (email) for [{}]", (Object)certificate);
        try {
            Collection<List<?>> subjectAltNames = certificate.getSubjectAlternativeNames();
            Optional<String> email = X509ExtractorUtils.getRFC822EmailAddress(subjectAltNames);
            if (email.isPresent()) {
                return email.get();
            }
        }
        catch (CertificateParsingException e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        return this.getAlternatePrincipal(certificate);
    }

    @Override
    @Generated
    public String toString() {
        return "X509SubjectAlternativeNameRFC822EmailPrincipalResolver(super=" + super.toString() + ")";
    }
}

