/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.coordinator.group.CommitRecordMetadataAndOffset;
import kafka.coordinator.group.CompletingRebalance$;
import kafka.coordinator.group.Dead$;
import kafka.coordinator.group.Empty$;
import kafka.coordinator.group.GroupMetadata;
import kafka.coordinator.group.GroupState;
import kafka.coordinator.group.JoinGroupResult;
import kafka.coordinator.group.JoinGroupResult$;
import kafka.coordinator.group.MemberMetadata;
import kafka.coordinator.group.MemberMetadata$;
import kafka.coordinator.group.PreparingRebalance$;
import kafka.coordinator.group.Stable$;
import kafka.coordinator.group.SyncGroupResult;
import kafka.coordinator.group.SyncGroupResult$;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SetOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t%d\u0001B)S\u0001eCQ\u0001\u0019\u0001\u0005\u0002\u0005Dq\u0001\u001a\u0001C\u0002\u0013%Q\r\u0003\u0004o\u0001\u0001\u0006IA\u001a\u0005\b_\u0002\u0011\r\u0011\"\u0003f\u0011\u0019\u0001\b\u0001)A\u0005M\"9\u0011\u000f\u0001b\u0001\n\u0013)\u0007B\u0002:\u0001A\u0003%a\rC\u0004t\u0001\t\u0007I\u0011B3\t\rQ\u0004\u0001\u0015!\u0003g\u0011\u001d)\bA1A\u0005\n\u0015DaA\u001e\u0001!\u0002\u00131\u0007bB<\u0001\u0005\u0004%I\u0001\u001f\u0005\u0007y\u0002\u0001\u000b\u0011B=\t\u000fu\u0004!\u0019!C\u0005q\"1a\u0010\u0001Q\u0001\neD\u0011b\u0015\u0001A\u0002\u0003\u0007I\u0011B@\t\u0017\u0005\u001d\u0001\u00011AA\u0002\u0013%\u0011\u0011\u0002\u0005\f\u0003+\u0001\u0001\u0019!A!B\u0013\t\t\u0001C\u0004\u0002\u0018\u0001!\t!!\u0007\t\u000f\u0005U\u0002\u0001\"\u0001\u0002\u001a!9\u0011q\b\u0001\u0005\u0002\u0005e\u0001bBA\"\u0001\u0011\u0005\u0011\u0011\u0004\u0005\b\u0003\u000f\u0002A\u0011AA\r\u0011\u001d\tY\u0005\u0001C\u0001\u00033Aq!a\u0014\u0001\t\u0003\tI\u0002C\u0004\u0002T\u0001!\t!!\u0007\t\u000f\u0005]\u0003\u0001\"\u0001\u0002\u001a!9\u00111\f\u0001\u0005\u0002\u0005e\u0001bBA0\u0001\u0011\u0005\u0011\u0011\u0004\u0005\b\u0003G\u0002A\u0011AA\r\u0011\u001d\t9\u0007\u0001C\u0001\u00033Aq!a\u001b\u0001\t\u0003\tI\u0002C\u0004\u0002p\u0001!\t!!\u0007\t\u000f\u0005M\u0004\u0001\"\u0001\u0002\u001a!9\u0011q\u000f\u0001\u0005\u0002\u0005e\u0001bBA>\u0001\u0011\u0005\u0011\u0011\u0004\u0005\b\u0003\u007f\u0002A\u0011AA\r\u0011\u001d\t\u0019\t\u0001C\u0001\u00033Aq!a\"\u0001\t\u0003\tI\u0002C\u0004\u0002\f\u0002!\t!!\u0007\t\u000f\u0005=\u0005\u0001\"\u0001\u0002\u001a!9\u00111\u0013\u0001\u0005\u0002\u0005e\u0001bBAL\u0001\u0011\u0005\u0011\u0011\u0004\u0005\b\u00037\u0003A\u0011AA\r\u0011\u001d\ty\n\u0001C\u0001\u00033Aq!a)\u0001\t\u0003\tI\u0002C\u0004\u0002(\u0002!\t!!\u0007\t\u000f\u0005-\u0006\u0001\"\u0001\u0002\u001a!9\u0011q\u0016\u0001\u0005\u0002\u0005e\u0001bBAZ\u0001\u0011\u0005\u0011\u0011\u0004\u0005\b\u0003o\u0003A\u0011AA\r\u0011\u001d\tY\f\u0001C\u0001\u00033Aq!a0\u0001\t\u0003\tI\u0002C\u0004\u0002D\u0002!\t!!\u0007\t\u000f\u0005\u001d\u0007\u0001\"\u0001\u0002\u001a!9\u00111\u001a\u0001\u0005\u0002\u0005e\u0001bBAh\u0001\u0011\u0005\u0011\u0011\u0004\u0005\b\u0003'\u0004A\u0011AA\r\u0011\u001d\t9\u000e\u0001C\u0001\u00033Aq!a7\u0001\t\u0003\tI\u0002C\u0004\u0002`\u0002!\t!!\u0007\t\u000f\u0005\r\b\u0001\"\u0001\u0002\u001a!9\u0011q\u001d\u0001\u0005\u0002\u0005e\u0001bBAv\u0001\u0011\u0005\u0011\u0011\u0004\u0005\b\u0003_\u0004A\u0011AA\r\u0011\u001d\t\u0019\u0010\u0001C\u0001\u00033Aq!a>\u0001\t\u0003\tI\u0002C\u0004\u0002|\u0002!\t!!\u0007\t\u000f\u0005}\b\u0001\"\u0001\u0002\u001a!9!1\u0001\u0001\u0005\u0002\u0005e\u0001b\u0002B\u0004\u0001\u0011\u0005\u0011\u0011\u0004\u0005\b\u0005\u0017\u0001A\u0011AA\r\u0011\u001d\u0011y\u0001\u0001C\u0001\u00033AqAa\u0005\u0001\t\u0003\tI\u0002C\u0004\u0003\u0018\u0001!\t!!\u0007\t\u000f\tm\u0001\u0001\"\u0001\u0002\u001a!9!q\u0004\u0001\u0005\u0002\u0005e\u0001b\u0002B\u0012\u0001\u0011%!Q\u0005\u0005\b\u0005g\u0001A\u0011\u0002B\u001b\u0011%\u0011\t\u0006AI\u0001\n\u0013\u0011\u0019FA\tHe>,\b/T3uC\u0012\fG/\u0019+fgRT!a\u0015+\u0002\u000b\u001d\u0014x.\u001e9\u000b\u0005U3\u0016aC2p_J$\u0017N\\1u_JT\u0011aV\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\f\u0005\u0002\\=6\tALC\u0001^\u0003\u0015\u00198-\u00197b\u0013\tyFL\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\t\u0004\"a\u0019\u0001\u000e\u0003I\u000bA\u0002\u001d:pi>\u001cw\u000e\u001c+za\u0016,\u0012A\u001a\t\u0003O2l\u0011\u0001\u001b\u0006\u0003S*\fA\u0001\\1oO*\t1.\u0001\u0003kCZ\f\u0017BA7i\u0005\u0019\u0019FO]5oO\u0006i\u0001O]8u_\u000e|G\u000eV=qK\u0002\nqb\u001a:pkBLen\u001d;b]\u000e,\u0017\nZ\u0001\u0011OJ|W\u000f]%ogR\fgnY3JI\u0002\n\u0001\"\\3nE\u0016\u0014\u0018\nZ\u0001\n[\u0016l'-\u001a:JI\u0002\n\u0001b\u00197jK:$\u0018\nZ\u0001\nG2LWM\u001c;JI\u0002\n!b\u00197jK:$\bj\\:u\u0003-\u0019G.[3oi\"{7\u000f\u001e\u0011\u0002%I,'-\u00197b]\u000e,G+[7f_V$Xj]\u000b\u0002sB\u00111L_\u0005\u0003wr\u00131!\u00138u\u0003M\u0011XMY1mC:\u001cW\rV5nK>,H/T:!\u0003A\u0019Xm]:j_:$\u0016.\\3pkRl5/A\ttKN\u001c\u0018n\u001c8US6,w.\u001e;Ng\u0002*\"!!\u0001\u0011\u0007\r\f\u0019!C\u0002\u0002\u0006I\u0013Qb\u0012:pkBlU\r^1eCR\f\u0017!C4s_V\u0004x\fJ3r)\u0011\tY!!\u0005\u0011\u0007m\u000bi!C\u0002\u0002\u0010q\u0013A!\u00168ji\"I\u00111C\t\u0002\u0002\u0003\u0007\u0011\u0011A\u0001\u0004q\u0012\n\u0014AB4s_V\u0004\b%A\u0003tKR,\u0006\u000f\u0006\u0002\u0002\f!\u001a1#!\b\u0011\t\u0005}\u0011\u0011G\u0007\u0003\u0003CQA!a\t\u0002&\u0005\u0019\u0011\r]5\u000b\t\u0005\u001d\u0012\u0011F\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\tY#!\f\u0002\u000b),h.\u001b;\u000b\u0005\u0005=\u0012aA8sO&!\u00111GA\u0011\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u001bi\u0016\u001cHoQ1o%\u0016\u0014\u0017\r\\1oG\u0016<\u0006.\u001a8Ti\u0006\u0014G.\u001a\u0015\u0004)\u0005e\u0002\u0003BA\u0010\u0003wIA!!\u0010\u0002\"\t!A+Z:u\u0003\u001d\"Xm\u001d;DC:\u0014VMY1mC:\u001cWm\u00165f]\u000e{W\u000e\u001d7fi&twMU3cC2\fgnY3)\u0007U\tI$A\u0015uKN$8)\u00198o_R\u0014VMY1mC:\u001cWm\u00165f]B\u0013X\r]1sS:<'+\u001a2bY\u0006t7-\u001a\u0015\u0004-\u0005e\u0012a\u0007;fgR\u001c\u0015M\u001c8piJ+'-\u00197b]\u000e,w\u000b[3o\t\u0016\fG\rK\u0002\u0018\u0003s\t\u0001\u0006^3tiN#\u0018M\u00197f)>\u0004&/\u001a9be&twMU3cC2\fgnY3Ue\u0006t7/\u001b;j_:D3\u0001GA\u001d\u0003i!Xm\u001d;Ti\u0006\u0014G.\u001a+p\t\u0016\fG\r\u0016:b]NLG/[8oQ\rI\u0012\u0011H\u00014i\u0016\u001cH/Q<bSRLgn\u001a*fE\u0006d\u0017M\\2f)>\u0004&/\u001a9be&twMU3cC2\fgnY3Ue\u0006t7/\u001b;j_:D3AGA\u001d\u0003\u0019\"Xm\u001d;Qe\u0016\u0004\u0018M]5oOJ+'-\u00197b]\u000e,Gk\u001c#fC\u0012$&/\u00198tSRLwN\u001c\u0015\u00047\u0005e\u0012a\n;fgR\u0004&/\u001a9be&twMU3cC2\fgnY3U_\u0016k\u0007\u000f^=Ue\u0006t7/\u001b;j_:D3\u0001HA\u001d\u0003e!Xm\u001d;F[B$\u0018\u0010V8EK\u0006$GK]1og&$\u0018n\u001c8)\u0007u\tI$A\u0014uKN$\u0018i^1ji&twMU3cC2\fgnY3U_N#\u0018M\u00197f)J\fgn]5uS>t\u0007f\u0001\u0010\u0002:\u0005\u0011C/Z:u\u000b6\u0004H/\u001f+p'R\f'\r\\3JY2,w-\u00197Ue\u0006t7/\u001b;j_:D3aHA\u001d\u0003\r\"Xm\u001d;Ti\u0006\u0014G.\u001a+p'R\f'\r\\3JY2,w-\u00197Ue\u0006t7/\u001b;j_:D3\u0001IA\u001d\u00035\"Xm\u001d;F[B$\u0018\u0010V8Bo\u0006LG/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016LE\u000e\\3hC2$&/\u00198tSRLwN\u001c\u0015\u0004C\u0005e\u0012a\u000f;fgR\u0004&/\u001a9be&twMU3cC2\fgnY3U_B\u0013X\r]1sS:<'+\u001a2bY\u0006t7-Z%mY\u0016<\u0017\r\u001c+sC:\u001c\u0018\u000e^5p]\"\u001a!%!\u000f\u0002_Q,7\u000f\u001e)sKB\f'/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$vn\u0015;bE2,\u0017\n\u001c7fO\u0006dGK]1og&$\u0018n\u001c8)\u0007\r\nI$A\u001duKN$\u0018i^1ji&twMU3cC2\fgnY3U_\u0006;\u0018-\u001b;j]\u001e\u0014VMY1mC:\u001cW-\u00137mK\u001e\fG\u000e\u0016:b]NLG/[8oQ\r!\u0013\u0011H\u0001 i\u0016\u001cH\u000fR3bIR{G)Z1e\u00132dWmZ1m)J\fgn]5uS>t\u0007fA\u0013\u0002:\u0005\tC/Z:u\t\u0016\fG\rV8Ti\u0006\u0014G.Z%mY\u0016<\u0017\r\u001c+sC:\u001c\u0018\u000e^5p]\"\u001aa%!\u000f\u0002[Q,7\u000f\u001e#fC\u0012$v\u000e\u0015:fa\u0006\u0014\u0018N\\4SK\n\fG.\u00198dK&cG.Z4bYR\u0013\u0018M\\:ji&|g\u000eK\u0002(\u0003s\tA\u0006^3ti\u0012+\u0017\r\u001a+p\u0003^\f\u0017\u000e^5oOJ+'-\u00197b]\u000e,\u0017\n\u001c7fO\u0006dGK]1og&$\u0018n\u001c8)\u0007!\nI$\u0001\nuKN$8+\u001a7fGR\u0004&o\u001c;pG>d\u0007fA\u0015\u0002:\u0005\u0019C/Z:u'\u0016dWm\u0019;Qe>$xnY8m%\u0006L7/Z:JM:{W*Z7cKJ\u001c\bf\u0001\u0016\u0002:\u0005YC/Z:u'\u0016dWm\u0019;Qe>$xnY8m\u0007\"|wn]3t\u0007>l\u0007/\u0019;jE2,\u0007K]8u_\u000e|G\u000eK\u0002,\u0003s\tQ\u0003^3tiN+\b\u000f]8siN\u0004&o\u001c;pG>d7\u000fK\u0002-\u0003s\tA\u0007^3ti>3gm]3u%\u0016lwN^1m\tV\u0014\u0018N\\4Ue\u0006t7/\u001b;j_:4%o\\7F[B$\u0018\u0010V8O_:,U\u000e\u001d;zQ\ri\u0013\u0011H\u0001\u0015i\u0016\u001cHoU;cg\u000e\u0014\u0018NY3e)>\u0004\u0018nY:)\u00079\nI$\u0001\u0013uKN$8+\u001e2tGJL'-\u001a3U_BL7m\u001d(p]\u000e{gn];nKJ<%o\\;qQ\ry\u0013\u0011H\u0001\u0017i\u0016\u001cH/\u00138ji:+\u0007\u0010^$f]\u0016\u0014\u0018\r^5p]\"\u001a\u0001'!\u000f\u0002AQ,7\u000f^%oSRtU\r\u001f;HK:,'/\u0019;j_:,U\u000e\u001d;z\u000fJ|W\u000f\u001d\u0015\u0004c\u0005e\u0012\u0001\u0005;fgR|eMZ:fi\u000e{W.\\5uQ\r\u0011\u0014\u0011H\u0001\u0018i\u0016\u001cHo\u00144gg\u0016$8i\\7nSR4\u0015-\u001b7ve\u0016D3aMA\u001d\u0003%\"Xm\u001d;PM\u001a\u001cX\r^\"p[6LGOR1jYV\u0014XmV5uQ\u0006sw\u000e\u001e5feB+g\u000eZ5oO\"\u001aA'!\u000f\u0002EQ,7\u000f^(gMN,GoQ8n[&$x+\u001b;i\u0003:|G\u000f[3s!\u0016tG-\u001b8hQ\r)\u0014\u0011H\u0001+i\u0016\u001cHoQ8ogVlWM\u001d\"fCR\u001cHK]1og\u0006\u001cG/[8oC2|eMZ:fi\u000e{W.\\5uQ\r1\u0014\u0011H\u0001)i\u0016\u001cH\u000f\u0016:b]N\f7\r^5p]\n+\u0017\r^:D_:\u001cX/\\3s\u001f\u001a47/\u001a;D_6l\u0017\u000e\u001e\u0015\u0004o\u0005e\u0012!\u000e;fgR$&/\u00198tC\u000e$\u0018n\u001c8bY\u000e{W.\\5u\u0013N\f%m\u001c:uK\u0012\fe\u000eZ\"p]N,X.\u001a:D_6l\u0017\u000e^,j]ND3\u0001OA\u001d\u00035\"Xm\u001d;GC&dW\r\u001a+y]>3gm]3u\u0007>lW.\u001b;MK\u00064Xm\u001d(p!\u0016tG-\u001b8h'R\fG/\u001a\u0015\u0004s\u0005e\u0012\u0001\u0005;fgR,\u0006\u000fZ1uK6+WNY3sQ\rQ\u0014\u0011H\u0001.i\u0016\u001cHOU3qY\u0006\u001cWm\u0012:pkBLen\u001d;b]\u000e,w+\u001b;i\u001d>tW\t_5ti&tw-T3nE\u0016\u0014\bfA\u001e\u0002:\u0005AB/Z:u%\u0016\u0004H.Y2f\u000fJ|W\u000f]%ogR\fgnY3)\u0007q\nI$\u0001\fuKN$\u0018J\u001c<pW\u0016Tu.\u001b8DC2d'-Y2lQ\ri\u0014\u0011H\u0001\u001ci\u0016\u001cH/\u00138w_.,'j\\5o\u0007\u0006dGNY1dW\u001a\u000b\u0017\u000e\\:)\u0007y\nI$A\ruKN$hj\u001c;J]Z|7.\u001a&pS:\u001c\u0015\r\u001c7cC\u000e\\\u0007fA \u0002:\u0005YB/Z:u\u0013:4xn[3Ts:\u001c7)\u00197mE\u0006\u001c7NR1jYND3\u0001QA\u001d\u0003Y!Xm\u001d;J]Z|7.Z*z]\u000e\u001c\u0015\r\u001c7cC\u000e\\\u0007fA!\u0002:\u0005IB/Z:u\u001d>$\u0018J\u001c<pW\u0016\u001c\u0016P\\2DC2d'-Y2lQ\r\u0011\u0015\u0011H\u0001\u001ci\u0016\u001cH\u000fS1t!\u0016tG-\u001b8h\u001d>tG\u000b\u001f8PM\u001a\u001cX\r^:)\u0007\r\u000bI$\u0001\ruKN$\b*Y:QK:$\u0017N\\4Uq:|eMZ:fiND3\u0001RA\u001d\u0003\t\"Xm\u001d;DC:tw\u000e^!eIB+g\u000eZ5oO6+WNY3s\u0013\u001a\u001cF/\u00192mK\"\u001aQ)!\u000f\u0002SQ,7\u000f\u001e*f[>4\u0018\r\u001c$s_6\u0004VM\u001c3j]\u001e\fe\r^3s\u001b\u0016l'-\u001a:JgN#\u0018M\u00197fQ\r1\u0015\u0011H\u0001*i\u0016\u001cHOU3n_Z\fGN\u0012:p[B+g\u000eZ5oO^CWM\\'f[\n,'/S:SK6|g/\u001a3)\u0007\u001d\u000bI$A\u0015uKN$8)\u00198o_R\fE\rZ*uCRL7-T3nE\u0016\u0014\u0018JZ!me\u0016\fG-\u001f)sKN,g\u000e\u001e\u0015\u0004\u0011\u0006e\u0012a\n;fgR\u001c\u0015M\u001c8pi\u0006#G\rU3oI&twmU=oG>3WK\\6o_^tW*Z7cKJD3!SA\u001d\u0003)\"Xm\u001d;DC:tw\u000e\u001e*f[>4X\rU3oI&twmU=oG>3WK\\6o_^tW*Z7cKJD3ASA\u001d\u0003\u0011\"Xm\u001d;DC:\fE\rZ!oIJ+Wn\u001c<f!\u0016tG-\u001b8h'ft7-T3nE\u0016\u0014\bfA&\u0002:\u0005iC/Z:u%\u0016lwN^1m\rJ|W\u000eU3oI&twmU=oG^CWM\\'f[\n,'/S:SK6|g/\u001a3)\u00071\u000bI$A\u0015uKN$h*Z<HK:,'/\u0019;j_:\u001cE.Z1sgB+g\u000eZ5oONKhnY'f[\n,'o\u001d\u0015\u0004\u001b\u0006e\u0012aC1tg\u0016\u0014Ho\u0015;bi\u0016$b!a\u0003\u0003(\t%\u0002BB*O\u0001\u0004\t\t\u0001C\u0004\u0003,9\u0003\rA!\f\u0002\u0017Q\f'oZ3u'R\fG/\u001a\t\u0004G\n=\u0012b\u0001B\u0019%\nQqI]8vaN#\u0018\r^3\u0002#=4gm]3u\u0003:$W*\u001a;bI\u0006$\u0018\r\u0006\u0004\u00038\t\r#Q\n\t\u0005\u0005s\u0011y$\u0004\u0002\u0003<)\u0019!Q\b,\u0002\r\r|W.\\8o\u0013\u0011\u0011\tEa\u000f\u0003#=3gm]3u\u0003:$W*\u001a;bI\u0006$\u0018\rC\u0004\u0003F=\u0003\rAa\u0012\u0002\r=4gm]3u!\rY&\u0011J\u0005\u0004\u0005\u0017b&\u0001\u0002'p]\u001eD\u0011Ba\u0014P!\u0003\u0005\rAa\u0012\u0002\u0013QLW.Z:uC6\u0004\u0018aG8gMN,G/\u00118e\u001b\u0016$\u0018\rZ1uC\u0012\"WMZ1vYR$#'\u0006\u0002\u0003V)\"!q\tB,W\t\u0011I\u0006\u0005\u0003\u0003\\\t\u0015TB\u0001B/\u0015\u0011\u0011yF!\u0019\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B29\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u001d$Q\f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class GroupMetadataTest {
    private final String protocolType;
    private final String groupInstanceId;
    private final String memberId;
    private final String clientId;
    private final String clientHost;
    private final int rebalanceTimeoutMs;
    private final int sessionTimeoutMs;
    private GroupMetadata group;

    private String protocolType() {
        return this.protocolType;
    }

    private String groupInstanceId() {
        return this.groupInstanceId;
    }

    private String memberId() {
        return this.memberId;
    }

    private String clientId() {
        return this.clientId;
    }

    private String clientHost() {
        return this.clientHost;
    }

    private int rebalanceTimeoutMs() {
        return this.rebalanceTimeoutMs;
    }

    private int sessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    private GroupMetadata group() {
        return this.group;
    }

    private void group_$eq(GroupMetadata x$1) {
        this.group = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.group_$eq(new GroupMetadata("groupId", (GroupState)Empty$.MODULE$, Time.SYSTEM));
    }

    @Test
    public void testCanRebalanceWhenStable() {
        Assertions.assertTrue((boolean)this.group().canRebalance());
    }

    @Test
    public void testCanRebalanceWhenCompletingRebalance() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        Assertions.assertTrue((boolean)this.group().canRebalance());
    }

    @Test
    public void testCannotRebalanceWhenPreparingRebalance() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assertions.assertFalse((boolean)this.group().canRebalance());
    }

    @Test
    public void testCannotRebalanceWhenDead() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assertions.assertFalse((boolean)this.group().canRebalance());
    }

    @Test
    public void testStableToPreparingRebalanceTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.assertState(this.group(), (GroupState)PreparingRebalance$.MODULE$);
    }

    @Test
    public void testStableToDeadTransition() {
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testAwaitingRebalanceToPreparingRebalanceTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.assertState(this.group(), (GroupState)PreparingRebalance$.MODULE$);
    }

    @Test
    public void testPreparingRebalanceToDeadTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testPreparingRebalanceToEmptyTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.assertState(this.group(), (GroupState)Empty$.MODULE$);
    }

    @Test
    public void testEmptyToDeadTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testAwaitingRebalanceToStableTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
        this.assertState(this.group(), (GroupState)Stable$.MODULE$);
    }

    @Test
    public void testEmptyToStableIllegalTransition() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)Stable$.MODULE$));
    }

    @Test
    public void testStableToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)Stable$.MODULE$));
    }

    @Test
    public void testEmptyToAwaitingRebalanceIllegalTransition() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$));
    }

    @Test
    public void testPreparingRebalanceToPreparingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$));
    }

    @Test
    public void testPreparingRebalanceToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)Stable$.MODULE$));
    }

    @Test
    public void testAwaitingRebalanceToAwaitingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$));
    }

    @Test
    public void testDeadToDeadIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testDeadToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)Stable$.MODULE$));
    }

    @Test
    public void testDeadToPreparingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$));
    }

    @Test
    public void testDeadToAwaitingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$));
    }

    @Test
    public void testSelectProtocol() {
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        Assertions.assertEquals((Object)"range", (Object)this.group().selectProtocol());
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(otherMember, x$4);
        Assertions.assertTrue((boolean)((SetOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"range", "roundrobin"}))).apply((Object)this.group().selectProtocol()));
        String lastMemberId = "lastMemberId";
        MemberMetadata lastMember = new MemberMetadata(lastMemberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$3 = this.group();
        Function1 x$6 = qual$3.add$default$2();
        qual$3.add(lastMember, x$6);
        Assertions.assertEquals((Object)"roundrobin", (Object)this.group().selectProtocol());
    }

    @Test
    public void testSelectProtocolRaisesIfNoMembers() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().selectProtocol());
    }

    @Test
    public void testSelectProtocolChoosesCompatibleProtocol() {
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"blah", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(otherMember, x$4);
        Assertions.assertEquals((Object)"roundrobin", (Object)this.group().selectProtocol());
    }

    @Test
    public void testSupportsProtocols() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        Assertions.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "range"}))));
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assertions.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assertions.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"range", "foo"}))));
        Assertions.assertFalse((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))));
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"blah", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(otherMember, x$4);
        Assertions.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assertions.assertFalse((boolean)this.group().supportsProtocols("invalid_type", (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assertions.assertFalse((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"range", "foo"}))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOffsetRemovalDuringTransitionFromEmptyToNonEmpty() {
        void offsetAndMetadata_timestamp;
        String topic = "foo";
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, topic);
        MockTime time = new MockTime();
        this.group_$eq(new GroupMetadata("groupId", (GroupState)Empty$.MODULE$, (Time)time));
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", (Object)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()), (short)3).array()), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)new Some(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))), (Object)this.group().getSubscribedTopics());
        long l = time.milliseconds();
        long offsetAndMetadata_offset = 37L;
        OffsetAndMetadata offset = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset, "", (long)offsetAndMetadata_timestamp);
        int commitRecordOffset = 3;
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)offset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(topicIdPartition.topicPartition()));
        this.group().onOffsetCommitAppend(topicIdPartition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)commitRecordOffset)), offset));
        long offsetRetentionMs = 50000L;
        time.sleep(offsetRetentionMs + 1L);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().remove(this.memberId());
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)Empty$.MODULE$, (Object)this.group().currentState());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)this.group().removeExpiredOffsets(time.milliseconds(), offsetRetentionMs));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(member, x$4);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)this.group().removeExpiredOffsets(time.milliseconds(), offsetRetentionMs));
    }

    @Test
    public void testSubscribedTopics() {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", (Object)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()), (short)3).array()), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)new Some(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))), (Object)this.group().getSubscribedTopics());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().remove(memberId);
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)new Some((Object)Predef$.MODULE$.Set().empty()), (Object)this.group().getSubscribedTopics());
        MemberMetadata memberWithFaultyProtocol = new MemberMetadata(memberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(memberWithFaultyProtocol, x$4);
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
    }

    @Test
    public void testSubscribedTopicsNonConsumerGroup() {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), "My Protocol", (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
    }

    @Test
    public void testInitNextGeneration() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        member.supportedProtocols_$eq((List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().add(member, (Function1 & Serializable)x$2 -> {
            GroupMetadataTest.$anonfun$testInitNextGeneration$1(x$2);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)0, (int)this.group().generationId());
        Assertions.assertNull((Object)this.group().protocolName().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.group().initNextGeneration();
        Assertions.assertEquals((int)1, (int)this.group().generationId());
        Assertions.assertEquals((Object)"roundrobin", (Object)this.group().protocolName().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    @Test
    public void testInitNextGenerationEmptyGroup() {
        Assertions.assertEquals((Object)Empty$.MODULE$, (Object)this.group().currentState());
        Assertions.assertEquals((int)0, (int)this.group().generationId());
        Assertions.assertNull((Object)this.group().protocolName().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().initNextGeneration();
        Assertions.assertEquals((int)1, (int)this.group().generationId());
        Assertions.assertNull((Object)this.group().protocolName().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOffsetCommit() {
        void offsetAndMetadata_timestamp;
        TopicIdPartition partition = new TopicIdPartition(Uuid.randomUuid(), 0, "foo");
        long l = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset = 37L;
        OffsetAndMetadata offset = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset, "", (long)offsetAndMetadata_timestamp);
        int commitRecordOffset = 3;
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition.topicPartition()));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)commitRecordOffset)), offset));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)offset), (Object)this.group().offset(partition.topicPartition()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOffsetCommitFailure() {
        void offsetAndMetadata_timestamp;
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "foo");
        long l = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset = 37L;
        OffsetAndMetadata offset = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset, "", (long)offsetAndMetadata_timestamp);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)offset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)offset), (Object)this.group().pendingOffsetCommit(topicIdPartition));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(topicIdPartition.topicPartition()));
        this.group().failPendingOffsetWrite(topicIdPartition, offset);
        Assertions.assertFalse((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().pendingOffsetCommit(topicIdPartition));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(topicIdPartition.topicPartition()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOffsetCommitFailureWithAnotherPending() {
        void offsetAndMetadata_timestamp;
        void offsetAndMetadata_timestamp2;
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "foo");
        long l = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset = 37L;
        OffsetAndMetadata firstOffset = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset, "", (long)offsetAndMetadata_timestamp2);
        long l2 = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset2 = 57L;
        OffsetAndMetadata secondOffset = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset2, "", (long)offsetAndMetadata_timestamp);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)firstOffset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)firstOffset), (Object)this.group().pendingOffsetCommit(topicIdPartition));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(topicIdPartition.topicPartition()));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)secondOffset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().pendingOffsetCommit(topicIdPartition));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(topicIdPartition.topicPartition()));
        this.group().failPendingOffsetWrite(topicIdPartition, firstOffset);
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().pendingOffsetCommit(topicIdPartition));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(topicIdPartition.topicPartition()));
        this.group().onOffsetCommitAppend(topicIdPartition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), secondOffset));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().pendingOffsetCommit(topicIdPartition));
        Assertions.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().offset(topicIdPartition.topicPartition()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOffsetCommitWithAnotherPending() {
        void offsetAndMetadata_timestamp;
        void offsetAndMetadata_timestamp2;
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "foo");
        long l = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset = 37L;
        OffsetAndMetadata firstOffset = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset, "", (long)offsetAndMetadata_timestamp2);
        long l2 = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset2 = 57L;
        OffsetAndMetadata secondOffset = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset2, "", (long)offsetAndMetadata_timestamp);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)firstOffset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)firstOffset), (Object)this.group().pendingOffsetCommit(topicIdPartition));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(topicIdPartition.topicPartition()));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)secondOffset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().pendingOffsetCommit(topicIdPartition));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(topicIdPartition.topicPartition()));
        this.group().onOffsetCommitAppend(topicIdPartition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), firstOffset));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().pendingOffsetCommit(topicIdPartition));
        Assertions.assertEquals((Object)new Some((Object)firstOffset), (Object)this.group().offset(topicIdPartition.topicPartition()));
        this.group().onOffsetCommitAppend(topicIdPartition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)5L)), secondOffset));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().pendingOffsetCommit(topicIdPartition));
        Assertions.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().offset(topicIdPartition.topicPartition()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConsumerBeatsTransactionalOffsetCommit() {
        void offsetAndMetadata_timestamp;
        void offsetAndMetadata_timestamp2;
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "foo");
        long producerId = 13232L;
        long l = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset = 37L;
        OffsetAndMetadata txnOffsetCommit = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset, "", (long)offsetAndMetadata_timestamp2);
        long l2 = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset2 = 57L;
        OffsetAndMetadata consumerOffsetCommit = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset2, "", (long)offsetAndMetadata_timestamp);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)txnOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)new CommitRecordMetadataAndOffset((Option)None$.MODULE$, txnOffsetCommit)), (Object)this.group().pendingTxnOffsetCommit(producerId, topicIdPartition));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(topicIdPartition.topicPartition()));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)consumerOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().pendingOffsetCommit(topicIdPartition));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(topicIdPartition.topicPartition()));
        this.group().onTxnOffsetCommitAppend(producerId, topicIdPartition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), txnOffsetCommit));
        this.group().onOffsetCommitAppend(topicIdPartition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), consumerOffsetCommit));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), txnOffsetCommit)), (Object)this.group().pendingTxnOffsetCommit(producerId, topicIdPartition));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().pendingOffsetCommit(topicIdPartition));
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(topicIdPartition.topicPartition()));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().pendingTxnOffsetCommit(producerId, topicIdPartition));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().pendingOffsetCommit(topicIdPartition));
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(topicIdPartition.topicPartition()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTransactionBeatsConsumerOffsetCommit() {
        void offsetAndMetadata_timestamp;
        void offsetAndMetadata_timestamp2;
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "foo");
        long producerId = 13232L;
        long l = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset = 37L;
        OffsetAndMetadata txnOffsetCommit = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset, "", (long)offsetAndMetadata_timestamp2);
        long l2 = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset2 = 57L;
        OffsetAndMetadata consumerOffsetCommit = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset2, "", (long)offsetAndMetadata_timestamp);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)txnOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)new CommitRecordMetadataAndOffset((Option)None$.MODULE$, txnOffsetCommit)), (Object)this.group().pendingTxnOffsetCommit(producerId, topicIdPartition));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(topicIdPartition.topicPartition()));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)consumerOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().pendingOffsetCommit(topicIdPartition));
        this.group().onOffsetCommitAppend(topicIdPartition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), consumerOffsetCommit));
        this.group().onTxnOffsetCommitAppend(producerId, topicIdPartition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), txnOffsetCommit));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), txnOffsetCommit)), (Object)this.group().pendingTxnOffsetCommit(producerId, topicIdPartition));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().pendingOffsetCommit(topicIdPartition));
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(topicIdPartition.topicPartition()));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().pendingTxnOffsetCommit(producerId, topicIdPartition));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().pendingOffsetCommit(topicIdPartition));
        Assertions.assertEquals((Object)new Some((Object)txnOffsetCommit), (Object)this.group().offset(topicIdPartition.topicPartition()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTransactionalCommitIsAbortedAndConsumerCommitWins() {
        void offsetAndMetadata_timestamp;
        void offsetAndMetadata_timestamp2;
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "foo");
        long producerId = 13232L;
        long l = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset = 37L;
        OffsetAndMetadata txnOffsetCommit = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset, "", (long)offsetAndMetadata_timestamp2);
        long l2 = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset2 = 57L;
        OffsetAndMetadata consumerOffsetCommit = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset2, "", (long)offsetAndMetadata_timestamp);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)txnOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(topicIdPartition.topicPartition()));
        Assertions.assertEquals((Object)new Some((Object)new CommitRecordMetadataAndOffset((Option)None$.MODULE$, txnOffsetCommit)), (Object)this.group().pendingTxnOffsetCommit(producerId, topicIdPartition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)consumerOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(topicIdPartition.topicPartition()));
        Assertions.assertEquals((Object)new Some((Object)new CommitRecordMetadataAndOffset((Option)None$.MODULE$, txnOffsetCommit)), (Object)this.group().pendingTxnOffsetCommit(producerId, topicIdPartition));
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().pendingOffsetCommit(topicIdPartition));
        this.group().onOffsetCommitAppend(topicIdPartition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), consumerOffsetCommit));
        this.group().onTxnOffsetCommitAppend(producerId, topicIdPartition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), txnOffsetCommit));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), txnOffsetCommit)), (Object)this.group().pendingTxnOffsetCommit(producerId, topicIdPartition));
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(topicIdPartition.topicPartition()));
        this.group().completePendingTxnOffsetCommit(producerId, false);
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().pendingTxnOffsetCommit(producerId, topicIdPartition));
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(topicIdPartition.topicPartition()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFailedTxnOffsetCommitLeavesNoPendingState() {
        void offsetAndMetadata_timestamp;
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "foo");
        long producerId = 13232L;
        long l = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset = 37L;
        OffsetAndMetadata txnOffsetCommit = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset, "", (long)offsetAndMetadata_timestamp);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)txnOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)new CommitRecordMetadataAndOffset((Option)None$.MODULE$, txnOffsetCommit)), (Object)this.group().pendingTxnOffsetCommit(producerId, topicIdPartition));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(topicIdPartition.topicPartition()));
        this.group().failPendingTxnOffsetCommit(producerId, topicIdPartition);
        Assertions.assertFalse((boolean)this.group().hasOffsets());
        Assertions.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().pendingTxnOffsetCommit(producerId, topicIdPartition));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assertions.assertFalse((boolean)this.group().hasOffsets());
        Assertions.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
    }

    @Test
    public void testUpdateMember() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        int newRebalanceTimeout = 120000;
        int newSessionTimeout = 20000;
        this.group().updateMember(member, (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$), newRebalanceTimeout, newSessionTimeout, null);
        Assertions.assertEquals((int)this.group().rebalanceTimeoutMs(), (int)newRebalanceTimeout);
        Assertions.assertEquals((int)member.sessionTimeoutMs(), (int)newSessionTimeout);
    }

    @Test
    public void testReplaceGroupInstanceWithNonExistingMember() {
        String newMemberId = "newMemberId";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.group().replaceStaticMember(this.groupInstanceId(), this.memberId(), newMemberId));
    }

    @Test
    public void testReplaceGroupInstance() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)new Some((Object)this.groupInstanceId()), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        BooleanRef joinAwaitingMemberFenced = BooleanRef.create((boolean)false);
        this.group().add(member, (Function1 & Serializable)joinGroupResult -> {
            GroupMetadataTest.$anonfun$testReplaceGroupInstance$1(joinAwaitingMemberFenced, joinGroupResult);
            return BoxedUnit.UNIT;
        });
        BooleanRef syncAwaitingMemberFenced = BooleanRef.create((boolean)false);
        member.awaitingSyncCallback_$eq((Function1 & Serializable)syncGroupResult -> {
            GroupMetadataTest.$anonfun$testReplaceGroupInstance$2(syncAwaitingMemberFenced, syncGroupResult);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.group().isLeader(this.memberId()));
        Assertions.assertEquals((Object)new Some((Object)this.memberId()), (Object)this.group().currentStaticMemberId(this.groupInstanceId()));
        String newMemberId = "newMemberId";
        this.group().replaceStaticMember(this.groupInstanceId(), this.memberId(), newMemberId);
        Assertions.assertTrue((boolean)this.group().isLeader(newMemberId));
        Assertions.assertEquals((Object)new Some((Object)newMemberId), (Object)this.group().currentStaticMemberId(this.groupInstanceId()));
        Assertions.assertTrue((boolean)joinAwaitingMemberFenced.elem);
        Assertions.assertTrue((boolean)syncAwaitingMemberFenced.elem);
        Assertions.assertFalse((boolean)member.isAwaitingJoin());
        Assertions.assertFalse((boolean)member.isAwaitingSync());
    }

    @Test
    public void testInvokeJoinCallback() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        BooleanRef invoked = BooleanRef.create((boolean)false);
        this.group().add(member, (Function1 & Serializable)x$3 -> {
            invoked.elem = true;
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.group().hasAllMembersJoined());
        this.group().maybeInvokeJoinCallback(member, JoinGroupResult$.MODULE$.apply(member.memberId(), Errors.NONE));
        Assertions.assertTrue((boolean)invoked.elem);
        Assertions.assertFalse((boolean)member.isAwaitingJoin());
    }

    @Test
    public void testInvokeJoinCallbackFails() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        BooleanRef shouldFail = BooleanRef.create((boolean)true);
        ObjectRef result = ObjectRef.create((Object)None$.MODULE$);
        this.group().add(member, (Function1 & Serializable)joinGroupResult -> {
            GroupMetadataTest.joinCallback$1(joinGroupResult, shouldFail, result);
            return BoxedUnit.UNIT;
        });
        this.group().maybeInvokeJoinCallback(member, JoinGroupResult$.MODULE$.apply(member.memberId(), Errors.NONE));
        Assertions.assertEquals((Object)Errors.UNKNOWN_SERVER_ERROR, (Object)((JoinGroupResult)((Option)result.elem).get()).error());
        Assertions.assertFalse((boolean)member.isAwaitingJoin());
    }

    @Test
    public void testNotInvokeJoinCallback() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        Assertions.assertFalse((boolean)member.isAwaitingJoin());
        this.group().maybeInvokeJoinCallback(member, JoinGroupResult$.MODULE$.apply(member.memberId(), Errors.NONE));
        Assertions.assertFalse((boolean)member.isAwaitingJoin());
    }

    @Test
    public void testInvokeSyncCallbackFails() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        BooleanRef shouldFail = BooleanRef.create((boolean)true);
        ObjectRef result = ObjectRef.create((Object)None$.MODULE$);
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        member.awaitingSyncCallback_$eq((Function1 & Serializable)syncGroupResult -> {
            GroupMetadataTest.syncCallback$1(syncGroupResult, shouldFail, result);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.group().maybeInvokeSyncCallback(member, SyncGroupResult$.MODULE$.apply(Errors.NONE)));
        Assertions.assertEquals((Object)Errors.UNKNOWN_SERVER_ERROR, (Object)((SyncGroupResult)((Option)result.elem).get()).error());
        Assertions.assertFalse((boolean)member.isAwaitingSync());
    }

    @Test
    public void testInvokeSyncCallback() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        member.awaitingSyncCallback_$eq((Function1 & Serializable)x$4 -> {
            GroupMetadataTest.$anonfun$testInvokeSyncCallback$1(x$4);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.group().maybeInvokeSyncCallback(member, SyncGroupResult$.MODULE$.apply(Errors.NONE)));
        Assertions.assertFalse((boolean)member.isAwaitingSync());
    }

    @Test
    public void testNotInvokeSyncCallback() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        Assertions.assertFalse((boolean)this.group().maybeInvokeSyncCallback(member, SyncGroupResult$.MODULE$.apply(Errors.NONE)));
        Assertions.assertFalse((boolean)member.isAwaitingSync());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHasPendingNonTxnOffsets() {
        void offsetAndMetadata_timestamp;
        TopicIdPartition partition = new TopicIdPartition(Uuid.randomUuid(), 0, "foo");
        long l = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset = 37L;
        OffsetAndMetadata offset = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset, "", (long)offsetAndMetadata_timestamp);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assertions.assertTrue((boolean)this.group().hasPendingOffsetCommitsForTopicPartition(partition.topicPartition()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHasPendingTxnOffsets() {
        void offsetAndMetadata_timestamp;
        TopicIdPartition txnPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "foo");
        long l = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset = 37L;
        OffsetAndMetadata offset = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset, "", (long)offsetAndMetadata_timestamp);
        int producerId = 5;
        this.group().prepareTxnOffsetCommit((long)producerId, (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)txnPartition), (Object)offset)})));
        Assertions.assertTrue((boolean)this.group().hasPendingOffsetCommitsForTopicPartition(txnPartition.topicPartition()));
        Assertions.assertFalse((boolean)this.group().hasPendingOffsetCommitsForTopicPartition(new TopicPartition("non-exist", 0)));
    }

    @Test
    public void testCannotAddPendingMemberIfStable() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().addPendingMember(this.memberId()));
    }

    @Test
    public void testRemovalFromPendingAfterMemberIsStable() {
        this.group().addPendingMember(this.memberId());
        Assertions.assertFalse((boolean)this.group().has(this.memberId()));
        Assertions.assertTrue((boolean)this.group().isPendingMember(this.memberId()));
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        Assertions.assertTrue((boolean)this.group().has(this.memberId()));
        Assertions.assertFalse((boolean)this.group().isPendingMember(this.memberId()));
    }

    @Test
    public void testRemovalFromPendingWhenMemberIsRemoved() {
        this.group().addPendingMember(this.memberId());
        Assertions.assertFalse((boolean)this.group().has(this.memberId()));
        Assertions.assertTrue((boolean)this.group().isPendingMember(this.memberId()));
        this.group().remove(this.memberId());
        Assertions.assertFalse((boolean)this.group().has(this.memberId()));
        Assertions.assertFalse((boolean)this.group().isPendingMember(this.memberId()));
    }

    @Test
    public void testCannotAddStaticMemberIfAlreadyPresent() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)new Some((Object)this.groupInstanceId()), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        Assertions.assertTrue((boolean)this.group().has(this.memberId()));
        Assertions.assertTrue((boolean)this.group().hasStaticMember(this.groupInstanceId()));
        Assertions.assertThrows(IllegalStateException.class, () -> {
            GroupMetadata qual$2 = this.group();
            Function1 x$4 = qual$2.add$default$2();
            qual$2.add(member, x$4);
        });
    }

    @Test
    public void testCannotAddPendingSyncOfUnknownMember() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().addPendingSyncMember(this.memberId()));
    }

    @Test
    public void testCannotRemovePendingSyncOfUnknownMember() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().removePendingSyncMember(this.memberId()));
    }

    @Test
    public void testCanAddAndRemovePendingSyncMember() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)new Some((Object)this.groupInstanceId()), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().addPendingSyncMember(this.memberId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.memberId()})), (Object)this.group().allPendingSyncMembers());
        this.group().removePendingSyncMember(this.memberId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)this.group().allPendingSyncMembers());
    }

    @Test
    public void testRemovalFromPendingSyncWhenMemberIsRemoved() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)new Some((Object)this.groupInstanceId()), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().addPendingSyncMember(this.memberId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.memberId()})), (Object)this.group().allPendingSyncMembers());
        this.group().remove(this.memberId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)this.group().allPendingSyncMembers());
    }

    @Test
    public void testNewGenerationClearsPendingSyncMembers() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)new Some((Object)this.groupInstanceId()), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().addPendingSyncMember(this.memberId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.memberId()})), (Object)this.group().allPendingSyncMembers());
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)this.group().allPendingSyncMembers());
    }

    private void assertState(GroupMetadata group, GroupState targetState) {
        ((Set)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GroupState[]{Stable$.MODULE$, PreparingRebalance$.MODULE$, CompletingRebalance$.MODULE$, Dead$.MODULE$}))).$minus((Object)targetState)).foreach((Function1 & Serializable)otherState -> {
            GroupMetadataTest.$anonfun$assertState$1(group, otherState);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)group.is(targetState));
    }

    private OffsetAndMetadata offsetAndMetadata(long offset, long timestamp) {
        return OffsetAndMetadata$.MODULE$.apply(offset, "", timestamp);
    }

    private long offsetAndMetadata$default$2() {
        return Time.SYSTEM.milliseconds();
    }

    public static final /* synthetic */ void $anonfun$testInitNextGeneration$1(JoinGroupResult x$2) {
    }

    public static final /* synthetic */ void $anonfun$testReplaceGroupInstance$1(BooleanRef joinAwaitingMemberFenced$1, JoinGroupResult joinGroupResult) {
        Errors errors = joinGroupResult.error();
        Errors errors2 = Errors.FENCED_INSTANCE_ID;
        joinAwaitingMemberFenced$1.elem = !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ void $anonfun$testReplaceGroupInstance$2(BooleanRef syncAwaitingMemberFenced$1, SyncGroupResult syncGroupResult) {
        Errors errors = syncGroupResult.error();
        Errors errors2 = Errors.FENCED_INSTANCE_ID;
        syncAwaitingMemberFenced$1.elem = !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    private static final void joinCallback$1(JoinGroupResult joinGroupResult, BooleanRef shouldFail$1, ObjectRef result$1) {
        if (shouldFail$1.elem) {
            shouldFail$1.elem = false;
            throw new Exception("Something went wrong!");
        }
        result$1.elem = new Some((Object)joinGroupResult);
    }

    private static final void syncCallback$1(SyncGroupResult syncGroupResult, BooleanRef shouldFail$2, ObjectRef result$2) {
        if (shouldFail$2.elem) {
            shouldFail$2.elem = false;
            throw new Exception("Something went wrong!");
        }
        result$2.elem = new Some((Object)syncGroupResult);
    }

    public static final /* synthetic */ void $anonfun$testInvokeSyncCallback$1(SyncGroupResult x$4) {
    }

    public static final /* synthetic */ void $anonfun$assertState$1(GroupMetadata group$1, GroupState otherState) {
        Assertions.assertFalse((boolean)group$1.is(otherState));
    }

    public GroupMetadataTest() {
        this.protocolType = "consumer";
        this.groupInstanceId = "groupInstanceId";
        this.memberId = "memberId";
        this.clientId = "clientId";
        this.clientHost = "clientHost";
        this.rebalanceTimeoutMs = 60000;
        this.sessionTimeoutMs = 10000;
    }
}

