/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.DescribeProducersResult;
import org.apache.kafka.clients.admin.ProducerState;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidPidMappingException;
import org.apache.kafka.common.errors.TransactionalIdNotFoundException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.server.config.ReplicationConfigs;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\u0005=g\u0001\u0002\u0010 \u0001\u0011BQa\u000b\u0001\u0005\u00021Bqa\f\u0001C\u0002\u0013\u0005\u0001\u0007\u0003\u0004:\u0001\u0001\u0006I!\r\u0005\bu\u0001\u0011\r\u0011\"\u00011\u0011\u0019Y\u0004\u0001)A\u0005c!9A\b\u0001b\u0001\n\u0003i\u0004B\u0002#\u0001A\u0003%a\bC\u0004F\u0001\t\u0007I\u0011A\u001f\t\r\u0019\u0003\u0001\u0015!\u0003?\u0011\u001d9\u0005A1A\u0005\u0002!Ca\u0001\u0016\u0001!\u0002\u0013I\u0005\"C+\u0001\u0001\u0004\u0005\r\u0011\"\u0001W\u0011%!\u0007\u00011AA\u0002\u0013\u0005Q\rC\u0005l\u0001\u0001\u0007\t\u0011)Q\u0005/\"IA\u000e\u0001a\u0001\u0002\u0004%\t!\u001c\u0005\ng\u0002\u0001\r\u00111A\u0005\u0002QD\u0011B\u001e\u0001A\u0002\u0003\u0005\u000b\u0015\u00028\t\u0013]\u0004\u0001\u0019!a\u0001\n\u0003A\b\"\u0003@\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0000\u0011)\t\u0019\u0001\u0001a\u0001\u0002\u0003\u0006K!\u001f\u0005\b\u0003\u000b\u0001A\u0011IA\u0004\u0011\u001d\t\t\u0003\u0001C!\u0003GAq!a\u0011\u0001\t\u0003\n)\u0005C\u0004\u0002P\u0001!\t!!\u0015\t\u000f\u0005M\u0005\u0001\"\u0001\u0002\u0016\"9\u0011q\u0014\u0001\u0005\n\u0005\u0005\u0006bBA^\u0001\u0011%\u0011Q\t\u0005\b\u0003{\u0003A\u0011BA#\u0011\u001d\ty\f\u0001C\u0005\u0003\u0003\u0014!\u0004\u0016:b]N\f7\r^5p]N,\u0005\u0010]5sCRLwN\u001c+fgRT!\u0001I\u0011\u0002\u0007\u0005\u0004\u0018NC\u0001#\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0013\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!\n\u0013aC5oi\u0016<'/\u0019;j_:L!AK\u0014\u0003--\u000bgm[1TKJ4XM\u001d+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#A\u0017\u0011\u00059\u0002Q\"A\u0010\u0002\rQ|\u0007/[22+\u0005\t\u0004C\u0001\u001a8\u001b\u0005\u0019$B\u0001\u001b6\u0003\u0011a\u0017M\\4\u000b\u0003Y\nAA[1wC&\u0011\u0001h\r\u0002\u0007'R\u0014\u0018N\\4\u0002\u000fQ|\u0007/[22A\u00051Ao\u001c9jGJ\nq\u0001^8qS\u000e\u0014\u0004%A\u0007ok6\u0004\u0016M\u001d;ji&|gn]\u000b\u0002}A\u0011qHQ\u0007\u0002\u0001*\t\u0011)A\u0003tG\u0006d\u0017-\u0003\u0002D\u0001\n\u0019\u0011J\u001c;\u0002\u001d9,X\u000eU1si&$\u0018n\u001c8tA\u0005\t\"/\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:\u0002%I,\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000fI\u0001\u0004iB\u0004T#A%\u0011\u0005)\u0013V\"A&\u000b\u00051k\u0015AB2p[6|gN\u0003\u0002#\u001d*\u0011q\nU\u0001\u0007CB\f7\r[3\u000b\u0003E\u000b1a\u001c:h\u0013\t\u00196J\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\tQ\u0004\b\u0007I\u0001\taJ|G-^2feV\tq\u000b\u0005\u0003Y9zsV\"A-\u000b\u0005US&BA.N\u0003\u001d\u0019G.[3oiNL!!X-\u0003\u001b-\u000bgm[1Qe>$WoY3s!\ryt,Y\u0005\u0003A\u0002\u0013Q!\u0011:sCf\u0004\"a\u00102\n\u0005\r\u0004%\u0001\u0002\"zi\u0016\fA\u0002\u001d:pIV\u001cWM]0%KF$\"AZ5\u0011\u0005}:\u0017B\u00015A\u0005\u0011)f.\u001b;\t\u000f)l\u0011\u0011!a\u0001/\u0006\u0019\u0001\u0010J\u0019\u0002\u0013A\u0014x\u000eZ;dKJ\u0004\u0013\u0001C2p]N,X.\u001a:\u0016\u00039\u0004Ba\\9_=6\t\u0001O\u0003\u0002m5&\u0011!\u000f\u001d\u0002\t\u0007>t7/^7fe\u0006a1m\u001c8tk6,'o\u0018\u0013fcR\u0011a-\u001e\u0005\bUB\t\t\u00111\u0001o\u0003%\u0019wN\\:v[\u0016\u0014\b%A\u0003bI6Lg.F\u0001z!\tQH0D\u0001|\u0015\t9(,\u0003\u0002~w\n)\u0011\tZ7j]\u0006I\u0011\rZ7j]~#S-\u001d\u000b\u0004M\u0006\u0005\u0001b\u00026\u0014\u0003\u0003\u0005\r!_\u0001\u0007C\u0012l\u0017N\u001c\u0011\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON,\"!!\u0003\u0011\r\u0005-\u0011\u0011CA\u000b\u001b\t\tiAC\u0002\u0002\u0010\u0001\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019\"!\u0004\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002\u0018\u0005uQBAA\r\u0015\r\tY\"I\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005}\u0011\u0011\u0004\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0003tKR,\u0006\u000fF\u0002g\u0003KAq!a\n\u0017\u0001\u0004\tI#\u0001\u0005uKN$\u0018J\u001c4p!\u0011\tY#a\u000e\u000e\u0005\u00055\"b\u0001\u0011\u00020)!\u0011\u0011GA\u001a\u0003\u001dQW\u000f]5uKJT1!!\u000eQ\u0003\u0015QWO\\5u\u0013\u0011\tI$!\f\u0003\u0011Q+7\u000f^%oM>D3AFA\u001f!\u0011\tY#a\u0010\n\t\u0005\u0005\u0013Q\u0006\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8\u0015\u0003\u0019D3aFA%!\u0011\tY#a\u0013\n\t\u00055\u0013Q\u0006\u0002\n\u0003\u001a$XM]#bG\"\fq\u0007^3ti\n+X\u000e\u001d+sC:\u001c\u0018m\u0019;j_:\fG.\u00129pG\"\fe\r^3s\u0013:4\u0018\r\\5e!J|G-^2fe&#W*\u00199qS:<Gc\u00014\u0002T!9\u0011Q\u000b\rA\u0002\u0005]\u0013AB9v_J,X\u000e\u0005\u0003\u0002Z\u0005\u001dd\u0002BA.\u0003G\u00022!!\u0018A\u001b\t\tyFC\u0002\u0002b\r\na\u0001\u0010:p_Rt\u0014bAA3\u0001\u00061\u0001K]3eK\u001aL1\u0001OA5\u0015\r\t)\u0007\u0011\u0015\u00041\u00055\u0004\u0003BA8\u0003kj!!!\u001d\u000b\t\u0005M\u0014qF\u0001\u0007a\u0006\u0014\u0018-\\:\n\t\u0005]\u0014\u0011\u000f\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\bf\u0002\r\u0002|\u0005\u001d\u0015\u0011\u0012\t\u0005\u0003{\n\u0019)\u0004\u0002\u0002\u0000)!\u0011\u0011QA9\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018\u0002BAC\u0003\u007f\u00121BV1mk\u0016\u001cv.\u001e:dK\u000691\u000f\u001e:j]\u001e\u001cH\u0006BAF\u0003\u001f\u000b#!!$\u0002\u0005i\\\u0017EAAI\u0003\u0015Y'/\u00194u\u0003\u0015\"Xm\u001d;Ue\u0006t7/Y2uS>t\u0017I\u001a;feB\u0013x\u000eZ;dKJLE-\u0012=qSJ,7\u000fF\u0002g\u0003/Cq!!\u0016\u001a\u0001\u0004\t9\u0006K\u0002\u001a\u0003[Bs!GA>\u0003\u000f\u000bi\n\f\u0003\u0002\f\u0006=\u0015!\u00049s_\u0012,8-\u001a:Ti\u0006$X-\u0006\u0002\u0002$B1\u0011QUAX\u0003ksA!a*\u0002,:!\u0011QLAU\u0013\u0005\t\u0015bAAW\u0001\u00069\u0001/Y2lC\u001e,\u0017\u0002BAY\u0003g\u0013A\u0001T5ti*\u0019\u0011Q\u0016!\u0011\u0007i\f9,C\u0002\u0002:n\u0014Q\u0002\u0015:pIV\u001cWM]*uCR,\u0017AI<bSR,f\u000e^5m)J\fgn]1di&|g.\u00197Ti\u0006$X-\u0012=qSJ,7/A\u0011xC&$XK\u001c;jYR\u0013\u0018M\\:bGRLwN\\1m'R\fG/Z#ySN$8/A\u0006tKJ4XM\u001d)s_B\u001cHCAAb!\u0011\t)-a3\u000e\u0005\u0005\u001d'bAAek\u0005!Q\u000f^5m\u0013\u0011\ti-a2\u0003\u0015A\u0013x\u000e]3si&,7\u000f")
public class TransactionsExpirationTest
extends KafkaServerTestHarness {
    private final String topic1;
    private final String topic2;
    private final int numPartitions;
    private final int replicationFactor;
    private final TopicPartition tp0 = new TopicPartition(this.topic1(), 0);
    private KafkaProducer<byte[], byte[]> producer;
    private Consumer<byte[], byte[]> consumer;
    private Admin admin;

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public int replicationFactor() {
        return this.replicationFactor;
    }

    public TopicPartition tp0() {
        return this.tp0;
    }

    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    public Consumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    public void consumer_$eq(Consumer<byte[], byte[]> x$1) {
        this.consumer = x$1;
    }

    public Admin admin() {
        return this.admin;
    }

    public void admin_$eq(Admin x$1) {
        this.admin = x$1;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnectOrNull(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)x$4 -> {
            Properties fromProps_overrides = this.serverProps();
            return KafkaConfig$.MODULE$.fromProps(x$4, fromProps_overrides, true);
        });
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.producer_$eq(TestUtils$.MODULE$.createTransactionalProducer("transactionalProducer", this.brokers(), 16384, 60000L, 60000L, 120000, 30000, 5));
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        String x$4 = "group";
        String x$5 = "earliest";
        int x$6 = 500;
        SecurityProtocol x$7 = SecurityProtocol.PLAINTEXT;
        None$ x$8 = None$.MODULE$;
        None$ x$9 = None$.MODULE$;
        ByteArrayDeserializer x$10 = new ByteArrayDeserializer();
        ByteArrayDeserializer x$11 = new ByteArrayDeserializer();
        this.consumer_$eq(TestUtils$.MODULE$.createConsumer(x$1, x$4, x$5, false, true, x$6, x$7, (Option<File>)x$8, (Option<Properties>)x$9, x$10, x$11));
        this.admin_$eq(TestUtils$.MODULE$.createAdminClient(this.brokers(), this.listenerName(), new Properties()));
        this.createTopic(this.topic1(), this.numPartitions(), 3, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(this.topic2(), this.numPartitions(), 3, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.producer() != null) {
            this.producer().close();
        }
        if (this.consumer() != null) {
            this.consumer().close();
        }
        if (this.admin() != null) {
            this.admin().close();
        }
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testBumpTransactionalEpochAfterInvalidProducerIdMapping(String quorum) {
        this.producer().initTransactions();
        this.producer().beginTransaction();
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(0), "2", "2", false));
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), Predef$.MODULE$.int2Integer(0), "4", "4", false));
        this.producer().abortTransaction();
        this.waitUntilTransactionalStateExists();
        this.waitUntilTransactionalStateExpires();
        this.producer().beginTransaction();
        Future failedFuture = this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(3), "1", "1", false));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!failedFuture.isDone()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Producer future never completed.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        TestUtils.assertFutureThrows((Future)failedFuture, InvalidPidMappingException.class);
        this.producer().abortTransaction();
        this.producer().beginTransaction();
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "2", true));
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(2), "4", "4", true));
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "1", "1", true));
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(3), "3", "3", true));
        this.producer().commitTransaction();
        this.waitUntilTransactionalStateExists();
        this.consumer().subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        TestUtils$.MODULE$.consumeRecords(this.consumer(), 4, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testTransactionAfterProducerIdExpires(String quorum) {
        List<ProducerState> list;
        List<ProducerState> list2;
        this.producer().initTransactions();
        this.producer().beginTransaction();
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(0), "2", "2", false));
        this.producer().flush();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!(list2 = this.producerState()).nonEmpty()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Producer IDs for topic1 did not propagate quickly");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)1, (int)list2.size(), (String)"Unexpected producer to topic1");
        long oldProducerId = ((ProducerState)list2.head()).producerId();
        int oldProducerEpoch = ((ProducerState)list2.head()).producerEpoch();
        this.producer().abortTransaction();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TransactionsExpirationTest.$anonfun$testTransactionAfterProducerIdExpires$3(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Producer IDs for topic1 did not expire.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        this.producer().close();
        this.producer_$eq(TestUtils$.MODULE$.createTransactionalProducer("transactionalProducer", this.brokers(), 16384, 60000L, 60000L, 120000, 30000, 5));
        this.producer().initTransactions();
        this.producer().beginTransaction();
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(0), "4", "4", true));
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(3), "3", "3", true));
        this.producer().commitTransaction();
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!(list = this.producerState()).nonEmpty()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Producer IDs for topic1 did not propagate quickly");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)1, (int)list.size(), (String)"Unexpected producer to topic1");
        long newProducerId = ((ProducerState)list.head()).producerId();
        int newProducerEpoch = ((ProducerState)list.head()).producerEpoch();
        Assertions.assertEquals((long)oldProducerId, (long)newProducerId);
        Assertions.assertEquals((int)(oldProducerEpoch + 1), (int)newProducerEpoch);
        this.consumer().subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        TestUtils$.MODULE$.consumeRecords(this.consumer(), 2, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    private List<ProducerState> producerState() {
        java.util.List activeProducers = ((DescribeProducersResult.PartitionProducerState)this.admin().describeProducers(Collections.singletonList(this.tp0())).partitionResult(this.tp0()).get()).activeProducers();
        return CollectionConverters$.MODULE$.ListHasAsScala(activeProducers).asScala().toList();
    }

    private void waitUntilTransactionalStateExpires() {
        long waitUntilTrue_pause = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TransactionsExpirationTest.$anonfun$waitUntilTransactionalStateExpires$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Transaction state never expired.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void waitUntilTransactionalStateExists() {
        KafkaFuture describeState = this.admin().describeTransactions(Collections.singletonList("transactionalProducer")).description("transactionalProducer");
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!describeState.isDone()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Transactional state was never added.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private Properties serverProps() {
        Properties serverProps = new Properties();
        serverProps.put("auto.create.topics.enable", Boolean.toString(false));
        serverProps.put("offsets.topic.num.partitions", Integer.toString(1));
        serverProps.put("transaction.state.log.num.partitions", Integer.toString(3));
        serverProps.put("transaction.state.log.replication.factor", Integer.toString(2));
        serverProps.put("transaction.state.log.min.isr", Integer.toString(2));
        serverProps.put("controlled.shutdown.enable", Boolean.toString(true));
        serverProps.put(ReplicationConfigs.UNCLEAN_LEADER_ELECTION_ENABLE_CONFIG, Boolean.toString(false));
        serverProps.put("auto.leader.rebalance.enable", Boolean.toString(false));
        serverProps.put("group.initial.rebalance.delay.ms", "0");
        serverProps.put("transaction.abort.timed.out.transaction.cleanup.interval.ms", "200");
        serverProps.put("transactional.id.expiration.ms", "10000");
        serverProps.put("transaction.remove.expired.transaction.cleanup.interval.ms", "500");
        serverProps.put("producer.id.expiration.ms", "5000");
        serverProps.put("producer.id.expiration.check.interval.ms", "500");
        return serverProps;
    }

    public static final /* synthetic */ boolean $anonfun$testBumpTransactionalEpochAfterInvalidProducerIdMapping$1(Future failedFuture$1) {
        return failedFuture$1.isDone();
    }

    public static final /* synthetic */ String $anonfun$testBumpTransactionalEpochAfterInvalidProducerIdMapping$2() {
        return "Producer future never completed.";
    }

    public static final /* synthetic */ boolean $anonfun$testTransactionAfterProducerIdExpires$1(TransactionsExpirationTest $this, ObjectRef pState$1) {
        pState$1.elem = $this.producerState();
        return ((List)pState$1.elem).nonEmpty();
    }

    public static final /* synthetic */ String $anonfun$testTransactionAfterProducerIdExpires$2() {
        return "Producer IDs for topic1 did not propagate quickly";
    }

    public static final /* synthetic */ boolean $anonfun$testTransactionAfterProducerIdExpires$3(TransactionsExpirationTest $this) {
        return $this.producerState().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testTransactionAfterProducerIdExpires$4() {
        return "Producer IDs for topic1 did not expire.";
    }

    public static final /* synthetic */ boolean $anonfun$testTransactionAfterProducerIdExpires$5(TransactionsExpirationTest $this, ObjectRef pState2$1) {
        pState2$1.elem = $this.producerState();
        return ((List)pState2$1.elem).nonEmpty();
    }

    public static final /* synthetic */ String $anonfun$testTransactionAfterProducerIdExpires$6() {
        return "Producer IDs for topic1 did not propagate quickly";
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilTransactionalStateExpires$1(TransactionsExpirationTest $this) {
        boolean removedTransactionState = false;
        try {
            $this.admin().describeTransactions(Collections.singletonList("transactionalProducer")).description("transactionalProducer").get();
        }
        catch (Exception exception) {
            removedTransactionState = exception.getCause() instanceof TransactionalIdNotFoundException;
        }
        return removedTransactionState;
    }

    public static final /* synthetic */ String $anonfun$waitUntilTransactionalStateExpires$2() {
        return "Transaction state never expired.";
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilTransactionalStateExists$1(KafkaFuture describeState$1) {
        return describeState$1.isDone();
    }

    public static final /* synthetic */ String $anonfun$waitUntilTransactionalStateExists$2() {
        return "Transactional state was never added.";
    }

    public TransactionsExpirationTest() {
        this.topic1 = "topic1";
        this.topic2 = "topic2";
        this.numPartitions = 4;
        this.replicationFactor = 3;
    }
}

