/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.inline.hook;

import com.okta.commons.http.HttpHeaders;
import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.inline.hook.InlineHook;
import com.okta.sdk.resource.inline.hook.InlineHookChannel;
import com.okta.sdk.resource.inline.hook.InlineHookPayload;
import com.okta.sdk.resource.inline.hook.InlineHookResponse;
import com.okta.sdk.resource.inline.hook.InlineHookStatus;
import com.okta.sdk.resource.inline.hook.InlineHookType;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultInlineHook
extends AbstractInstanceResource<InlineHook>
implements InlineHook {
    private static final MapProperty linksProperty = new MapProperty("_links");
    private static final ResourceReference<InlineHookChannel> channelProperty = new ResourceReference<InlineHookChannel>("channel", InlineHookChannel.class, false);
    private static final DateProperty createdProperty = new DateProperty("created");
    private static final StringProperty idProperty = new StringProperty("id");
    private static final DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private static final StringProperty nameProperty = new StringProperty("name");
    private static final EnumProperty<InlineHookStatus> statusProperty = new EnumProperty<InlineHookStatus>("status", InlineHookStatus.class);
    private static final EnumProperty<InlineHookType> typeProperty = new EnumProperty<InlineHookType>("type", InlineHookType.class);
    private static final StringProperty versionProperty = new StringProperty("version");
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultInlineHook.createPropertyDescriptorMap(linksProperty, channelProperty, createdProperty, idProperty, lastUpdatedProperty, nameProperty, statusProperty, typeProperty, versionProperty);

    public DefaultInlineHook(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultInlineHook(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return InlineHook.class;
    }

    public Map<String, Object> getLinks() {
        return this.getMap(linksProperty);
    }

    public InlineHookChannel getChannel() {
        return this.getResourceProperty(channelProperty);
    }

    public InlineHook setChannel(InlineHookChannel channel) {
        this.setProperty(channelProperty, (Object)channel);
        return this;
    }

    public Date getCreated() {
        return this.getDateProperty(createdProperty);
    }

    public String getId() {
        return this.getString(idProperty);
    }

    public Date getLastUpdated() {
        return this.getDateProperty(lastUpdatedProperty);
    }

    public String getName() {
        return this.getString(nameProperty);
    }

    public InlineHook setName(String name) {
        this.setProperty(nameProperty, (Object)name);
        return this;
    }

    public InlineHookStatus getStatus() {
        return this.getEnumProperty(statusProperty);
    }

    public InlineHook setStatus(InlineHookStatus status) {
        this.setProperty(statusProperty, (Object)status);
        return this;
    }

    public InlineHookType getType() {
        return this.getEnumProperty(typeProperty);
    }

    public InlineHook setType(InlineHookType type) {
        this.setProperty(typeProperty, (Object)type);
        return this;
    }

    public String getVersion() {
        return this.getString(versionProperty);
    }

    public InlineHook setVersion(String version) {
        this.setProperty(versionProperty, (Object)version);
        return this;
    }

    public InlineHook update() {
        String inlineHookId = this.getId();
        Assert.hasText((String)inlineHookId, (String)"'inlineHookId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/inlineHooks/" + inlineHookId + "";
        this.getDataStore().save(href, this, null, queryArgs, (Map<String, List<String>>)headers);
        return this;
    }

    public InlineHookResponse execute(InlineHookPayload payloadData) {
        String inlineHookId = this.getId();
        Assert.notNull((Object)payloadData, (String)"'payloadData' is required and cannot be null.");
        Assert.hasText((String)inlineHookId, (String)"'inlineHookId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/inlineHooks/" + inlineHookId + "/execute", payloadData, this, InlineHookResponse.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    @Override
    public void delete() {
        String inlineHookId = this.getId();
        Assert.hasText((String)inlineHookId, (String)"'inlineHookId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/inlineHooks/" + inlineHookId + "", this, queryArgs, (Map<String, List<String>>)headers);
    }

    public InlineHook deactivate() {
        String inlineHookId = this.getId();
        Assert.hasText((String)inlineHookId, (String)"'inlineHookId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/inlineHooks/" + inlineHookId + "/lifecycle/deactivate", new DefaultVoidResource(this.getDataStore()), this, InlineHook.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public InlineHook activate() {
        String inlineHookId = this.getId();
        Assert.hasText((String)inlineHookId, (String)"'inlineHookId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/inlineHooks/" + inlineHookId + "/lifecycle/activate", new DefaultVoidResource(this.getDataStore()), this, InlineHook.class, queryArgs, (Map<String, List<String>>)headers);
    }
}

