/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.SendEventServiceTask;
import org.flowable.editor.language.json.converter.BaseBpmnJsonConverter;
import org.flowable.editor.language.json.converter.BpmnJsonConverterContext;
import org.flowable.editor.language.json.converter.util.JsonConverterUtil;

public class SendEventTaskJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        SendEventTaskJsonConverter.fillJsonTypes(convertersToBpmnMap);
        SendEventTaskJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("SendEventTask", SendEventTaskJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(SendEventServiceTask.class, SendEventTaskJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "SendEventTask";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement, BpmnJsonConverterContext converterContext) {
        SendEventServiceTask sendEventServiceTask = (SendEventServiceTask)baseElement;
        String eventType = sendEventServiceTask.getEventType();
        if (StringUtils.isNotEmpty((CharSequence)eventType)) {
            this.setPropertyValue("eventkey", sendEventServiceTask.getEventType(), propertiesNode);
            this.setPropertyValue("eventname", this.getExtensionValue("eventName", (FlowElement)sendEventServiceTask), propertiesNode);
            this.addEventInIOParameters(sendEventServiceTask.getEventInParameters(), propertiesNode);
            this.setPropertyValue("channelkey", this.getExtensionValue("channelKey", (FlowElement)sendEventServiceTask), propertiesNode);
            this.setPropertyValue("channelname", this.getExtensionValue("channelName", (FlowElement)sendEventServiceTask), propertiesNode);
            this.setPropertyValue("channeltype", this.getExtensionValue("channelType", (FlowElement)sendEventServiceTask), propertiesNode);
            this.setPropertyValue("channeldestination", this.getExtensionValue("channelDestination", (FlowElement)sendEventServiceTask), propertiesNode);
            if (sendEventServiceTask.isTriggerable()) {
                propertiesNode.put("servicetasktriggerable", sendEventServiceTask.isTriggerable());
            }
            this.setPropertyValue("triggereventkey", sendEventServiceTask.getTriggerEventType(), propertiesNode);
            this.setPropertyValue("triggereventname", this.getExtensionValue("triggerEventName", (FlowElement)sendEventServiceTask), propertiesNode);
            this.addEventOutIOParameters(sendEventServiceTask.getEventOutParameters(), propertiesNode);
            this.setPropertyValue("triggerchannelkey", this.getExtensionValue("triggerChannelKey", (FlowElement)sendEventServiceTask), propertiesNode);
            this.setPropertyValue("triggerchannelname", this.getExtensionValue("triggerChannelName", (FlowElement)sendEventServiceTask), propertiesNode);
            this.setPropertyValue("triggerchanneltype", this.getExtensionValue("triggerChannelType", (FlowElement)sendEventServiceTask), propertiesNode);
            this.setPropertyValue("triggerchanneldestination", this.getExtensionValue("triggerChannelDestination", (FlowElement)sendEventServiceTask), propertiesNode);
            this.addEventCorrelationParameters((List)sendEventServiceTask.getExtensionElements().get("triggerEventCorrelationParameter"), propertiesNode);
            String keyDetectionType = this.getExtensionValue("keyDetectionType", (FlowElement)sendEventServiceTask);
            String keyDetectionValue = this.getExtensionValue("keyDetectionValue", (FlowElement)sendEventServiceTask);
            if (StringUtils.isNotEmpty((CharSequence)keyDetectionType) && StringUtils.isNotEmpty((CharSequence)keyDetectionValue)) {
                if ("fixedValue".equalsIgnoreCase(keyDetectionType)) {
                    this.setPropertyValue("keydetectionfixedvalue", keyDetectionValue, propertiesNode);
                } else if ("jsonField".equalsIgnoreCase(keyDetectionType)) {
                    this.setPropertyValue("keydetectionjsonfield", keyDetectionValue, propertiesNode);
                } else if ("jsonPointer".equalsIgnoreCase(keyDetectionType)) {
                    this.setPropertyValue("keydetectionjsonpointer", keyDetectionValue, propertiesNode);
                }
            }
        }
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap, BpmnJsonConverterContext converterContext) {
        SendEventServiceTask task = new SendEventServiceTask();
        task.setType("send-event");
        String eventKey = JsonConverterUtil.getPropertyValueAsString("eventkey", elementNode);
        if (StringUtils.isNotEmpty((CharSequence)eventKey)) {
            task.setEventType(eventKey);
            SendEventTaskJsonConverter.addFlowableExtensionElementWithValue("eventName", JsonConverterUtil.getPropertyValueAsString("eventname", elementNode), (FlowElement)task);
            this.convertJsonToInIOParameters(elementNode, task);
            SendEventTaskJsonConverter.addFlowableExtensionElementWithValue("channelKey", JsonConverterUtil.getPropertyValueAsString("channelkey", elementNode), (FlowElement)task);
            SendEventTaskJsonConverter.addFlowableExtensionElementWithValue("channelName", JsonConverterUtil.getPropertyValueAsString("channelname", elementNode), (FlowElement)task);
            SendEventTaskJsonConverter.addFlowableExtensionElementWithValue("channelType", JsonConverterUtil.getPropertyValueAsString("channeltype", elementNode), (FlowElement)task);
            SendEventTaskJsonConverter.addFlowableExtensionElementWithValue("channelDestination", JsonConverterUtil.getPropertyValueAsString("channeldestination", elementNode), (FlowElement)task);
            String triggerEventKey = JsonConverterUtil.getPropertyValueAsString("triggereventkey", elementNode);
            if (StringUtils.isNotEmpty((CharSequence)triggerEventKey)) {
                task.setTriggerEventType(triggerEventKey);
                if (JsonConverterUtil.getPropertyValueAsBoolean("servicetasktriggerable", elementNode)) {
                    task.setTriggerable(true);
                }
                SendEventTaskJsonConverter.addFlowableExtensionElementWithValue("triggerEventName", JsonConverterUtil.getPropertyValueAsString("triggereventname", elementNode), (FlowElement)task);
                this.convertJsonToOutIOParameters(elementNode, task);
                SendEventTaskJsonConverter.addFlowableExtensionElementWithValue("triggerChannelKey", JsonConverterUtil.getPropertyValueAsString("triggerchannelkey", elementNode), (FlowElement)task);
                SendEventTaskJsonConverter.addFlowableExtensionElementWithValue("triggerChannelName", JsonConverterUtil.getPropertyValueAsString("triggerchannelname", elementNode), (FlowElement)task);
                SendEventTaskJsonConverter.addFlowableExtensionElementWithValue("triggerChannelType", JsonConverterUtil.getPropertyValueAsString("triggerchanneltype", elementNode), (FlowElement)task);
                SendEventTaskJsonConverter.addFlowableExtensionElementWithValue("triggerChannelDestination", JsonConverterUtil.getPropertyValueAsString("triggerchanneldestination", elementNode), (FlowElement)task);
                this.convertJsonToEventCorrelationParameters(elementNode, "triggerEventCorrelationParameter", (FlowElement)task);
                String fixedValue = JsonConverterUtil.getPropertyValueAsString("keydetectionfixedvalue", elementNode);
                String jsonField = JsonConverterUtil.getPropertyValueAsString("keydetectionjsonfield", elementNode);
                String jsonPointer = JsonConverterUtil.getPropertyValueAsString("keydetectionjsonpointer", elementNode);
                if (StringUtils.isNotEmpty((CharSequence)fixedValue)) {
                    SendEventTaskJsonConverter.addFlowableExtensionElementWithValue("keyDetectionType", "fixedValue", (FlowElement)task);
                    SendEventTaskJsonConverter.addFlowableExtensionElementWithValue("keyDetectionValue", fixedValue, (FlowElement)task);
                } else if (StringUtils.isNotEmpty((CharSequence)jsonField)) {
                    SendEventTaskJsonConverter.addFlowableExtensionElementWithValue("keyDetectionType", "jsonField", (FlowElement)task);
                    SendEventTaskJsonConverter.addFlowableExtensionElementWithValue("keyDetectionValue", jsonField, (FlowElement)task);
                } else if (StringUtils.isNotEmpty((CharSequence)jsonPointer)) {
                    SendEventTaskJsonConverter.addFlowableExtensionElementWithValue("keyDetectionType", "jsonPointer", (FlowElement)task);
                    SendEventTaskJsonConverter.addFlowableExtensionElementWithValue("keyDetectionValue", jsonPointer, (FlowElement)task);
                }
            }
        }
        return task;
    }
}

