/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local.operations;

import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.LiveSyncDelta;
import org.identityconnectors.framework.common.objects.LiveSyncDeltaBuilder;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.identityconnectors.framework.common.objects.SyncDeltaBuilder;
import org.identityconnectors.framework.common.objects.filter.AndFilter;
import org.identityconnectors.framework.common.objects.filter.AttributeFilter;
import org.identityconnectors.framework.common.objects.filter.ContainsAllValuesFilter;
import org.identityconnectors.framework.common.objects.filter.ContainsFilter;
import org.identityconnectors.framework.common.objects.filter.EndsWithFilter;
import org.identityconnectors.framework.common.objects.filter.EqualsFilter;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.common.objects.filter.GreaterThanFilter;
import org.identityconnectors.framework.common.objects.filter.GreaterThanOrEqualFilter;
import org.identityconnectors.framework.common.objects.filter.LessThanFilter;
import org.identityconnectors.framework.common.objects.filter.LessThanOrEqualFilter;
import org.identityconnectors.framework.common.objects.filter.NotFilter;
import org.identityconnectors.framework.common.objects.filter.OrFilter;
import org.identityconnectors.framework.common.objects.filter.StartsWithFilter;
import org.identityconnectors.framework.spi.AttributeNormalizer;

public final class ObjectNormalizerFacade {
    private final ObjectClass objectClass;
    private final AttributeNormalizer normalizer;

    public ObjectNormalizerFacade(ObjectClass objectClass, AttributeNormalizer normalizer) {
        Assertions.nullCheck((Object)objectClass, (String)"objectClass");
        this.objectClass = objectClass;
        this.normalizer = normalizer;
    }

    public Attribute normalizeAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (this.normalizer != null) {
            return this.normalizer.normalizeAttribute(this.objectClass, attribute);
        }
        return attribute;
    }

    public Set<Attribute> normalizeAttributes(Set<Attribute> attributes) {
        if (attributes == null) {
            return null;
        }
        HashSet<Attribute> temp = new HashSet<Attribute>();
        for (Attribute attribute : attributes) {
            temp.add(this.normalizeAttribute(attribute));
        }
        return Collections.unmodifiableSet(temp);
    }

    public ConnectorObject normalizeObject(ConnectorObject orig) {
        return new ConnectorObject(orig.getObjectClass(), this.normalizeAttributes(orig.getAttributes()));
    }

    public SyncDelta normalizeSyncDelta(SyncDelta delta) {
        SyncDeltaBuilder builder = new SyncDeltaBuilder(delta);
        Optional.ofNullable(delta.getObject()).ifPresent(o -> builder.setObject(this.normalizeObject((ConnectorObject)o)));
        return builder.build();
    }

    public LiveSyncDelta normalizeLiveSyncDelta(LiveSyncDelta delta) {
        LiveSyncDeltaBuilder builder = new LiveSyncDeltaBuilder(delta);
        Optional.ofNullable(delta.getObject()).ifPresent(o -> builder.setObject(this.normalizeObject((ConnectorObject)o)));
        return builder.build();
    }

    public Filter normalizeFilter(Filter filter) {
        if (filter instanceof ContainsFilter) {
            AttributeFilter afilter = (AttributeFilter)filter;
            return new ContainsFilter(this.normalizeAttribute(afilter.getAttribute()));
        }
        if (filter instanceof EndsWithFilter) {
            AttributeFilter afilter = (AttributeFilter)filter;
            return new EndsWithFilter(this.normalizeAttribute(afilter.getAttribute()));
        }
        if (filter instanceof EqualsFilter) {
            AttributeFilter afilter = (AttributeFilter)filter;
            return new EqualsFilter(this.normalizeAttribute(afilter.getAttribute()));
        }
        if (filter instanceof GreaterThanFilter) {
            AttributeFilter afilter = (AttributeFilter)filter;
            return new GreaterThanFilter(this.normalizeAttribute(afilter.getAttribute()));
        }
        if (filter instanceof GreaterThanOrEqualFilter) {
            AttributeFilter afilter = (AttributeFilter)filter;
            return new GreaterThanOrEqualFilter(this.normalizeAttribute(afilter.getAttribute()));
        }
        if (filter instanceof LessThanFilter) {
            AttributeFilter afilter = (AttributeFilter)filter;
            return new LessThanFilter(this.normalizeAttribute(afilter.getAttribute()));
        }
        if (filter instanceof LessThanOrEqualFilter) {
            AttributeFilter afilter = (AttributeFilter)filter;
            return new LessThanOrEqualFilter(this.normalizeAttribute(afilter.getAttribute()));
        }
        if (filter instanceof StartsWithFilter) {
            AttributeFilter afilter = (AttributeFilter)filter;
            return new StartsWithFilter(this.normalizeAttribute(afilter.getAttribute()));
        }
        if (filter instanceof ContainsAllValuesFilter) {
            AttributeFilter afilter = (AttributeFilter)filter;
            return new ContainsAllValuesFilter(this.normalizeAttribute(afilter.getAttribute()));
        }
        if (filter instanceof NotFilter) {
            NotFilter notFilter = (NotFilter)filter;
            return new NotFilter(this.normalizeFilter(notFilter.getFilter()));
        }
        if (filter instanceof AndFilter) {
            AndFilter andFilter = (AndFilter)filter;
            return new AndFilter(this.normalizeFilter(andFilter.getLeft()), this.normalizeFilter(andFilter.getRight()));
        }
        if (filter instanceof OrFilter) {
            OrFilter orFilter = (OrFilter)filter;
            return new OrFilter(this.normalizeFilter(orFilter.getLeft()), this.normalizeFilter(orFilter.getRight()));
        }
        return filter;
    }
}

